<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>@yield('title') - {{ $settings['site_title'] ?? __('Mobile Service Management') }}</title>
    @if (!empty($settings['favicon']) && check_file($settings['favicon']))
        <link rel="icon" href="{{ get_file($settings['favicon']) }}">
    @else
        <link rel="icon" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/images/favicon.png') }}">
    @endif

    <!-- Stylesheets -->
    <link rel="stylesheet" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/css/frontend/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/css/frontend/swiper-bundle.min.css') }}">
    <link rel="stylesheet" href="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/css/frontend/tailwind.css') }}">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Montserrat:wght@400;600;700&display=swap">
    @stack('styles')
</head>

<body>
    @include('mobile-service-management::frontend.partials.navigation')

    @yield('content')

    @include('mobile-service-management::frontend.partials.footer')

    <!-- Back to Top Button -->
    <button id="back-to-top" class="fixed z-10 bottom-6 end-4 border border-white md:bottom-8 md:end-8 bg-primary text-white w-10 h-10 md:w-12 md:h-12 rounded-full flex items-center justify-center shadow-xl hover:shadow-2xl hover:bg-opacity-90 transition-all duration-300 transform hover:scale-110 hidden">
        <i class="fas fa-arrow-up"></i>
    </button>

    <!-- JavaScript -->
    <script src="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/js/frontend/jquery.min.js') }}"></script>
    <script src="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/js/frontend/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('packages/workdo/MobileServiceManagement/src/Resources/assets/js/frontend/main.js') }}"></script>
    @stack('scripts')
    @stack('customer_live_chat_script')
</body>

</html>
