<?php

namespace Workdo\MobileServiceManagement\Http\Controllers;

use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;

use Workdo\MobileServiceManagement\DataTables\MobileServiceHistoryDataTable;

class MobileServiceHistoryController extends Controller
{
    public function index(MobileServiceHistoryDataTable $datatable)
    {
        if (Auth::user()->isAbleTo('mobileservice_history manage')) {
            return $datatable->render('mobile-service-management::service-history.index');
        } else {
            return redirect()->back()->with('error', __('Permission denied.'));
        }
    }
}
