<?php

namespace Workdo\MobileServiceManagement\Database\Seeders;

use App\Models\Role;
use App\Models\Permission;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class PermissionTableSeeder extends Seeder
{
    public function run()
    {
        Model::unguard();
        Artisan::call('cache:clear');
        $module = 'MobileServiceManagement';

        $oldPermissions = [
            'mobileservice manage',
            'mobileservice create',
            'mobileservice edit',
            'mobileservice delete',
            'mobileservice manage dashboard',
            'pendingrequest manage',
            'pendingrequest edit',
            'pendingrequest delete',
            'servicerequest manage',
            'servicerequest create',
            'servicerequest edit',
            'servicerequest delete',
            'servicerequest show',
            'servicerequest end',
            'trackingstatus manage',
            'trackingstatus create',
            'trackingstatus edit',
            'trackingstatus delete',
            'livetracking manage',
            'technician assign',
            'MobileServiceManagement manage',
            'mobileservice history manage',
            'mobileservice contracts manage',
            'mobileservice contracts create',
            'mobileservice contracts edit',
            'mobileservice contracts delete',
            'mobileservice policy manage',
            'mobileservice policy create',
            'mobileservice policy edit',
            'mobileservice policy delete',
        ];

        // old permission remove
        foreach ($oldPermissions as $permName) {
            $permission = Permission::where('name', $permName)->where('module', $module)->first();
            if ($permission) {
                DB::table('permission_role')->where('permission_id', $permission->id)->delete();
                DB::table('permission_user')->where('permission_id', $permission->id)->delete();
                $permission->delete();
            }
        }

        $permissions = [
            // Main Mobile Service Management
            'mobileservice manage',
            'mobileservice setup manage',
            'mobileservice theme setup manage',
            'mobileservice service setup manage',
            'mobileservice dashboard manage',
            'MobileServiceManagement manage',  // Email for need this permission

            // Service Category
            'mobileservice_servicecategory manage',
            'mobileservice_servicecategory create',
            'mobileservice_servicecategory edit',
            'mobileservice_servicecategory delete',

            // Device Brand
            'mobileservice_devicebrand manage',
            'mobileservice_devicebrand create',
            'mobileservice_devicebrand edit',
            'mobileservice_devicebrand delete',

            // Tracking Status
            'mobileservice_trackingstatus manage',
            'mobileservice_trackingstatus create',
            'mobileservice_trackingstatus edit',
            'mobileservice_trackingstatus delete',

            // Mobile Services
            'mobileservice_service manage',
            'mobileservice_service create',
            'mobileservice_service show',
            'mobileservice_service edit',
            'mobileservice_service delete',

            // Pending Requests
            'mobileservice_pendingrequest manage',
            'mobileservice_pendingrequest show',
            'mobileservice_pendingrequest approve-reject',
            'mobileservice_pendingrequest delete',

            // Service Request
            'mobileservice_servicerequest manage',
            'mobileservice_servicerequest create',
            'mobileservice_servicerequest edit',
            'mobileservice_servicerequest delete',
            'mobileservice_servicerequest show',
            'mobileservice_servicerequest end',
            'mobileservice_servicerequest livetracking manage',
            'mobileservice_servicerequest technician assign',

            // Service History
            'mobileservice_history manage',

            // Contracts
            'mobileservice_contracts manage',
            'mobileservice_contracts create',
            'mobileservice_contracts edit',
            'mobileservice_contracts delete',

            // SLA Policy
            'mobileservice_policy manage',
            'mobileservice_policy create',
            'mobileservice_policy edit',
            'mobileservice_policy delete',

            // Contact Messages
            'mobileservice_contact manage',

            // Reviews
            'mobileservice_review manage',
            'mobileservice_review delete',
        ];

        $company_role = Role::where('name', 'company')->first();
        foreach ($permissions as $key => $value) {
            $check = Permission::where('name', $value)->where('module', $module)->exists();
            if ($check == false) {
                $permission = Permission::create(
                    [
                        'name'       => $value,
                        'guard_name' => 'web',
                        'module'     => $module,
                        'created_by' => 0,
                        "created_at" => date('Y-m-d H:i:s'),
                        "updated_at" => date('Y-m-d H:i:s')
                    ]
                );
                if (!$company_role->hasPermission($value)) {
                    $company_role->givePermission($permission);
                }
            }
        }
    }
}
