<?php

namespace Workdo\MobileServiceManagement\Database\Seeders;

use App\Models\Notification;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;

class NotificationsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Model::unguard();

        // email notification
        $notifications = [
            'New Mobile Service Request',
            'Service Request Accept',
            'Service Request Reject'
        ];
        $permissions   = [
            'mobileservice manage',
            'mobileservice manage',
            'mobileservice manage'
        ];
        foreach ($notifications as $key => $n) {
            $ntfy = Notification::where('action', $n)->where('type', 'mail')->where('module', 'MobileServiceManagement')->count();
            if ($ntfy == 0) {
                $new              = new Notification();
                $new->action      = $n;
                $new->status      = 'on';
                $new->permissions = $permissions[$key];
                $new->module      = 'MobileServiceManagement';
                $new->type        = 'mail';
                $new->save();
            }
        }
    }
}
