<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('mobile_service_reviews')) {
            Schema::create('mobile_service_reviews', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('email');
                $table->integer('rating')->unsigned()->default(1);
                $table->text('review');
                $table->unsignedBigInteger('mobile_service_id')->nullable();
                $table->string('service_id')->nullable();
                $table->boolean('is_approved')->default(false);
                $table->string('workspace')->default(0);
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mobile_service_reviews');
    }
};
