<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        if (!Schema::hasTable('mobile_service_custom_pages')) {
            Schema::create('mobile_service_custom_pages', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('title');
                $table->string('slug');
                $table->longText('contents')->nullable();
                $table->boolean('show_in_footer')->default(false);
                $table->integer('workspace')->default(0);
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('mobile_service_custom_pages');
    }
};
