<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration {
    public function up()
    {
        if (!Schema::hasTable('mobile_services')) {
            Schema::create('mobile_services', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->text('description')->nullable();
                $table->string('icon')->nullable();
                $table->unsignedBigInteger('category_id');
                $table->decimal('expected_price', 10, 2)->default(0);
                $table->string('expected_duration')->nullable();
                $table->json('whats_included')->nullable();
                $table->boolean('show_in_expertise')->default(false);
                $table->boolean('show_in_footer')->default(false);
                $table->boolean('is_active')->default(1);
                $table->integer('workspace')->default(0);
                $table->integer('created_by')->default(0);
                $table->timestamps();

                $table->foreign('category_id')->references('id')->on('mobile_service_categories')->onDelete('cascade');
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('mobile_services');
    }
};
