<?php
/**
 * Zynith SEO - A powerful yet lightweight SEO plugin designed for maximum efficiency and to streamline SEO management for optimal search engine results.
 *
 * @package           PluginPackage
 * @author            Zynith SEO
 * @copyright         2023-2024 Zynith SEO
 * @license           GPL-3.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       Zynith SEO
 * Plugin URI:        https://www.persianscript.ir/
 * Description:       A powerful yet lightweight SEO plugin designed for maximum efficiency and to streamline SEO management for optimal search engine results.
 * Version:           8.1.9
 * Author:            پرشین اسکریپت
 * Author URI:        https://www.persianscript.ir/
 * Text Domain:       zynith-seo
 * Contributors:      Schieler Mew, Kellie Watson, Daniel Nielsen
 * License:           GPL-3.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-3.0.html
 * Tested up to:      6.5.3
 * Requires at least: 5.0
 * Requires PHP:      7.4
 * Donate link:       https://www.paypal.com/donate/?hosted_button_id=XVXQ3RX7N4SQN
 * Tags:              SEO, XML sitemap, Schema Markup, Meta Tags, Robots.txt, SEO Signals, WordPress SEO, Breadcrumbs, TOC
 * Support:           https://www.facebook.com/groups/761871078859984
 * Note:              Modifying the plugin's source code is not recommended. If modifications are necessary, please adhere to WordPress coding standards and best practices to prevent issues.
 */
defined('ABSPATH') or exit;

define('ZYNITH_SEO_IN_DEVELOPMENT', false);
define('ZYNITH_SEO_VERSION', '8.1.9');
define('ZYNITH_SEO_TEXT_DOMAIN', 'zynith-seo');
define('ZYNITH_SEO_TEXT_PREFIX', 'zynith_');
define('ZYNITH_SEO_NAME', 'Zynith SEO');
define('ZYNITH_SEO_FILE', __FILE__);
define('ZYNITH_SEO_SLUG', plugin_basename(__DIR__));
define('ZYNITH_SEO_UPDATE_URL', 'https://zynith.app/wp-json/zynith/v1/update-info/');
define('ZYNITH_SEO_IS_WOOCOMMERCE', (bool)class_exists('WooCommerce'));

if (!defined('ZYNITH_SEO_ICON')) define('ZYNITH_SEO_ICON', 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48c3ZnIGlkPSJMYXllcl8yIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHhtbG5zOnhsaW5rPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5L3hsaW5rIiB2aWV3Qm94PSIwIDAgMTguNzQgMjAiPjxkZWZzPjxzdHlsZT4uY2xzLTF7ZmlsbDp1cmwoI2xpbmVhci1ncmFkaWVudCk7c3Ryb2tlLXdpZHRoOjBweDt9PC9zdHlsZT48bGluZWFyR3JhZGllbnQgaWQ9ImxpbmVhci1ncmFkaWVudCIgeDE9Ii0yLjQ1IiB5MT0iLTUxLjkiIHgyPSIxNi4yOSIgeTI9Ii01MS45IiBncmFkaWVudFRyYW5zZm9ybT0idHJhbnNsYXRlKDAgLTQxLjkpIHNjYWxlKDEgLTEpIiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+PHN0b3Agb2Zmc2V0PSIwIiBzdG9wLWNvbG9yPSIjMjg1YmQxIi8+PHN0b3Agb2Zmc2V0PSIxIiBzdG9wLWNvbG9yPSIjZWEzM2YyIi8+PC9saW5lYXJHcmFkaWVudD48L2RlZnM+PGcgaWQ9IkxheWVyXzItMiI+PHBhdGggY2xhc3M9ImNscy0xIiBkPSJNOC43LDE1LjUzQzEyLjAxLDEwLjQyLDE1LjMyLDUuMzEsMTguNjMuMiwxMi43Ny4xMiw4LjM4LjEsNi4yOC4wMWMtLjQxLS4wMi0xLjY1LS4wNy0zLjA3LjQ2LS41NS4yMS0xLjMuNS0xLjk3LDEuMkMuMjEsMi43NC4wNCw0LjA3LDAsNC42MWgxMC4wMkM2LjcsOS43NCwzLjM4LDE0Ljg3LjA2LDIwaDEzLjY5Yy41NC0uMDEsMi4xOS0uMTIsMy41My0xLjMyLjMzLS4yOS45OC0uODksMS4yOS0xLjkxLjE1LS40Ny4xOC0uODkuMTgtMS4xNy0zLjM1LS4wMi02LjctLjA0LTEwLjA1LS4wNmgwWk0xNi45NSwxNy43aDBzLS4zOC40MS0uODQuNzNjLTEuMTQuOC0zLjA3Ljg1LTMuMDcuODUtMS4yMy4wMy01LjU3LjEyLTExLjYxLjAyQzYuNywxMS4yMiwxMC41MSw1LjM5LDEwLjgsNS4wMWMuMDMtLjA1LjItLjI1LjE5LS41MiwwLS4wMy0uMDEtLjI4LS4xOS0uNDUtLjIzLS4yMi0uNTktLjItLjY5LS4xOS0uNi4wNC00LjIzLjA2LTkuMjMuMS4xNC0uNDguNTctMS42OSwxLjcxLTIuNC43OC0uNDgsMS43MS0uNjIsMi4wOS0uNjcuMzYtLjA1LjY3LS4wNy44OS0uMDcsMy44My4wOCw3LjY2LjE3LDExLjQ4LjI1LTMuMDksNC43My02LjE4LDkuNDctOS4yNiwxNC4yLS4wMy4wOS0uMS4zMS0uMDQuNTguMDIuMDcuMDguMzIuMjkuNTEuMDcuMDYuMjUuMTkuNTguMjIuNTIuMDQsNC4wNS4wNSw4LjksMC0uMDguMjctLjI0LjctLjU4LDEuMTNoMFoiLz48L2c+PC9zdmc+');

register_activation_hook(ZYNITH_SEO_FILE, 'zynith_seo_activate');

function zynith_seo_activate() {
    require_once plugin_dir_path(ZYNITH_SEO_FILE) . 'classes/Zynith_SEO_DB_Handler.php';
    $db_handler = new Zynith_SEO_DB_Handler();
    $db_handler->handleDatabaseOperations();
}

class Zynith_SEO_Plugin {
	
	private static $instance;
	
	public static function init() {
        if (null === self::$instance) self::$instance = new self();
        return self::$instance;
    }
	
	private function __construct() {
        add_filter('plugin_action_links_' . plugin_basename(ZYNITH_SEO_FILE), [$this, 'action_links']);
		$this->register_autoloader();
    }
	
	public function action_links($links) {
        $settings_link = '<a href="' . esc_url(admin_url('admin.php?page=zynith-seo-settings')) . '">' . __('Settings', ZYNITH_SEO_TEXT_DOMAIN) . '</a>';
        array_unshift($links, $settings_link);
        return $links;
    }
	
	private function register_autoloader() {
        $classes = glob(__DIR__ . '/classes/*.php', GLOB_NOSORT);
        foreach ($classes as $class) include_once($class);
    }
	
}

Zynith_SEO_Plugin::init();
Zynith_SEO_Settings::init();
Zynith_SEO_Post_Types::init();
Zynith_SEO_Taxonomies::init();
Zynith_SEO_Authors::init();
Zynith_SEO_Sitemap::init();
Zynith_SEO_WP_Mods::init();
Zynith_SEO_Category_Base::init();
Zynith_SEO_TOC::init();
Zynith_SEO_Breadcrumbs::init();
Zynith_SEO_Import::init();
Zynith_SEO_Schema::init();
Zynith_SEO_Script_Manager::init();
Zynith_SEO_404_Monitor::init();
Zynith_SEO_Meta_Boxes::init();
Zynith_SEO_Images::init();
Zynith_SEO_Content::init();
Zynith_SEO_Updater::init();
Zynith_SEO_Remove_Genesis_SEO::init();