<?php
defined('ABSPATH') or exit;

class Zynith_SEO_WP_Mods {
	
	public static function init() {
		return new self();
	}
    
	public function __construct() {
        add_action('init', [$this, 'remove_generator_tags']);
        add_action('init', [$this, 'remove_rss_feeds']);
        add_action('init', [$this, 'disable_media_endpoint']);
        add_action('init', [$this, 'disable_gutenberg_editor']);
    }
	
    public function remove_generator_tags() {
        if (is_admin()) return;
        $remove_generator = get_option('zynith_remove_generator_tags', false);
        if ($remove_generator) {
            remove_action('wp_head', 'wc_generator');
            remove_action('wp_head', 'wp_generator');
        }
    }

    public function remove_rss_feeds() {
        if (is_admin()) return;
        $remove_feeds = get_option('zynith_remove_rss_feeds', false);
        if ($remove_feeds) {
            add_action('do_feed_rdf', [$this, 'redirect_feeds'], 1);
            add_action('do_feed_rss', [$this, 'redirect_feeds'], 1);
            add_action('do_feed_rss2', [$this, 'redirect_feeds'], 1);
            add_action('do_feed_atom', [$this, 'redirect_feeds'], 1);
            add_action('do_feed_rss2_comments', [$this, 'redirect_feeds'], 1);
            add_action('do_feed_atom_comments', [$this, 'redirect_feeds'], 1);
            remove_action('wp_head', 'feed_links_extra', 3);
            remove_action('wp_head', 'feed_links', 2);
        }
    }

    public function redirect_feeds() {
        wp_redirect(home_url());
        exit;
    }

    public function disable_media_endpoint() {
        $disable_media = get_option('zynith_disable_media_endpoint', false);
        if ($disable_media) {
            add_filter('rest_endpoints', function($endpoints) {
				if (isset($endpoints['/wp/v2/media'])) if (!current_user_can('edit_posts')) unset($endpoints['/wp/v2/media']);
				return $endpoints;
			});
        }
    }

    public function disable_gutenberg_editor() {
        $disable_gutenberg = get_option('zynith_disable_gutenberg_editor', false);
        if ($disable_gutenberg) add_filter('use_block_editor_for_post', '__return_false');
    }
}