<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Updater {

    public $version;
    public $cache_key;
    public $cache_allowed;

	public static function init() {
        return new self();
    }
	
    public function __construct() {
        if (!is_admin()) return;
		$this->cache_key = 'zynith_custom_updater';
        $this->cache_allowed = true;
        $force_check_updates = filter_input(INPUT_GET, 'force-check');
        if (!empty($force_check_updates)) delete_transient($this->cache_key);
        add_filter('plugins_api', [$this, 'info'], 20, 3);
        add_filter('site_transient_update_plugins', [$this, 'update']);
        add_action('upgrader_process_complete', [$this, 'purge'], 10, 2);
        add_action('in_plugin_update_message-' . plugin_basename(ZYNITH_SEO_FILE), [$this, 'add_custom_message'], 20, 2);
    }
    
    public function add_custom_message($plugin_data, $response) {
        if (empty($response->package)) {
            echo '<br>' . sprintf(__("To enable updates, please enter a valid license key on the %sLicense%s page. If you don't have a licence key, please %sobtain one here%s.", ZYNITH_SEO_TEXT_DOMAIN),
                '<a href="' . admin_url('/admin.php?page=zynith-seo-settings&tab=zynith_seo_settings') . '">', '</a>', '<a href="https://zynith.app/" target="_blank">', '</a>');
        }
    }

    public function request() {
        $remote = get_transient($this->cache_key);
        if(false === $remote || ! $this->cache_allowed) {
            $license_key = get_option('zynith_license_key');
            $remote = wp_remote_get(ZYNITH_SEO_UPDATE_URL . '?cc=' . time(),
                [
                    'timeout' => 10,
                    'headers' => [
                        'Accept' => 'application/json',
                        'X-Zynith-License' => $license_key
                    ]
                ]);
            if(is_wp_error($remote) || 200 !== wp_remote_retrieve_response_code($remote) || empty(wp_remote_retrieve_body($remote))) return false;
            set_transient($this->cache_key, $remote, DAY_IN_SECONDS);
        }
		return json_decode(wp_remote_retrieve_body($remote));
    }

    function info($res, $action, $args) {
        if('plugin_information' !== $action) return $res;
        if(ZYNITH_SEO_SLUG !== $args->slug) return $res;
        $remote = $this->request();
        if(!$remote) return $res;
        $res = new stdClass();
        $res->name = $remote->name;
        $res->slug = $remote->slug;
        $res->version = $remote->version;
        $res->tested = $remote->tested;
        $res->requires = $remote->requires;
        $res->author = $remote->author;
        $res->author_profile = $remote->author_profile;
        $res->download_link = $remote->download_url;
        $res->trunk = $remote->download_url;
        $res->requires_php = $remote->requires_php;
        $res->last_updated = $remote->last_updated;
        $res->rating = $remote->rating;
        $res->num_ratings = $remote->num_ratings;
        $res->sections = [
            'description' => $remote->sections->description,
            'installation' => $remote->sections->installation,
			'faq' => $remote->sections->faq,
            'changelog' => $remote->sections->changelog
        ];
        if(!empty($remote->banners)) $res->banners = ['low' => $remote->banners->low, 'high' => $remote->banners->high];
        return $res;
    }

    public function update($transient) {
        if (empty($transient->checked)) return $transient;        
		$remote = $this->request();
        if($remote && version_compare(ZYNITH_SEO_VERSION, $remote->version, '<') && version_compare($remote->requires, get_bloginfo('version'), '<=') && version_compare($remote->requires_php, PHP_VERSION, '<')) {
            $res = new stdClass();
            $res->slug = ZYNITH_SEO_SLUG;
            $res->plugin = plugin_basename(ZYNITH_SEO_FILE);
            $res->new_version = $remote->version;
            $res->tested = $remote->tested;
            $res->package = $remote->download_url;
            $transient->response[ $res->plugin ] = $res;
        }
        return $transient;
    }

    public function purge($upgrader, $options) {
        if ($this->cache_allowed && 'update' === $options['action'] && 'plugin' === $options[ 'type' ]) delete_transient($this->cache_key);
    }
}