<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Taxonomies {
	
	public static function init() {
        return new self();
    }
	
	public function __construct() {
        add_action("admin_init", [$this, 'add_form_fields']);
	}

    public function add_form_fields() {
        $all_taxonomies = self::get_taxonomies();
        foreach (array_keys($all_taxonomies) as $taxonomy) {
            add_action("{$taxonomy}_edit_form_fields", [$this, 'zynith_seo_metabox'], 85);
            add_action("edited_{$taxonomy}", [$this, 'save_metabox']);
        }
    }

    public static function get_taxonomies() {
        $builtin_taxonomies = get_taxonomies(['_builtin' => true, 'public' => true], 'objects');
        $custom_taxonomies = get_taxonomies(['_builtin' => false, 'public' => true], 'objects');
		$taxonomies_return = [];
		unset($builtin_taxonomies['post_format']);
		$taxonomies_initial = $builtin_taxonomies + $custom_taxonomies;
		foreach ($taxonomies_initial as $taxonomy) {
			$taxonomies_return[$taxonomy->name] = [
				'label' => $taxonomy->label,
				'handle_left' => __('Default', ZYNITH_SEO_TEXT_DOMAIN),
				'handle_right' => __('Apply', ZYNITH_SEO_TEXT_DOMAIN)
			];
		}
		return $taxonomies_return;
    }

	public function zynith_seo_metabox($term) {
        wp_nonce_field('seo_metabox_nonce_action', 'seo_metabox_nonce');
        echo '</table><div id="zynith_seo_metabox" class="postbox">
        <div class="postbox-header"><h2>' . __('Zynith SEO', ZYNITH_SEO_TEXT_DOMAIN) . '</h2></div>
        <div class="inside">' . Zynith_SEO_Meta_Boxes::get_zynith_seo_metabox($term, 'taxonomy') . '</div>
        </div>';
    }
    
    public function save_metabox($term_id) {
        if (!isset($_POST['seo_metabox_nonce']) || !wp_verify_nonce($_POST['seo_metabox_nonce'], 'seo_metabox_nonce_action')) return;
        if (!isset($_POST['dynamic_schema_meta_box_nonce']) || !wp_verify_nonce($_POST['dynamic_schema_meta_box_nonce'], 'dynamic_schema_save_postdata')) return;
        $meta_title = sanitize_text_field($_POST['custom_meta_title']);
        $meta_description = sanitize_textarea_field($_POST['custom_meta_description']);
        $noindex = isset($_POST['custom_noindex']) && $_POST['custom_noindex'] == 'on' ? 'yes' : 'no';
        $nofollow = isset($_POST['custom_nofollow']) && $_POST['custom_nofollow'] == 'on' ? 'yes' : 'no';
        $schema = sanitize_textarea_field($_POST['custom_schema']);
        $target_keyword = sanitize_text_field($_POST['custom_target_keyword']);
        $meta_og_image = sanitize_text_field($_POST['custom_meta_og_image']);
        update_term_meta($term_id, '_custom_meta_title', $meta_title);
        update_term_meta($term_id, '_custom_meta_description', $meta_description);
        update_term_meta($term_id, '_custom_noindex', $noindex);
        update_term_meta($term_id, '_custom_nofollow', $nofollow);
        update_term_meta($term_id, '_custom_schema', $schema);
        update_term_meta($term_id, '_custom_target_keyword', $target_keyword);
        update_term_meta($term_id, '_custom_meta_og_image', $meta_og_image);
    }
}