<?php
defined('ABSPATH') or exit;

class Zynith_SEO_TOC {

    public $args;

	public static function init() {
		 return new self();
	 }
	
    public function __construct() {
        $this->args = apply_filters('zynith_toc_args', [
            'wrap_start' => '<details class="zynith-toc"><summary>' . get_option('zynith_toc_heading_text') . '</summary>',
            'wrap_end' => '</details>',
        ]);
		add_shortcode('zynith-toc', [$this, 'generate_toc']);
		add_filter('the_content', [$this, 'maybe_add_ids_to_headings']);
    }

    public function maybe_add_ids_to_headings($content) {
        if (has_shortcode($content, 'zynith-toc')) $content = $this->add_ids_to_headings($content);
        return $content;
    }

    public function generate_toc() {
        $post = get_post();
		if (empty($post)) return;

		$content = $this->add_ids_to_headings($post->post_content);
		preg_match_all('/<h([1-6]).*?id="(.*?)".*?>(.*?)<\/h\1>/s', $content, $matches, PREG_SET_ORDER);
		if (empty($matches)) return '';
		
		$tocCss = get_option('zynith_toc_css');
		if ($tocCss === '') {
			$tocCss = '<style>
details.zynith-toc > * {
	transition: max-height 0.5s ease-in-out;
    overflow: auto;
}
details.zynith-toc[open] > * { max-height: 500px; }
details.zynith-toc:not([open]) > * { max-height: 44px; }
details.zynith-toc {
	max-width: 100%;
	width: fit-content;
	border: 1px solid gray;
    padding: 20px;
}
details.zynith-toc > summary {
	font-size: 1.3em;
	cursor: pointer;
}
.zynith-toc ul {
	margin: 5px 0;
	padding: 0;
	list-style-type: none;
}
.zynith-toc li { margin-bottom: 0; }
.zynith-toc .toc-h1 { padding: 6px 0 0 6px; font-size: 110%; }
.zynith-toc .toc-h2 { padding: 5px 0 0 22px; }
.zynith-toc .toc-h3 { padding: 4px 0 0 33px; font-size: 90%; }
.zynith-toc .toc-h4 { padding: 3px 0 0 44px; font-size: 90%; }
.zynith-toc .toc-h5 { padding: 2px 0 0 55px; font-size: 80%; }
.zynith-toc .toc-h6 { padding: 1px 0 0 66px; font-size: 80%; }
</style>';
		}
		else {
			$tocCss = '<style>' . $tocCss . '</style>';
		}
		$output = $this->args['wrap_start'] . '<ul>';
		$currentLevel = 0;
		foreach ($matches as $match) {
            $level = intval($match[1]);
            $id = $match[2];
            $title = wp_strip_all_tags($match[3]);
			while ($currentLevel < $level) {
				$output .= '<ul>';
				$currentLevel++;
			}
			while ($currentLevel > $level) {
				$output .= '</ul>';
				$currentLevel--;
			}
			if (get_option('zynith_toc_heading_' . $level . '_enabled', 1) == 1) $output .= "<li class=\"toc-h{$level}\"><a href=\"#{$id}\">{$title}</a></li>";
        }
		while ($currentLevel > 0) {
			$output .= '</ul>';
			$currentLevel--;
		}
		$output .= '</ul>' . $this->args['wrap_end'];
		return $tocCss . $output;
    }

    public function add_ids_to_headings($content) {
		$dom = new DOMDocument();
		$previousLibxmlSetting = libxml_use_internal_errors(true);
		$dom->loadHTML('<?xml encoding="UTF-8">' . $content, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
    	
		libxml_clear_errors();
		libxml_use_internal_errors($previousLibxmlSetting);
		
		$uniqueIds = [];
		foreach (['h1', 'h2', 'h3', 'h4', 'h5', 'h6'] as $tag) {
			$headings = $dom->getElementsByTagName($tag);
			foreach ($headings as $heading) {
				$sanitizedText = strtolower(trim(preg_replace('/[^a-zA-Z0-9]+/', '-', $heading->textContent), '-'));
				$id = $sanitizedText;
				$counter = 1;
				while (in_array($id, $uniqueIds)) $id = $sanitizedText . '-' . $counter++;
				$uniqueIds[] = $id;
				$heading->setAttribute('id', $id);
			}
		}
		return $dom->saveHTML();
    }
}