<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Schema {
    
	public static function init() {
		return new self();
	}
	
	public function __construct() {
		add_action('admin_menu', [$this, 'add_schema_templates_pages'], 99);
		add_action('admin_enqueue_scripts', [$this, 'enqueue_schema_scripts']);
	}
    
    public function add_schema_templates_pages() {
        add_submenu_page(
            'zynith-seo-settings',
            __('Schema Templates', ZYNITH_SEO_TEXT_DOMAIN),
            __('Schema Templates', ZYNITH_SEO_TEXT_DOMAIN),
            'manage_options',
            'schema-templates',
            [$this, 'custom_schema_page_html']
        );
    }
	
    public function custom_schema_page_html() {
		$templates = get_option('custom_schema_templates', []);
		$selected_index = -1;
    	$new_template_name = '';
        if (isset($_POST['save_template_name']) && isset($_POST['template_schema'])) {
            $name = stripslashes(sanitize_text_field($_POST['save_template_name']));
			$schema = wp_unslash(wp_kses_post($_POST['template_schema']));
            $edit_index = isset($_POST['edit_template_index']) ? intval($_POST['edit_template_index']) : -1;
            if ($edit_index >= 0 && $edit_index < count($templates)) {
                $templates[$edit_index]['name'] = $name;
                $templates[$edit_index]['schema'] = $schema;
				$new_template_name = $name;
            }
			else {
                $templates[] = ['name' => $name, 'schema' => $schema];
				$new_template_name = $name;
            }
            update_option('custom_schema_templates', $templates);
        }
		if (isset($_POST['duplicate_template_index'])) {
			$index = intval($_POST['duplicate_template_index']);
			if (isset($templates[$index])) {
				$new_template = $templates[$index];
				$new_template['name'] .= ' - Copy';
				$templates[] = $new_template;
				$new_template_name = $new_template['name'];
				update_option('custom_schema_templates', $templates);
			}
		}
		if (isset($_POST['delete_template_index'])) {
        	$index = intval($_POST['delete_template_index']);
			array_splice($templates, $index, 1);
			update_option('custom_schema_templates', $templates);
			$selected_index = -1;
        }
		usort($templates, function($a, $b) {
        	return strcmp($a['name'], $b['name']);
    	});
		update_option('custom_schema_templates', $templates);
		$templates = get_option('custom_schema_templates', []);
		if ($new_template_name !== '') {
			foreach ($templates as $index => $template) {
				if ($template['name'] === $new_template_name) {
					$selected_index = $index;
					break;
				}
			}
		}
		$html = '<div class="wrap zynith-wrap">
		<header>
			<img src="' . ZYNITH_SEO_ICON . '" alt="Zynith SEO" height="30" width="30">
			<h1>' . __('Schema Templates', ZYNITH_SEO_TEXT_DOMAIN) . '</h1>
		</header>
		<p>' . __('Create and save custom schema templates which can be applied selectively on different pages, allowing you to optimize how search engines understand and display your content on a per-page basis.', ZYNITH_SEO_TEXT_DOMAIN) . '</p>
		<div class="postbox">
			<form id="form_schema_template" method="POST" onsubmit="">
				<p>' . __('Enter a new schema template name or choose an existing template to edit or delete.', ZYNITH_SEO_TEXT_DOMAIN) . '</p>';
		if (!empty($templates)) {
            $html .= '<label for="existing_template_selector">' . __('Select an existing schema template:', ZYNITH_SEO_TEXT_DOMAIN) . '</label>
					<select id="existing_template_selector" name="existing_template_selector" onchange="populate_template_fields()">
						<option value="">- ' . __('No Template Selected', ZYNITH_SEO_TEXT_DOMAIN) . ' -</option>';
            foreach ($templates as $index => $template) $html .= '<option value="' . $index . '"' . ($index === $selected_index ? ' selected' : '') . '>' . esc_html($template['name']) . '</option>';
            $html .= '</select><button type="button" class="button-secondary" onclick="duplicate_template()">Duplicate</button><button type="button" class="button-secondary" onclick="delete_template()">Delete</button>';
        }
		$html .= '<div>
					<label for="save_template_name">' . __('Template name:', ZYNITH_SEO_TEXT_DOMAIN) . '</label>
					<input type="text" class="regular-text" id="save_template_name" name="save_template_name" placeholder="' . __('Template Name', ZYNITH_SEO_TEXT_DOMAIN) . '" required />
				</div>
				<label for="template_schema">' . __('Schema Template:', ZYNITH_SEO_TEXT_DOMAIN) . '</label>
				<textarea class="code" id="template_schema" name="template_schema" rows="10" placeholder="' . __('Schema Template', ZYNITH_SEO_TEXT_DOMAIN) . '" required></textarea>
				<button type="submit" class="button-primary">' . __('Save Template', ZYNITH_SEO_TEXT_DOMAIN) . '</button>
			</form>
			<script>
				let templates = ' . json_encode($templates) . '
				let selected_index = ' . $selected_index . '
				function populate_template_fields() {
					let index = document.getElementById("existing_template_selector").value;
					let template = templates[index];
					let form = document.getElementById("form_schema_template");
					let editIndexInput = document.getElementById("edit_template_index");
					if (index !== "") {
						document.getElementById("save_template_name").value = template.name;
						document.getElementById("template_schema").value = template.schema;
						if (!editIndexInput) {
							editIndexInput = document.createElement("input");
							editIndexInput.type = "hidden";
							editIndexInput.id = "edit_template_index";
							editIndexInput.name = "edit_template_index";
							form.appendChild(editIndexInput);
						}
						editIndexInput.value = index;
					}
					else {
						document.getElementById("save_template_name").value = "";
						document.getElementById("template_schema").value = "";
						if (editIndexInput) form.removeChild(editIndexInput);
					}
				}
				window.onload = function() {
					if (selected_index !== -1) populate_template_fields();
				}
			</script>
			<div class="inside">
				<p>Note: you can use the following placeholder variables for insertion in your schema:</p>
				<ul class="quicktags">
					<li>Page/Post Title: <code>%%title%%</code></li>
					<li>Page/Post URL: <code>%%post_url%%</code></li>
					<li>Page/Post Date Published: <code>%%date%%</code></li>
					<li>Page/Post Date Modified: <code>%%modified%%</code></li>
					<li>Page/Post Thumbnail URL: <code>%%post_thumbnail_url%%</code></li>
					<li>Page/Post Excerpt: <code>%%post_excerpt%%</code></li>
					<li>Page/Post Title Tag: <code>%%title_tag%%</code></li>
					<li>Page/Post Meta Description: <code>%%meta_description%%</code></li>
					<li>Page/Post Target Keyword: <code>%%target_keyword%%</code></li>
					<li>Site Title: <code>%%sitetitle%%</code></li>
					<li>Site Tagline: <code>%%tagline%%</code></li>
					<li>Site Home Page URL: <code>%%home_url%%</code></li>
					<li>Business Name: <code>%%business_name%%</code></li>
					<li>Business Logo URL: <code>%%logo_url%%</code></li>
					<li>Business Email: <code>%%business_email%%</code></li>
					<li>Business Phone: <code>%%business_phone%%</code></li>
					<li>Business Street Address: <code>%%street_address%%</code></li>
					<li>Business Locality (e.g. State): <code>%%locality%%</code></li>
					<li>Business Region (e.g. Suburb): <code>%%region%%</code></li>
					<li>Business Post Code: <code>%%postal_code%%</code></li>
					<li>Country Name: <code>%%country_name%%</code></li>
					<li>Country Code: <code>%%country_code%%</code></li>
					<li>Current Year: <code>%%currentyear%%</code></li>
				</ul>
			</div>
			</div>
			</div><!-- End: .wrap -->';
		echo $html;
    }
	
	public function enqueue_schema_scripts($hook) {
		if ($hook !== ZYNITH_SEO_TEXT_DOMAIN .'_page_schema-templates') return;
		$current_version = defined('ZYNITH_SEO_IN_DEVELOPMENT') && ZYNITH_SEO_IN_DEVELOPMENT ? time() : ZYNITH_SEO_VERSION;
		$script_url = plugin_dir_url(ZYNITH_SEO_FILE) . 'assets/' . ZYNITH_SEO_TEXT_DOMAIN . '-admin-schema.js';
		wp_enqueue_script(ZYNITH_SEO_TEXT_DOMAIN . '-admin-schema', $script_url, [], $current_version, true);
		$templates = get_option('custom_schema_templates', []);
		$selected_index = -1;
		if (isset($_POST['edit_template_index'])) $selected_index = intval($_POST['edit_template_index']);
		wp_localize_script(ZYNITH_SEO_TEXT_DOMAIN . '-admin-schema', 'templateData', [
			'templates' => $templates,
			'selected_index' => $selected_index,
		]);
	}
}