<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Remove_Genesis_SEO {

	public static function init() {
        if (defined('GENESIS_LOADED_FRAMEWORK')) return;
        return new self();
    }
	
    public function __construct() {
        add_action('after_setup_theme', [$this, 'remove_genesis_seo_settings_menu']);
        add_action('init', [$this, 'remove_genesis_elements']);
        add_action('init', [$this, 'disable_genesis_schema']);
        add_action('init', [$this, 'remove_author_meta']);
        add_action('admin_init', [$this, 'remove_genesis_tax_intro'], 11);
        add_filter('genesis_detect_seo_plugins', [$this, 'remove_genesis_seo']);
    }

    public function remove_genesis_seo($disabled) {
        $disabled['constants'][] = 'ZYNITH_SEO_VERSION';
        return $disabled;
    }

    public function remove_genesis_tax_intro() {
        $taxonomies = get_taxonomies(['public' => true,]);
        if (empty($taxonomies)) return;
        foreach ($taxonomies as $tax_name) remove_action($tax_name . '_edit_form', 'genesis_taxonomy_archive_options', 10);
    }

    public function remove_genesis_elements() {
        if (!is_admin()) return;
        $builtin_post_types = ['post', 'page'];
        $custom_post_types = get_post_types(['_builtin' => false]);
        $all_post_types = array_values($builtin_post_types + $custom_post_types);
        foreach ($all_post_types as $post_type) remove_post_type_support($post_type , 'genesis-scripts');
    }
	
	public function disable_genesis_schema() {
        $disable = ['head', 'body', 'site-header', 'site-title', 'site-description', 'breadcrumb', 'breadcrumb-link-wrap', 'breadcrumb-link-wrap-meta', 'breadcrumb-link', 'breadcrumb-link-text-wrap', 'search-form', 'search-form-meta', 'search-form-input', 'nav-primary', 'nav-secondary', 'nav-header', 'nav-link-wrap', 'nav-link', 'entry', 'entry-image', 'singular-entry-image', 'entry-image-widget', 'entry-image-grid-loop', 'entry-author', 'entry-author-link', 'entry-author-name', 'entry-time', 'entry-modified-time', 'entry-title', 'entry-content', 'comment', 'comment-author', 'comment-author-link', 'comment-author-name', 'comment-time', 'comment-time-link', 'comment-content', 'author-box', 'sidebar-primary', 'sidebar-secondary', 'site-footer'];
        foreach($disable as $element) add_filter('genesis_attr_' . $element, [$this, 'remove_schema_attributes'], 20);
    }
	
	public function remove_schema_attributes($attr) {
		unset($attr['itemprop'], $attr['itemtype'], $attr['itemscope']);
		return $attr;
	}

    public function remove_author_meta() {
        remove_action('show_user_profile', 'genesis_user_seo_fields');
        remove_action('edit_user_profile', 'genesis_user_seo_fields');
    }

    public function remove_genesis_seo_settings_menu() {
        remove_theme_support('genesis-seo-settings-menu');
    }
}