<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Post_Types {
	
	public static function init() {
		return new self();
	}
	
	public function __construct() {
		add_filter('manage_posts_columns', [$this, 'add_meta_columns']);
        add_filter('manage_pages_columns', [$this, 'add_meta_columns']);
        add_action('manage_posts_custom_column', [$this, 'display_meta_columns'], 10, 2);
        add_action('manage_pages_custom_column', [$this, 'display_meta_columns'], 10, 2);
        add_action('wp_ajax_save_meta_data', [ $this, 'save_meta_columns' ]);			
		if (!has_action('clone_post')) {
			add_filter('post_row_actions', [$this, 'add_clone_link'], 10, 2);
			add_filter('page_row_actions', [$this, 'add_clone_link'], 10, 2);
			add_action('admin_init', [$this, 'clone_post']);
		}
	}
    
	public function add_meta_columns($columns) {
        $columns['meta_title'] = __('Meta Title', ZYNITH_SEO_TEXT_DOMAIN);
        $columns['meta_description'] = __('Meta Description', ZYNITH_SEO_TEXT_DOMAIN);
        return $columns;
    }
	
	public function display_meta_columns($column, $post_id) {
		?>
        	<style>.editable {cursor: pointer;min-height: 19px;padding: 11px;width: 90%;font-size: 15px;box-shadow: 0 0 0 transparent;border-radius: 4px;border: 1px solid #a7aaaf;background-color: #fff;color: #2c3338;}</style>
            <script>
            jQuery(document).ready(function ($) {
                function save_meta_data(post_id, meta_key, meta_value) {
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'save_meta_data',
                            post_id: post_id,
                            meta_key: meta_key,
                            meta_value: meta_value,
                            nonce: customAdminScript.nonce
                        },
                        success: function (response) {
                            console.log(response);
                        },
                        error: function (error) {
                            console.error(error);
                        }
                    });
                }
                $('body').on('click', '.editable', function () {
                    var originalContent = $(this).text();
                    var post_id = $(this).data('post-id');
                    var meta_key = $(this).data('meta-key');
    
                    $(this).attr('contenteditable', 'true').focus().addClass('editing');
    
                    $(this).on('blur keydown', function (e) {
                        if (e.type === 'blur' || e.which === 13) {
                            e.preventDefault();
    
                            if ($(this).text() !== originalContent) {
                                save_meta_data(post_id, meta_key, $(this).text());
                            }
    
                            $(this).removeAttr('contenteditable').removeClass('editing');
                        }
                    });
                });
            });
            </script>
		<?php
        switch ($column) {
            case 'meta_title':
                $meta_title = get_post_meta($post_id, '_custom_meta_title', true);
                echo '<div class="editable" data-post-id="' . esc_attr($post_id) . '" data-meta-key="_custom_meta_title">' . esc_html($meta_title) . '</div>';
                break;
            case 'meta_description':
                $meta_description = get_post_meta($post_id, '_custom_meta_description', true);
                echo '<div class="editable" data-post-id="' . esc_attr($post_id) . '" data-meta-key="_custom_meta_description">' . esc_html($meta_description) . '</div>';
                break;
        }
    }
    
	public static function get_post_types() {
        $post_types_initial = get_post_types(['public' => true], 'objects');
		$post_types_return = [];
		
		error_log('Post Types Fetched: ' . print_r($post_types_initial, true));
		
		unset($post_types_initial['attachment']);
		foreach ($post_types_initial as $post_type) $post_types_return[$post_type -> name] = ['label' => $post_type->label];
		return $post_types_return;
    }
	
    public function save_meta_columns() {
        check_ajax_referer('save_meta_data_nonce', 'nonce');
        $post_id = intval($_POST['post_id']);
        $meta_key = sanitize_text_field($_POST['meta_key']);
        $meta_value = sanitize_text_field($_POST['meta_value']);
        update_post_meta($post_id, $meta_key, $meta_value);
        wp_send_json_success(['message' => __('Meta data saved successfully.', ZYNITH_SEO_TEXT_DOMAIN)]);
    }
	
	public function add_clone_link($actions, $post) {
		if (current_user_can('edit_posts')) $actions['clone'] = '<a href="' . wp_nonce_url('admin.php?action=clone_post&amp;post=' . $post->ID, basename(__FILE__), 'clone_nonce') . '" title="Clone this item" rel="permalink">Clone</a>';
		return $actions;
	}
	
	public function clone_post() {
		if (isset($_GET['clone_nonce']) && wp_verify_nonce($_GET['clone_nonce'], basename(__FILE__))) {
			$post_id = isset($_GET['post']) ? absint($_GET['post']) : 0;
			$post = get_post($post_id);
			if (isset($post) && $post != null) {
				$args = ['comment_status' => $post->comment_status,
					'ping_status'    => $post->ping_status,
					'post_author'    => $post->post_author,
					'post_content'   => $post->post_content,
					'post_excerpt'   => $post->post_excerpt,
					'post_name'      => $post->post_name . '-copy',
					'post_parent'    => $post->post_parent,
					'post_password'  => $post->post_password,
					'post_status'    => 'draft',
					'post_title'     => $post->post_title,
					'post_type'      => $post->post_type,
					'to_ping'        => $post->to_ping,
					'menu_order'     => $post->menu_order];
				$new_post_id = wp_insert_post($args);
				if (is_wp_error($new_post_id)) {
					error_log('Failed to clone post: ' . $new_post_id->get_error_message());
					return;
				}
				wp_redirect(admin_url('post.php?action=edit&post=' . $new_post_id));
				exit;
			}
		}
	}
}