<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Meta_Boxes {
	
	public static function init() {
		return new self();
	}
    
	public function __construct() {
		if (!is_admin()) return;
		add_action('load-post.php', [$this, 'init_metaboxes']);
		add_action('load-post-new.php', [$this, 'init_metaboxes']);
	}
	
    public function init_metaboxes() {
        add_action('add_meta_boxes', [$this, 'add_metaboxes']);
        add_action('save_post', [$this, 'save_metabox'], 10, 2);
    }
	
    public function add_metaboxes() {
        $post_types = array_keys(Zynith_SEO_Post_Types::get_post_types());
        add_meta_box('zynith_seo_metabox', ZYNITH_SEO_NAME, [$this, 'zynith_seo_metabox'], $post_types, 'normal', 'high');
    }
	
	public function zynith_seo_metabox($post) {
        wp_nonce_field('seo_metabox_nonce_action', 'seo_metabox_nonce');
    	echo self::get_zynith_seo_metabox($post);
    }
	
	private static function is_built_with_wpbakery($post_id) {
		if (!defined('WPB_VC_VERSION')) return false;
		$wpbakery_meta = get_post_meta($post_id, '_wpb_vc_js_status', true);
		if (!empty($wpbakery_meta)) return true;
		$post_content = get_post_field('post_content', $post_id);
		if (strpos($post_content, '[vc_') !== false) return true;
		return false;
	}
	
	public static function get_zynith_seo_metabox($object, $type = 'post') {
		if (!is_object($object)) return;
		$metadata = self::setObjectMetadata($type, $object);
		$site_icon_url = get_site_icon_url();
		if (empty($site_icon_url)) $site_icon_url = includes_url('images/w-logo-blue-white-bg.png');
		$site_title = !empty($metadata['sitetitle']) ? $metadata['sitetitle'] : $metadata['url'];
		$default_title = !empty($metadata['title']) && $metadata['title'] !== 'Auto Draft' ? $metadata['title'] . ' | ' . $metadata['sitetitle'] : "";
		$meta_title = !empty($metadata['meta_title']) ? self::replace_seo_variables($metadata['meta_title'], $metadata) : $default_title;
		$meta_description = '';
		if (!empty($metadata['meta_description'])) {
			$meta_description = self::replace_seo_variables($metadata['meta_description'], $metadata);
		}
		elseif (!empty($metadata['post_excerpt'])) {
			$meta_description = $metadata['post_excerpt'];
		}
		else {
			$meta_description = 'Page description will appear here';
		}
		$buttons = [
			['var' => '%%title%%', 'text' => 'Title'],
			['var' => '%%sitetitle%%', 'text' => 'Site Title'],
			['var' => '%%tagline%%', 'text' => 'Site Tagline'],
			['var' => '%%currentyear%%', 'text' => 'Current Year']
		];
		if (!empty($metadata['target_keyword'])) $buttons[] = ['var' => '%%target_keyword%%', 'text' => 'Target Keyword'];
		if (!empty($metadata['business_name'])) $buttons[] = ['var' => '%%business_name%%', 'text' => 'Business Name'];
		if (!empty($metadata['phone_number'])) $buttons[] = ['var' => '%%business_phone%%', 'text' => 'Phone'];
		if (!empty($metadata['address_country'])) $buttons[] = ['var' => '%%country_name%%', 'text' => 'Country'];
		if (!empty($metadata['post_excerpt'])) $buttons[] = ['var' => '%%post_excerpt%%', 'text' => 'Excerpt'];		
		$titleClass = ($metadata['meta_title'] == $default_title && !empty($metadata['meta_title']) || $meta_title == $default_title) ? 'regular-text default' : 'regular-text';
		$titleValue = empty($metadata['meta_title']) && !empty($metadata['title']) ? $default_title : esc_attr($metadata['meta_title']);
		$descClass = (!empty($metadata['meta_description']) && ($metadata['meta_description'] == $metadata['post_excerpt'] || $metadata['meta_description'] == $metadata['content'])) ? 'small-text default' : 'small-text';
		$html_element = <<<HTML
<div class="nav-tab-wrapper">
	<input type="hidden" class="input_metadata" id="metadata_title" data-z-var="%%title%%" value="{$metadata['title']}" />
	<input type="hidden" class="input_metadata" id="metadata_sitetitle" data-z-var="%%sitetitle%%" value="{$metadata['sitetitle']}" />
	<input type="hidden" class="input_metadata" id="metadata_tagline" data-z-var="%%tagline%%" value="{$metadata['tagline']}" />
	<input type="hidden" class="input_metadata" id="metadata_currentyear" data-z-var="%%currentyear%%" value="{$metadata['currentyear']}" />
	<input type="hidden" class="input_metadata" id="metadata_target_keyword" data-z-var="%%target_keyword%%" value="{$metadata['target_keyword']}" />
	<input type="hidden" class="input_metadata" id="metadata_business_name" data-z-var="%%business_name%%" value="{$metadata['business_name']}" />
	<input type="hidden" class="input_metadata" id="metadata_business_phone" data-z-var="%%business_phone%%" value="{$metadata['phone_number']}" />
	<input type="hidden" class="input_metadata" id="metadata_country_name" data-z-var="%%country_name%%" value="{$metadata['address_country']}" />
	<input type="hidden" class="input_metadata" id="metadata_post_excerpt" data-z-var="%%post_excerpt%%" value="{$metadata['post_excerpt']}" />
	<input type="hidden" id="custom_meta_title_updated" name="custom_meta_title_updated" value="{$metadata['meta_title_updated']}" />
	<input type="hidden" id="custom_meta_description_updated" name="custom_meta_description_updated" value="{$metadata['meta_description_updated']}" />
HTML;
		$html_element .= '<a class="nav-tab nav-tab-active" href="#seo-settings">' . __('Appearance', ZYNITH_SEO_TEXT_DOMAIN) . '</a>
				<a class="nav-tab" href="#dynamic-schema">' . __('Schema', ZYNITH_SEO_TEXT_DOMAIN) . '</a>
			</div>
			<div id="seo-settings" class="tab-content">';
		$warnings = [];
		if (!get_option('blog_public')) $warnings[] = sprintf(__('Your website is currently set to discourage search engines from indexing its pages. To take full advantage of these SEO settings, please adjust the search engine visibility %shere%s.', ZYNITH_SEO_TEXT_DOMAIN), '<a href="' . admin_url('options-reading.php') . '">', '</a>');
		$missing_alts = self::check_missing_alt_tags($metadata['content']);
		$missing_alts_count = count($missing_alts);
		if ($missing_alts_count > 0) $warnings[] = sprintf(_n('At least %s image on this page was detected as not having \'alt\' text.', 'At least %s images on this page detected as not having \'alt\' text.', $missing_alts_count,
															  ZYNITH_SEO_TEXT_DOMAIN), $missing_alts_count);
		$broken_links = self::detect_broken_links($metadata['content'], $object);
		$num_broken_links = count($broken_links);
		if ($num_broken_links > 0) $warnings[] = sprintf(_n('At least %s broken link detected on the page.', 'At least %s broken links detected on the page.', $num_broken_links, ZYNITH_SEO_TEXT_DOMAIN), $num_broken_links);
		if (count($warnings) == 1) {
			$html_element .= '<p class="notice-error">Warning: ' . $warnings[0] . '</p>';
		}
		elseif (count($warnings) > 1) {
			$html_element .= '<div class="notice-error">Warning:<ul>';
			foreach ($warnings as $warning) $html_element .= '<li>' . $warning . '</li>';	
			$html_element .= '</ul></div>';
		}
		$html_element .= '<div class="zynith-seo-preview-container"><p>' . __('Preview how your page might appear in Google search results:', ZYNITH_SEO_TEXT_DOMAIN) . '</p>';
		$html_element .= <<<HTML
	<div class="zynith-seo-preview">
		<div class="zynith-seo-preview-col">
			<div class="zynith-seo-preview-row">
				<div class="zynith-seo-preview-icon"><img src="{$site_icon_url}" height="18" width="18" /></div>
				<div class="zynith-seo-preview-col"><span class="zynith-seo-preview-site-name">{$site_title}</span><cite class="zynith-seo-preview-site-name">{$metadata['url']}</cite></div>
			</div>
HTML;
		$html_element .= '<h3 id="serp-title">' . esc_html($meta_title) . '</h3><p id="serp-desc" class="zynith-seo-preview-description">' . esc_html($meta_description) . '</p></div>';
		if (has_post_thumbnail($metadata['object_id'])) {
			$thumbnail = get_the_post_thumbnail($metadata['object_id'], 'thumbnail', ['class' => 'featured-image']);
			$html_element .= '<div class="zynith-seo-preview-img">' . $thumbnail . '</div>';
		}
		$html_element .= '</div></div><!-- End .zynith-seo-preview-container --><table class="form-table"><tbody><tr><th>' . __('Title Tag:', ZYNITH_SEO_TEXT_DOMAIN) . '</th><td>
						<input type="text" id="custom_meta_title" name="custom_meta_title" class="' . $titleClass . '" value="' . $titleValue . '" placeholder="' . __('Enter your Title here', ZYNITH_SEO_TEXT_DOMAIN) . '" /></td></tr>
						<tr><th>' . __('Meta Description:', ZYNITH_SEO_TEXT_DOMAIN) . '</th><td>
						<textarea id="custom_meta_description" name="custom_meta_description" class="' . $descClass . '" placeholder="' . __('Enter your Meta Description here', ZYNITH_SEO_TEXT_DOMAIN) . '" rows="3">' . esc_textarea($metadata['meta_description']) . '</textarea></td></tr><tr><th>Placeholders:</th><td><div class="div_placeholder_buttons">';
		foreach ($buttons as $button) $html_element .= '<button type="button" class="insert-placeholder" data-z-var="' . $button['var'] . '">' . $button['text'] . '</button>';
		$html_element .= '</div><p class="description">Place your cursor in the \'Title Tag\' or \'Meta Description\' fields to insert a placeholder variable.</p></td></tr><tr><th>' . __('OG Image URL:', ZYNITH_SEO_TEXT_DOMAIN) . '</th><td>
						<input type="url" class="regular-text" id="custom_meta_og_image" name="custom_meta_og_image" value="' . esc_attr($metadata['meta_og_image']) . '" placeholder="' . __('Enter the Open Graph Image URL here', ZYNITH_SEO_TEXT_DOMAIN) . '"><button type="button" class="button upload-image" id="custom_meta_og_image_button">' . __('Choose Image', ZYNITH_SEO_TEXT_DOMAIN) . '</button></td></tr>
						<tr><th>' . __('Robots:', ZYNITH_SEO_TEXT_DOMAIN) . '</th><td><div class="row"><div class="col"><label>noindex:</label><label for="custom_noindex" class="check-switch">
						<input type="checkbox" name="custom_noindex" id="custom_noindex"' . checked($metadata['noindex'], 'yes', false) . ' /><span class="slider"></span></label></div><div class="col"><label>nofollow:</label>
						<label for="custom_nofollow" class="check-switch"><input type="checkbox" name="custom_nofollow" id="custom_nofollow"' . checked($metadata['nofollow'], 'yes', false) . ' /><span class="slider"></span></label>
						</div></div></td><tr><th>' . __('Target Keyword:', ZYNITH_SEO_TEXT_DOMAIN) . '</th><td><div class="row">
						<input type="text" class="regular-text" id="custom_target_keyword" name="custom_target_keyword" value="' . esc_attr($metadata['target_keyword']) . '"  placeholder="' . __('Enter your Keyword here', ZYNITH_SEO_TEXT_DOMAIN) . '">';
		if (!empty($metadata['target_keyword'])) {
            $keyword_density = self::calculate_keyword_density($metadata['content'], $metadata['target_keyword']);
            $html_element .= '<p id="p_density">' . __('Keyword Density: ', ZYNITH_SEO_TEXT_DOMAIN) . $keyword_density . '%</p>';
        }		
		$html_element .= '</div><p class="description">' . __('Please note: Keyword density is not a definitive measure of SEO success and can be misleading. Use this metric cautiously.', ZYNITH_SEO_TEXT_DOMAIN) . '</p></td></tr></table>';
		$html_element .= '</div>';
		
		// * Schema Tab *
		$html_element .= '<div id="dynamic-schema" class="tab-content">' . wp_nonce_field('dynamic_schema_save_postdata', 'dynamic_schema_meta_box_nonce', true, false) .
			sprintf(esc_html__("%1\$sWrite your own JSON-LD schema to perfectly describe your page's content, use one of your custom-saved templates, select from our extensive range of predefined types, or %2\$suse our online AI Schema Generator%3\$s for automated assistance.%4\$s", ZYNITH_SEO_TEXT_DOMAIN), '<p>', '<a href="https://zynith.app/generate-schema/" target="_blank">', '</a>', '</p>') . 
            '<div class="schema-row"><div class="col"><div><label for="select_schema">' . esc_html__('Select Schema Type:', ZYNITH_SEO_TEXT_DOMAIN) . '</label><select id="select_schema">';
		$templates = get_option('custom_schema_templates', []);
		$encoded_templates = json_encode([]);
        if (!empty($templates)) {
			usort($templates, function ($a, $b) {
				return strcmp($a['name'], $b['name']);
			});
			$encoded_templates = json_encode($templates);
			$html_element .= '<optgroup label="' . esc_attr__('Your Saved Templates', ZYNITH_SEO_TEXT_DOMAIN) . '">';
			foreach ($templates as $index => $template) $html_element .= '<option value="template_' . esc_attr($index) . '">' . esc_html($template['name']) . '</option>';
			$html_element .= '</optgroup>';
        }
		$html_element .= '<optgroup label="Pages">
						<option value="AboutPage">About Page</option>
						<option value="Blog">Blog (Blog Index Page)</option>
						<option value="CheckoutPage">Checkout Page</option>
						<option value="CollectionPage">Collection Page</option>
						<option value="ContactPage">Contact Page</option>
						<option value="FAQPage">FAQ Page</option>
						<option value="MediaGallery">Gallery Page (Media Gallery)</option>
						<option value="ProfilePage">Profile Page</option>
						<option value="QAPage">Q&A Page</option>
						<option value="WebPage">Web Page (General)</option>
						<option value="WebSite">Web Site (Best for Home Page)</option>
					</optgroup>
					<optgroup label="Posts / Articles">
						<option value="HowTo">A How To Guide</option>
						<option value="Article">Article</option>
						<option value="Recipe">Recipe</option>
						<option value="NewsArticle">News Article</option>
						<option value="TechArticle">Tech Article</option>
					</optgroup>
					<optgroup label="Products / Custom Taxonomy">
						<option value="Audiobook">Audiobook</option>
						<option value="Book">Book</option>
						<option value="Car">Car</option>
						<option value="CreativeWork">Creative Work</option>
						<option value="Event">Event</option>
						<option value="ItemPage">Item Page</option>
						<option value="Product">Product</option>
						<option value="SoftwareApplication">Software Application</option>
						<option value="Vehicle">Vehicle</option>
						<option value="VideoObject">Web Application</option>
					</optgroup>
					<optgroup label="Organizations / Businesses">
						<option value="AccountingService">Accounting Service</option>
						<option value="Dentist">Dentist</option>
						<option value="Electrician">Electrician</option>
						<option value="EntertainmentBusiness">Entertainment Busines</option>
						<option value="FinancialService">Financial Service</option>
						<option value="FoodEstablishment">Food Establishment</option>
						<option value="HealthAndBeautyBusiness">Health and Beauty Business</option>
						<option value="HomeAndConstructionBusiness">Home and Construction Business</option>
						<option value="HVACBusiness">HVAC Business</option>
						<option value="LegalService">Legal Service</option>
						<option value="Library">Library</option>
						<option value="LocalBusiness">Local Business</option>
						<option value="Organization">Organization</option>
						<option value="Organization">Pharmacy</option>
						<option value="PerformingGroup">Performing Group</option>
						<option value="Plumber">Plumber</option>
						<option value="Restaurant">Restaurant</option>
						<option value="SportsActivityLocation">Sports Activity Location</option>
						<option value="Store">Store</option>
					</optgroup>
					<optgroup label="Education and Employment">
						<option value="CourseInstance">Course Instance</option>
						<option value="Course">Course</option>
						<option value="DataCatalog">Data Catalog</option>
						<option value="DataDownload">Data Download</option>
						<option value="DataFeed">Data Feed</option>
						<option value="Dataset">Dataset</option>
						<option value="EducationalOccupationalCredential">Educational Occupational Credential</option>
						<option value="EmployerAggregateRating">Employer Aggregate Rating</option>
						<option value="LearningResource">Learning Resource</option>
						<option value="JobPosting">Job Posting</option>
						<option value="Occupation">Occupation Salary Estimate</option>
						<option value="Quiz">Quiz</option>
						<option value="Schedule">Schedule</option>
						<option value="Syllabus">Syllabus</option>
					</optgroup>
					<optgroup label="People and Places">
						<option value="ContactPoint">Contact Point</option>
						<option value="GeoCoordinates">Geo Coordinates</option>
						<option value="Person">Person</option>
						<option value="Place">Place</option>
						<option value="PostalAddress">Postal Address</option>
						<option value="VirtualLocation">Virtual Location</option>
					</optgroup>
					<optgroup label="Content / Page Elements and Objects">
						<option value="AudioObject">Audio Object</option>
						<option value="BreadcrumbList">Breadcrumb Trail</option>
						<option value="Claim">Claim</option>
						<option value="ClaimReview">Fact Check (ClaimReview)</option>
						<option value="Clip">Clip</option>
						<option value="Collection">Collection</option>
						<option value="GeoShape">Geo Shape</option>
						<option value="HowToStep">How To Step</option>
						<option value="ImageObject">Image Object</option>
						<option value="InteractionCounter">Interaction Counter</option>
						<option value="MediaObject">Media Object</option>
						<option value="MovieClip">Movie Clip</option>
						<option value="Movie">Movie List</option>
						<option value="MusicVideoObject">Music Video Object</option>
						<option value="RadioClip">Radio Clip</option>
						<option value="Thing">Thing</option>
						<option value="TVClip">TV Clip</option>
						<option value="VideoObject">Video</option>
						<option value="VideoGameClip">Video Game Clip</option>
					</optgroup>
					<optgroup label="Schema Sub-types / Intangibles / Actions">
						<option value="Action">Action</option>
						<option value="AggregateRating">Aggregate Rating</option>
						<option value="BorrowAction">Book Action (Borrow)</option>
						<option value="EntryPoint">Entry Point (Target)</option>
						<option value="Intangible">Intangible</option>
						<option value="ItemList">Item List</option>
						<option value="PropertyValue">Item Type (PropertyValue)</option>
						<option value="LibrarySystem">Library System</option>
						<option value="ListItem">List Item</option>
						<option value="NutritionInformation">Nutrition Information</option>
						<option value="Offer">Offer</option>
						<option value="OpeningHoursSpecification">Opening Hours Specification</option>
						<option value="Rating">Rating</option>
						<option value="Review">Review</option>
						<option value="StructuredValue">Structured Value</option>
						<option value="TransferAction">Transfer Action</option>
					</optgroup>
				</select>
			</div>
			<p id="p_schema_desc"></p>
			<aside id="as_schema"></aside>
			<a id="a_schema_link" href="https://developers.google.com/search/docs/appearance/structured-data/search-gallery" target="_blank"></a>
			<div id="div_schema_inclusions_container" class="col">
				<p id="p_schema_inclusions">Select additional properties:</p>
				<div id="div_schema_inclusions"></div>
			</div>
		</div><!-- End .col -->
		<div id="div_create_schema" class="col">
			<label for="schema_example_ta">Update your schema:</label>
			<textarea id="schema_example_ta" class="code" rows="6"></textarea>
			<button type="button" id="b_copy_schema" class="button button-primary">Add Schema Code</button>
		</div><!-- End .col -->
		</div><!-- End .schema-row -->
		<label for="custom_schema">' . esc_html__('Save your schema:', ZYNITH_SEO_TEXT_DOMAIN) . '</label>
		<textarea class="code" id="custom_schema" name="custom_schema" rows="14" placeholder="' . esc_attr__('Enter your Schema here...', ZYNITH_SEO_TEXT_DOMAIN) . '">' . esc_textarea($metadata['schema']) . '</textarea>
		<div class="inside">
			<p>Note: you can use the following placeholder variables for insertion in your schema:</p>
			<ul class="quicktags">
				<li>Page/Post Title: <code>%%title%%</code></li>
				<li>Page/Post URL: <code>%%post_url%%</code></li>
				<li>Page/Post Date Published: <code>%%date%%</code></li>
				<li>Page/Post Date Modified: <code>%%modified%%</code></li>
				<li>Page/Post Thumbnail URL: <code>%%post_thumbnail_url%%</code></li>
				<li>Page/Post Excerpt: <code>%%post_excerpt%%</code></li>
				<li>Page/Post Title Tag: <code>%%title_tag%%</code></li>
				<li>Page/Post Meta Description: <code>%%meta_description%%</code></li>
				<li>Page/Post Target Keyword: <code>%%target_keyword%%</code></li>
				<li>Site Title: <code>%%sitetitle%%</code></li>
				<li>Site Tagline: <code>%%tagline%%</code></li>
				<li>Site Home Page URL: <code>%%home_url%%</code></li>
				<li>Business Name: <code>%%business_name%%</code></li>
				<li>Business Logo URL: <code>%%logo_url%%</code></li>
				<li>Business Email: <code>%%business_email%%</code></li>
				<li>Business Phone: <code>%%business_phone%%</code></li>
				<li>Business Street Address: <code>%%street_address%%</code></li>
				<li>Business Locality (e.g. State): <code>%%locality%%</code></li>
				<li>Business Region (e.g. Suburb): <code>%%region%%</code></li>
				<li>Business Post Code: <code>%%postal_code%%</code></li>
				<li>Country Name: <code>%%country_name%%</code></li>
				<li>Country Code: <code>%%country_code%%</code></li>
				<li>Current Year: <code>%%currentyear%%</code></li>
			</ul>
		</div><!-- End .inside -->
		</div><!-- End #dynamic-schema -->';
		ob_start();
		?>
		<script>	
			document.addEventListener('DOMContentLoaded', function() {
				const SCHEMA = [
					{id: "Thing", desc: "The most generic type of item.", note: "", slug: "https://schema.org/Thing", default: ['name'],
					 inclusions: ['alternateName','description','disambiguatingDescription','identifier','image','mainEntityOfPage','potentialAction','sameAs','url'],
					},
					{id: "Action",
					 desc: "An action performed by a direct agent and indirect participants upon a direct object. Optionally happens at a location with the help of an inanimate instrument. The execution of the action may produce a result. Specific action sub-type documentation specifies the exact expectation of each argument/role.", note: "", slug: "https://schema.org/Action", default: ['name'],
					 inclusions: ['agent','endTime','location','object','startTime','target'], parent: "Thing",
					},
					{id: "CreativeWork", desc: "The most generic kind of creative work, including books, movies, photographs, software programs, etc.", note: "", slug: "https://schema.org/CreativeWork",
					 default: ['name','url'],
					 inclusions: ['about','acquireLicensePage','aggregateRating','author','citation','comment','copyrightNotice','creator','creditText','dateCreated','dateModified','datePublished','educationalAlignment','educationalLevel',
								  'encodingFormat','expires','funder','hasPart','headline','inLanguage','interactionStatistic','interactionType','isAccessibleForFree','isPartOf','keywords','learningResourceType','license','mainEntity','offers',
								  'position','provider','publication','publisher','review','spatialCoverage','temporalCoverage','text','timeRequired','usageInfo','version','video'], parent: "Thing",
					},
					{id: "Event", desc: "An event happening at a certain time and location, such as a concert, lecture, or festival. Repeated events may be structured as separate Event objects.",
					 note: "&#9733; Ticketing information may be added via the offers property.", slug: "https://developers.google.com/search/docs/appearance/structured-data/event", default: ['location','name','startDate'],
					 inclusions: ['about','aggregateRating','endDate','eventAttendanceMode','eventStatus','funder','inLanguage','isAccessibleForFree','keywords','offers','organizer','performer','previousStartDate','review'], parent: "Thing",
					},
					{id: "Intangible", desc: "A utility class that serves as the umbrella for a number of 'intangible' things such as quantities, structured values, etc.", note: "", slug: "https://schema.org/Intangible",
					 default: ['name'],
					 inclusions: ['about','aggregateRating','endDate','eventAttendanceMode','eventStatus','funder','inLanguage','isAccessibleForFree','keywords','offers','organizer','performer','previousStartDate','review'], parent: "Thing",
					},			
					{id: "TransferAction", desc: "The act of transferring/moving (abstract or concrete) animate or inanimate objects from one place to another.", note: "", slug: "https://schema.org/TransferAction", default: ['name'],
					 inclusions: [], parent: "Action",
					},
					{id: "Article", desc: "An article, such as a news article, investigative report, or blog post.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/article",
					 default: ['author','dateModified','datePublished','headline','image'], inclusions: ['name'], parent: "CreativeWork",
					},
					{id: "Blog", desc: "An index page of blog posts.", note: "", slug: "https://schema.org/Blog", default: ['name'], inclusions: [], parent: "CreativeWork"},
					{id: "Book", desc: "A book.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/book",
					 default: ['author','bookFormat','inLanguage','isbn','name','potentialAction','url','workExample'], inclusions: ['bookEdition'], parent: "CreativeWork"
					},
					{id: "Claim", desc: "A specific, factually-oriented claim. Ideally, a Claim description includes enough contextual information to minimize the risk of ambiguity or inclarity.",
					 note: "&#9733; The content of a claim can be summarized with the text property.", slug: "https://developers.google.com/search/docs/appearance/structured-data/factcheck",
					 default: ['appearance','author','datePublished','firstAppearance'], inclusions: ['name'], parent: "CreativeWork"
					},
					{id: "Clip", desc: "A short TV or radio program or a segment/part of a program.", note: "", slug: "https://schema.org/Clip", default: ['name','startOffset','url'], inclusions: ['endOffset'], parent: "CreativeWork"},
					{id: "Collection", desc: "A collection of items, e.g. creative works or products.", note: "", slug: "https://schema.org/Collection", default: ['name'], inclusions: [], parent: "CreativeWork"},
					{id: "DataCatalog", desc: "A collection of datasets.", note: "", slug: "https://schema.org/DataCatalog", default: ['name'], inclusions: [], parent: "CreativeWork"},
					{id: "Dataset", desc: "A body of structured information describing some topic(s) of interest.", note: "&#9733; You can find datasets on Google by using the Dataset Search tool.",
					 slug: "https://developers.google.com/search/docs/appearance/structured-data/dataset", default: ['name','description'], inclusions: ['distribution','includedInDataCatalog'], parent: "CreativeWork"
					},
					{id: "EducationalOccupationalCredential",
					 desc: "An educational or occupational credential. A diploma, academic degree, certification, qualification, badge, etc., that may be awarded to a person or other entity that meets the requirements defined by the credentialer.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/course-info", default: ['credentialCategory'], inclusions: ['name'], parent: "CreativeWork"
					},
					{id: "HowTo", desc: "Instructions that explain how to achieve a result by performing a sequence of steps.", note: "", slug: "https://schema.org/HowTo", default: ['step'], inclusions: ['name','prepTime','totalTime'],
					 parent: "CreativeWork"
					},
					{id: "HowToStep", desc: "A step in the instructions for how to achieve a result.", note: "", slug: "https://schema.org/HowToStep", default: ['text'], inclusions: ['name'], parent: "CreativeWork"},
					{id: "LearningResource",
					 desc: "The LearningResource type can be used to indicate CreativeWorks (whether physical or digital) that have a particular and explicit orientation towards learning, education, skill acquisition, and other educational purposes.", note: "&#9733; LearningResource is expected to be used as an addition to a primary type such as Book, VideoObject, Product etc.", slug: "https://schema.org/LearningResource", default: ['name'],
					 inclusions: ['educationalAlignment','teaches'], parent: "CreativeWork"
					},
					{id: "MediaObject", desc: "A media object, such as an image, video, audio, or text object embedded in a web page or a downloadable dataset i.e. DataDownload.",
					 note: "&#9733; Note that a creative work may have many media objects associated with it on the same web page. For example, a page about a single song (MusicRecording) may have a music video (VideoObject), and a high and low bandwidth audio stream (2 AudioObject's).", slug: "https://schema.org/MediaObject", default: ['text'], inclusions: ['contentUrl','duration','embedUrl','encodingFormat','name','regionsAllowed'], parent: "CreativeWork"
					},
					{id: "Movie", desc: "A movie.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/movie", default: ['image','name'], inclusions: ['director'], parent: "CreativeWork"},
					{id: "Review", desc: "A review of an item. For example, of a restaurant, movie, store, etc.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/review-snippet",
					 default: ['author','itemReviewed','name','reviewRating','ratingValue'], inclusions: ['bestRating','reviewBody','worstRating'], parent: "CreativeWork"
					},
					{id: "SoftwareApplication", desc: "A software application.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/software-app", default: ['name','offers'],
					 inclusions: ['applicationCategory','operatingSystem'], parent: "CreativeWork"
					},
					{id: "WebPage", desc: "A web page.", note: "", slug: "https://schema.org/WebPage", default: ['name'], inclusions: [], parent: "CreativeWork"},
					{id: "WebSite", desc: "To indicate your site name preference, add WebSite structured data to your home page. You can also use the WebSite schema type to control Google's sitelinks Search box.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/sitelinks-searchbox", default: ['name','url','potentialAction'], inclusions: [], parent: "CreativeWork"},	
					{id: "CourseInstance",
					 desc: "An instance of a Course which is distinct from other instances because it is offered at a different time or location or through different media or modes of study or to a specific section of students.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/course-info", default: ['courseMode','courseSchedule','courseWorkload'], inclusions: ['instructor','location'], parent: "Event",
					},
					{id: "EntryPoint", desc: "An entry point within a web-based protocol.", note: "", slug: "https://schema.org/EntryPoint", default: ['actionPlatform','urlTemplate'],
					 inclusions: ['name'], parent: "Intangible"
					},
					{id: "JobPosting", desc: "A listing that describes a job opening in a certain organization.", note: "&#9733; The JobPosting markup must only be used on pages that contain a single job posting.",
					 slug: "https://developers.google.com/search/docs/appearance/structured-data/job-posting", default: ['datePosted','description','hiringOrganization','jobLocation','title'],
					 inclusions: ['applicantLocationRequirements','baseSalary','educationRequirements','employmentType','experienceRequirements','jobLocationType','validThrough'], parent: "Intangible"
					},
					{id: "ListItem", desc: "An list item, e.g., a step in a checklist or how-to description.", note: "", slug: "https://schema.org/ListItem", default: ['position','url'], inclusions: ['item','name',], parent: "Intangible"},
					{id: "Occupation", desc: "Estimated salaries can appear in the job experience on Google Search and as a salary estimate rich result for a given occupation.", note: "",
					 slug: "https://developers.google.com/search/docs/appearance/structured-data/estimated-salary", default: ['estimatedSalary','name','occupationLocation'], inclusions: [], parent: "Intangible",
					},
					{id: "OccupationalExperienceRequirements", desc: "", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/job-posting", default: ['monthsOfExperience'], inclusions: ['name'],
					 parent: "Intangible"
					},
					{id: "Schedule",
					 desc: "A schedule defines a repeating time period used to describe a regularly occurring Event. At a minimum, a schedule will specify repeatFrequency which describes the interval between occurrences of the event. Additional information can be provided to specify the schedule more precisely. This includes identifying the day(s) of the week or month when the recurring event will take place, in addition to its start and end time. Schedules may also have start and end dates to indicate when they are active, e.g. to define a limited calendar of events.", note: "", slug: "https://schema.org/Schedule", default: ['repeatFrequency','repeatCount'], inclusions: ['duration','endDate','name','startDate'], parent: "Intangible"
					},
					{id: "StructuredValue", desc: "Structured values are used when the value of a property has a more complex structure than simply being a textual value or a reference to another thing.", note: "",
					 slug: "https://schema.org/StructuredValue", default: ['name'], inclusions: [], parent: "Intangible"
					},
					{id: "VirtualLocation",
					 desc: "An online or virtual location for attending events. For example, one may attend an online seminar or educational event. While a virtual location may be used as the location of an event, virtual locations should not be confused with physical locations in the real world.", note: "", slug: "https://schema.org/VirtualLocation", default: ['url'], inclusions: ['name']
					},
					{id: "NewsArticle",desc: "An article whose content reports news, or provides background context and supporting materials for understanding the news.", note: "", slug: "https://schema.org/NewsArticle",
					 default: ['author','dateModified','datePublished','headline','image'], inclusions: [], parent: "Article",
					},
					{id: "TechArticle",desc: "A technical article such as a how-to guide, step-by-step, procedural troubleshooting, specifications, etc.", note: "", slug: "https://schema.org/TechArticle",
					 default: ['author','dateModified','datePublished','headline','image'], inclusions: [], parent: "Article",
					},	
					{id: "Audiobook", desc: "An audiobook.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/book",
					 default: ['bookFormat','inLanguage','isbn','name','potentialAction','url','workExample'], inclusions: ['duration','readBy'], parent: "Book"
					},
					{id: "MovieClip", desc: "A short segment/part of a movie.", note: "", slug: "https://schema.org/MovieClip", default: ['name'], inclusions: ['startOffset'], parent: "Clip"},					
					{id: "RadioClip", desc: "A short radio program or a segment/part of a radio program.", note: "", slug: "https://schema.org/RadioClip", default: ['name'], inclusions: ['startOffset'], parent: "Clip"},
					{id: "TVClip", desc: "A short TV program or a segment/part of a TV program.", note: "", slug: "https://schema.org/TVClip", default: ['name'], inclusions: ['startOffset'], parent: "Clip"},
					{id: "VideoGameClip", desc: "A short segment/part of a video game.", note: "", slug: "https://schema.org/VideoGameClip", default: ['name'], inclusions: ['startOffset'], parent: "Clip"},					
					{id: "DataFeed", desc: "A single feed providing structured information about one or more entities or topics.", note: "", slug: "https://schema.org/DataFeed", default: ['dataFeedElement','dateModified'],
					 inclusions: ['name'], parent: "Dataset",
					},
					{id: "Recipe",
					 desc: "A recipe.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/recipe", default: ['name','image','nutrition','recipeIngredient','recipeInstructions','recipeYield','video'],
					 inclusions: ['cookTime','recipeCategory','recipeCuisine'], parent: "HowTo"
					},	
					{id: "Course",
					 desc: "A description of an educational course which may be offered as distinct instances which take place at different times or take place at different locations, or be offered through different media or modes of study. An educational course is a sequence of one or more educational events and/or creative works which aims to build knowledge, competence or ability of learners.", note: "",
					 slug: "https://developers.google.com/search/docs/appearance/structured-data/course-info", default: ['name','description','provider'],
					 inclusions: ['availableLanguage','coursePrerequisites','educationalCredentialAwarded','financialAidEligible','hasCourseInstance','syllabusSections','totalHistoricalEnrollment'], parent: "LearningResource"
					},
					{id: "Quiz", desc: "A test of knowledge, skills and abilities.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/education-qa",
					 default: ['about','educationalAlignment','name'], inclusions: [], parent: "LearningResource"
					},
					{id: "Syllabus", desc: "", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/carousel", default: ['description','name','timeRequired'], inclusions: [], parent: "LearningResource"},
					{id: "AudioObject", desc: "An audio file.", note: "", slug: "https://schema.org/AudioObject", default: ['text'], inclusions: [], parent: "MediaObject"},
					{id: "DataDownload", desc: "All or part of a Dataset in downloadable form.", note: "", slug: "https://schema.org/DataDownload", default: ['contentUrl'], inclusions: [], parent: "MediaObject"},
					{id: "ImageObject", desc: "An image file.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/image-license-metadata", default: ['contentUrl'], inclusions: [], parent: "MediaObject"},
					{id: "MusicVideoObject", desc: "A music video file.", note: "", slug: "https://schema.org/MusicVideoObject", default: ['contentUrl'], inclusions: [], parent: "MediaObject"},
					{id: "VideoObject", desc: "A video file.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/video", default: ['name','thumbnailUrl','uploadDate'], inclusions: [], parent: "MediaObject"},
					{id: "ClaimReview", desc: "A fact-checking review of claims made (or reported) in some creative work.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/factcheck",
					 default: ['claimReviewed','reviewRating','url'], inclusions: [], parent: "Review"
					},					
					{id: "WebApplication", desc: "Web applications.", note: "", slug: "https://schema.org/WebApplication", default: ['name'], inclusions: [], parent: "SoftwareApplication"},
					{id: "BorrowAction", desc: "The act of obtaining an object under an agreement to return it at a later date.", note: "", slug: "https://schema.org/BorrowAction", default: ['agent','lender','object','target'],
					 inclusions: ['name'], parent: "TransferAction",
					},
					{id: "AboutPage", desc: "", note: "", slug: "https://schema.org/AboutPage", default: ['name'], inclusions: [], parent: "WebPage"},
					{id: "CheckoutPage", desc: "", note: "", slug: "https://schema.org/CheckoutPage", default: ['name'], inclusions: [], parent: "WebPage"},
					{id: "CollectionPage", desc: "A 'Collection' page.", note: "", slug: "https://schema.org/CollectionPage", default: ['name'], inclusions: [], parent: "WebPage"},
					{id: "ContactPage", desc: "A 'Contact' page.", note: "", slug: "https://schema.org/ContactPage", default: ['name'], inclusions: [], parent: "WebPage"},
					{id: "FAQPage", desc: "A Frequently Asked Question (FAQ) page contains a list of questions and answers pertaining to a particular topic.",
					 note: "&#9733; FAQ rich results on Google are only available for well-known, authoritative government or health websites.<br />&#9733; See also QAPage.",
					 slug: "https://developers.google.com/search/docs/appearance/structured-data/faqpage",
					 default: ['mainEntity'], inclusions: [], parent: "WebPage"
					},
					{id: "ItemPage", desc: "A page devoted to a single item, such as a particular product or hotel.", note: "", slug: "https://schema.org/ItemPage", default: ['name'], inclusions: [], parent: "WebPage"},
					{id: "ProfilePage", desc: "A Profile Page is designed for any site where people or organizations share first-hand perspectives. It helps Google Search highlight information about the creator, such as their name or social handle, profile photo, follower count, or the popularity of their content.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/profile-page", default: ['mainEntity'],
					 inclusions: ['name'], parent: "WebPage"
					},
					{id: "QAPage", desc: "A Q&A page indicates that the web page is focused on a specific question and its answer(s).", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/qapage",
					 default: ['mainEntity'], inclusions: [], parent: "WebPage"
					},
					{id: "MediaGallery", desc: "A Media Gallery page that can contain media such as images, videos, and other multimedia.", note: "", slug: "https://schema.org/MediaGallery", default: ['name'], inclusions: [],
					 parent: "CollectionPage"
					},	
					{id: "LibrarySystem", desc: "A Library System is a collaborative system amongst several libraries.", note: "", slug: "https://schema.org/LibrarySystem", default: ['additionalProperty','member'], inclusions: ['name'],
					 parent: "Organization",
					},
					{id: "PerformingGroup", desc: "A performance group, such as a band, an orchestra, or a circus.", note: "", slug: "https://schema.org/PerformingGroup", default: ['name'], inclusions: ['address'], parent: "Organization"},
					{id: "AccountingService", desc: "Accountancy business.", note: "", slug: "https://schema.org/AccountingService", default: ['name','address'], inclusions: [], parent: "LocalBusiness"},
					{id: "Dentist", desc: "A dentist.", note: "", slug: "https://schema.org/Dentist", default: ['name','address'], inclusions: [], parent: "LocalBusiness"},
					{id: "EntertainmentBusiness", desc: "A business providing entertainment.", note: "", slug: "https://schema.org/EntertainmentBusiness", default: ['name','address'], inclusions: [], parent: "LocalBusiness"},
					{id: "FinancialService", desc: "Financial services business.", note: "", slug: "https://schema.org/FinancialService", default: ['name','address'], inclusions: [], parent: "LocalBusiness"},
					{id: "FoodEstablishment", desc: "A food-related business.", note: "", slug: "https://schema.org/FoodEstablishment", default: ['name','address'], inclusions: ['acceptsReservations','servesCuisine'], parent: "LocalBusiness"},
					{id: "HealthAndBeautyBusiness", desc: "A health and beauty business.", note: "", slug: "https://schema.org/HealthAndBeautyBusiness", default: ['name','address'], inclusions: [], parent: "LocalBusiness"},
					{id: "HomeAndConstructionBusiness", desc: "A construction business that provides services around homes and buildings.", note: "", slug: "https://schema.org/HomeAndConstructionBusiness", default: ['name','address'],
					 inclusions: [], parent: "LocalBusiness"
					},
					{id: "LegalService", desc: "A LegalService is a business that provides legally-oriented services, advice and representation, e.g. law firms.", note: "", slug: "https://schema.org/LegalService", default: ['name','address'],
					 inclusions: [], parent: "LocalBusiness"
					},
					{id: "Library", desc: "A library.", note: "", slug: "https://schema.org/Library", default: ['location','name'], inclusions: [], parent: "LocalBusiness"},
					{id: "MedicalBusiness", desc: "A particular physical or virtual business of an organization for medical purposes. Examples of MedicalBusiness include different businesses run by health professionals.", note: "",
					 slug: "https://schema.org/MedicalBusiness", default: ['name','address'], inclusions: [], parent: "LocalBusiness"
					},
					{id: "SportsActivityLocation", desc: "A sports location, such as a playing field.", note: "", slug: "https://schema.org/SportsActivityLocation", default: ['name','address'], inclusions: [], parent: "LocalBusiness"},
					{id: "Store", desc: "A retail good store.", note: "", slug: "https://schema.org/Store", default: ['address','department','name'], inclusions: [], parent: "LocalBusiness"},
					{id: "Restaurant", desc: "A restaurant.", note: "", slug: "https://schema.org/Restaurant", default: ['acceptsReservations','name','address','servesCuisine','image'], inclusions: [], parent: "FoodEstablishment"},				
					{id: "Electrician", desc: "An electrician.", note: "", slug: "https://schema.org/Electrician", default: ['name','address'], inclusions: [], parent: "HomeAndConstructionBusiness"},
					{id: "HVACBusiness", desc: "A business that provides Heating, Ventilation and Air Conditioning services.", note: "", slug: "https://schema.org/HVACBusiness", default: ['name','address'], inclusions: [],
					 parent: "HomeAndConstructionBusiness"
					},
					{id: "Plumber", desc: "A plumbing service.", note: "", slug: "https://schema.org/Plumber", default: ['name','address'], inclusions: [], parent: "HomeAndConstructionBusiness"},					
					{id: "Pharmacy", desc: "A pharmacy or drugstore.", note: "", slug: "https://schema.org/Pharmacy", default: ['name','address'], inclusions: [], parent: "MedicalBusiness"},	
					{id: "OpeningHoursSpecification", desc: "", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/local-business", default: ['closes','dayOfWeek','opens'],
					 inclusions: [], parent: "StructuredValue"
					},
					{id: "NutritionInformation", desc: "Nutritional information about the recipe.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/carousel", default: ['calories'], inclusions: ['name'],
					 parent: "StructuredValue"
					},
					{id: "InteractionCounter",
					 desc: "The InteractionCounter allows a count to be associated with a certain type of interaction.", note: "", slug: "https://schema.org/NutritionInformation", default: ['interactionType','userInteractionCount'], inclusions: ['endTime','location','name','startTime']
					},
					{id: "ContactPoint", desc: "A contact point, for example, a Customer Complaints department.", note: "", slug: "https://schema.org/ContactPoint", default: ['telephone','email'], inclusions: [], parent: "StructuredValue"},
					{id: "PropertyValue", desc: "", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/book", default: ['name','value'], inclusions: ['propertyID'], parent: "StructuredValue"},
					{id: "PostalAddress", desc: "The mailing address.", note: "", slug: "https://schema.org/PostalAddress", default: ['addressCountry','addressLocality','addressRegion','postalCode','streetAddress'], inclusions: [],
					 parent: "ContactPoint",
					},
					{id: "GeoCoordinates", desc: "The geographic coordinates of a place or event.", note: "", slug: "https://schema.org/GeoCoordinates", default: ['latitude','longitude'],
					 inclusions: ['address','addressCountry','name','postalCode'], parent: "StructuredValue"
					},
					{id: "GeoShape", desc: "The geographic shape of a place. A GeoShape can be described using several properties whose values are based on latitude/longitude pairs.",
					 note: "&#9733; Either whitespace or commas can be used to separate latitude and longitude. Whitespace should be used when writing a list of several such points.", slug: "https://schema.org/GeoShape", default: ['box'], inclusions: ['address','addressCountry','name','postalCode'], parent: "StructuredValue"
					},
					{id: "ItemList", desc: "A list of items of any sort—for example, Top 10 Movies About Weathermen, or Top 100 Party Songs.", note: "&#9733; Not to be confused with HTML lists, which are often used only for formatting.",
					 slug: "https://schema.org/ItemList", default: ['itemListElement'], inclusions: [], parent: "Intangible"
					},
					{id: "BreadcrumbList",
					 desc: "A BreadcrumbList is an ItemList consisting of a chain of linked Web pages, typically described using at least their URL and their name, and typically ending with the current page. The convention is that a breadcrumb list has an itemListOrder of ItemListOrderAscending (lower values listed first), and that the first items in this list correspond to the 'top' or beginning of the breadcrumb trail, e.g. with a site or section homepage.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/breadcrumb", default: ['itemListElement'], inclusions: [], parent: "ItemList"
					},
					{id: "Rating", desc: "A rating is an evaluation on a numeric scale, such as 1 to 5 stars.", note: "", slug: "https://schema.org/Rating", default: ['alternateName'],
					 inclusions: ['author','bestRating','name','ratingValue','worstRating'], parent: "Intangible",
					},
					{id: "AggregateRating", desc: "The average rating based on multiple ratings or reviews.", note: "", slug: "https://schema.org/AggregateRating", default: ['ratingCount','ratingValue'], inclusions: ['reviewCount'],
					 parent: "Rating"
					},
					{id: "EmployerAggregateRating",
					 desc: "An aggregate rating of an Organization related to its role as an employer. EmployerAggregateRating is an evaluation of a hiring organization compiled from many users.", note: "",
					 slug: "https://developers.google.com/search/docs/appearance/structured-data/employer-rating", default: ['itemReviewed','ratingValue'], inclusions: [], parent: "AggregateRating"
					},
					{id: "Offer",
					 desc: "An offer to transfer some rights to an item or to provide a service — for example, an offer to sell tickets to an event, to rent the DVD of a movie, to stream a TV show over the internet, to repair a motorcycle, or to loan a book.", note: "", slug: "https://schema.org/Offer", default: ['availability','price','priceCurrency'],
					 inclusions: ['availabilityEnds','availabilityStarts','category','eligibleRegion','validFrom'], parent: "Intangible"
					},
					{id: "Organization",
					 desc: "An organization such as a school, NGO, corporation, club, etc.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/organization",
					 default: ['address','contactPoint','description','email','foundingDate','legalName','logo','name','numberOfEmployees','sameAs','telephone','url',],
					 inclusions: ['aggregateRating','department','duns','globalLocationNumber','interactionStatistic','iso6523Code','keywords','leiCode','location','naics','review','vatID'], parent: "Thing",
					},
					{id: "LocalBusiness",
					 desc: "A particular physical business or branch of an organization. Examples of LocalBusiness include a restaurant, a particular branch of a restaurant chain, a branch of a bank, a medical practice, a club, a bowling alley, etc.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/local-business", default: ['name','address'],
					 inclusions: ['contactPoint','email','foundingDate','geo','legalName','logo','numberOfEmployees','openingHoursSpecification','priceRange','telephone'], parent: "Organization",
					},
					{id: "Person", desc: "A person (alive, dead, undead, or fictional).", note: "", slug: "https://schema.org/Person", default: ['name'],
					 inclusions: ['address','agentInteractionStatistic','contactPoint','duns','email','funder','globalLocationNumber','honorificPrefix','honorificSuffix','jobTitle','naics','telephone','vatID'], parent: "Thing",
					},
					{id: "Place", desc: "Entities that have a somewhat fixed, physical extension.", note: "https://schema.org/Place", slug: "https://schema.org/Place", default: ['name'],
					 inclusions: ['additionalProperty','address','aggregateRating','geo','globalLocationNumber','keywords','latitude','logo','longitude','openingHoursSpecification','review','telephone'], parent: "Thing",
					},
					{id: "Product", desc: "Any offered product or service. For example, a pair of shoes, a concert ticket, the rental of a car, a haircut, or an episode of a TV show streamed online.", note: "",
					 slug: "https://developers.google.com/search/docs/appearance/structured-data/product", default: ['name'],inclusions: ['aggregateRating','brand','category','itemCondition','keywords','logo','color','review','offers','model'],
					 parent: "Thing",
					},
					{id: "Vehicle", desc: "A vehicle is a device that is designed or used to transport people or cargo over land, water, air, or through space.", note: "", slug: "https://schema.org/Vehicle", default: ['name'],
					 inclusions: ['bodyType','driveWheelConfiguration','mileageFromOdometer','numberOfDoors','vehicleConfiguration','vehicleEngine','vehicleIdentificationNumber','vehicleInteriorColor','vehicleInteriorType','vehicleModelDate',
								 'vehicleSeatingCapacity','vehicleTransmission'], parent: "Product",
					},
					{id: "Car", desc: "A car is a wheeled, self-powered motor vehicle used for transportation.", note: "", slug: "https://developers.google.com/search/docs/appearance/structured-data/vehicle-listing",
					 default: ['brand','itemCondition','mileageFromOdometer','model','name','offers','vehicleIdentificationNumber','vehicleModelDate'], inclusions: [], parent: "Vehicle",
					},
				];
				const SCHEMA_INCLUSIONS = [
					{id: "about",name: "about", value: `
"about": [
    {
        "@type": "Event",
        "name": "%%title%%"
    },{
        "@type": "Thing",
        "@id": "%%post_url%%#thing",
        "name": "%%title%%",
        "sameAs": " <- https://en.wikipedia.org/wiki/%%title%% -> "
    }
]`
					},
					{id: "acceptedAnswer", name: "acceptedAnswer", value: `
"acceptedAnswer": "[
    {
	    "@type": "Answer",
	    "text": " <- The full text of the answer. -> "
    }
]"`
					},
					{id: "acquireLicensePage", name: "acquireLicensePage", value: `
"acquireLicensePage": " <- https://example.com/how-to-use-my-images -> "`
					},
					{id: "actionPlatform", name: "actionPlatform", value: `
"actionPlatform": [
    "https://schema.org/DesktopWebPlatform",
    "https://schema.org/AndroidPlatform",
    "https://schema.org/IOSPlatform"
]`
					},
					{id: "additionalProperty", name: "additionalProperty", value: `
"additionalProperty": [
    {
        "@type": "PropertyValue",
        "name": "librarytype",
        "value": "public"
    }
]`
					},
					{id: "address", name: "address", value: `
"address": [
    {
        "@type": "PostalAddress",
        "streetAddress": "%%street_address%%",
        "addressLocality": "%%locality%%",
        "addressRegion": "%%region%%",
        "postalCode": "%%postal_code%%",
        "addressCountry": "US" // Two-letter Country Code
    }
],`},
					{id: "addressCountry", name: "addressCountry", value: `
"addressCountry": "US"  // Two-letter Country Code`
					},
					{id: "addressLocality", name: "addressLocality", value: `
"addressLocality": "%%locality%%"`
					},
					{id: "addressRegion", name: "addressRegion", value: `
"addressRegion": "%%region%%"`
					},
					{id: "agent", name: "agent", value: `
"agent": {
    "@type": "Person",
    "name": " <- Enter the name of the item. -> "
}`
					},
					{id: "aggregateRating", name: "aggregateRating", value: `
"aggregateRating": {
    "@type": "AggregateRating",
	"bestRating": "5",
	"worstRating": "1",
    "ratingValue": "4.5",
    "ratingCount": "1234"
}`
					},
					{id: "alignmentType", name: "alignmentType", value: `
"alignmentType": "educationalSubject"`
					},
					{id: "alternateName", name: "alternateName", value: `
"alternateName": " <- Enter an alias for the item. -> "`
					},
					{id: "appearance", name: "appearance", value: `
"appearance": {
    "@type": "OpinionNewsArticle",
    "url": "%%post_url%%",
    "headline": "%%title%%",
    "datePublished": "%%date%%",
    "author": {
            "@type": "Person",
            "name": " <- Person Name -> "
    },
    "image": " <- https://example.com/photos/1x1/photo.jpg -> ",
    "publisher": {
            "@type": "Organization",
            "name": "%%business_name%%",
            "logo": {
              "@type": "ImageObject",
              "url": "%%logo_url%%"
            }
    }
}`
					},
					{id: "applicantLocationRequirements", name: "applicantLocationRequirements", value: `
"applicantLocationRequirements": {
        "@type": "Country",
        "name": "USA"
}`
					},
					{id: "applicationCategory", name: "applicationCategory", value: `
"applicationCategory": "GameApplication"`
					},			
					{id: "author", name: "author", value: `
"author": {
    "@type": "Person",
    "name": "<?php echo $metadata['author_name']; ?>"
}`
					},
					{id: "availability", name: "availability", value: `
"availability": "https://schema.org/InStock"`
					},
					{id: "availabilityEnds", name: "availabilityEnds", value: `
"availabilityEnds": "YYYY-MM-DDT17:00:00+10:00"`
					},
					{id: "availabilityStarts", name: "availabilityStarts", value: `
"availabilityStarts": "YYYY-MM-DDT17:00:00+10:00"`
					},
					{id: "availableLanguage", name: "availableLanguage", value: `
"availableLanguage": ["en", "fr", "es", "ro"]`
					},
					{id: "baseSalary", name: "baseSalary", value: `
"baseSalary": {
    "@type": "MonetaryAmount",
        "currency": "USD",
        "value": {
          "@type": "QuantitativeValue",
          "value": 40.00,
          "unitText": "HOUR"
    }
}`
					},
					{id: "bestRating", name: "bestRating", value: `
"bestRating": "5"`
					},
					{id: "bodyType", name: "bodyType", value: `
"bodyType": "Pickup"`
					},
					{id: "bookEdition", name: "bookEdition", value: `
"bookEdition": "2nd Edition"`
					},
					{id: "bookFormat", name: "bookFormat", value: `
"bookFormat": "https://schema.org/Paperback"`
					},
					{id: "brand", name: "brand", value: `
"brand": {
        "@type": "Brand",
        "name": "%%title%%"
}`
					},
					{id: "category", name: "category", value: `
"category": "Subscription"`
					},
					{id: "citation", name: "citation", value: `
"citation": "https://doi.org/10.1111/111"`
					},
					{id: "claimReviewed", name: "claimReviewed", value: `
"claimReviewed": "%%title%%"`
					},
					{id: "creator", name: "creator", value: `
"creator":{
         "@type":"Organization",
         "url": "%%home_url%%",
         "name": "%%business_name%%"
}`
					},
					{id: "creditText", name: "creditText", value: `
"creditText": "%%business_name%%"`
					},
					{id: "color", name: "color", value: `
"color": "White"`
					},
					{id: "comment", name: "comment", value: `
"comment": [
    {
        "@type": "Comment",
        "text": "Who's the person you're with?",
        "author": {
          "@type": "Person",
          "name": " <- Saul Douglas -> ",
          "url": " <- https://example.com/user/saul-douglas -> ",
          "agentInteractionStatistic": {
            "@type": "InteractionCounter",
            "interactionType": "https://schema.org/WriteAction",
            "userInteractionCount": "167"
          }
        },
        "datePublished": "%%date%%"
    }
]`
					},
					{id: "contactPoint", name: "contactPoint", value: `
"contactPoint": {
  "@type": "ContactPoint",
  "telephone": "%%business_phone%%",
  "email": "%%business_email%%",
}`},
					{id: "contentUrl", name: "contentUrl", value: `
"contentUrl": "www.example.come/mp4"`
					},
					{id: "cookTime", name: "cookTime", value: `
"cookTime": "PT30M"`
					},
					{id: "copyrightNotice", name: "copyrightNotice", value: `
"copyrightNotice": "Clara Kent"`
					},
					{id: "courseMode", name: "courseMode", value: `
"courseMode": [
    "Online",
    "Onsite",
    "Blended"
]`
					},
					{id: "coursePrerequisites", name: "coursePrerequisites", value: `
"coursePrerequisites": [
    "Basic understanding of C++ up to arrays and functions.",
    "https://www.example.com/beginnerCpp"
]`
					},
					{id: "courseSchedule", name: "courseSchedule", value: `
"courseSchedule": {
   "@type": "Schedule",
   "repeatCount": "6",
   "repeatFrequency": "Weekly"
}`
					},
					{id: "courseWorkload", name: "courseWorkload", value: `
"courseWorkload": "PT22H"`
					},
					{id: "creator", name: "creator", value: `
"creator": {
    "@type": "Person",
    "name": "Brixton Brownstone"
}`
					},
					{id: "credentialCategory", name: "credentialCategory", value: `
"credentialCategory": "Certificate"`
					},
					{id: "currency", name: "currency", value: `
"currency": "USD"`
					},
					{id: "dataFeedElement", name: "dataFeedElement", value: `
"dataFeedElement": [
    {
    "@context": "https://schema.org",
    "@type": "Book",
    "@id": "%%post_url%%#book",
    "url": "%%post_url%%",
    "name": " <- The Title of the Book -> ",
    "author": {
        "@type": "Person",
        "name": " <- The Person's Name -> "
    },
    "sameAs": "https://en.wikipedia.org/wiki/The_Catcher_in_the_Rye",
    }
]`
					},
					{id: "dateCreated", name: "dateCreated", value: `
"dateCreated": "%%date%%"`
					},
					{id: "dateModified", name: "dateModified", value: `
"dateModified": "%%modified%%"`
					},
					{id: "datePosted",name: "datePosted", value: `
"datePosted": "%%date%%"`
					},
					{id: "datePublished",name: "datePublished", value: `
"datePublished": "%%date%%"`
					},
					{id: "department", name: "department", value: `
"department": [
        {
          "@type": "Pharmacy",
          "image": "https://example.com/photos/1x1/photo.jpg",
          "name": "Dave's Pharmacy",
          "address": {
            "@type": "PostalAddress",
            "streetAddress": "%%street_address%%",
            "addressLocality": "%%locality%%",
            "addressRegion": "%%region%%",
            "postalCode": "%%postal_code%%",
            "addressCountry": "US"
          },
          "priceRange": "$",
          "telephone": "+14088719385",
          "openingHoursSpecification": [
            {
              "@type": "OpeningHoursSpecification",
              "dayOfWeek": [
                "Monday",
                "Tuesday",
                "Wednesday",
                "Thursday",
                "Friday"
              ],
              "opens": "09:00",
              "closes": "19:00"
            },
            {
              "@type": "OpeningHoursSpecification",
              "dayOfWeek": "Saturday",
              "opens": "09:00",
              "closes": "17:00"
            },
            {
              "@type": "OpeningHoursSpecification",
              "dayOfWeek": "Sunday",
              "opens": "11:00",
              "closes": "17:00"
            }
          ]
        }
]`
					},
					{id: "description", name: "description", value: `
"description": "%%meta_description%%"`
					},
					{id: "director", name: "director", value: `
"director": {
  "@type": "Person",
  "name": "Bradley Cooper"
}`
					},
					{id: "disambiguatingDescription", name: "disambiguatingDescription", value: `
"disambiguatingDescription": " <- Enter a short description of the item used to disambiguate from the other similar items. -> "`
					},
					{id: "driveWheelConfiguration", name: "driveWheelConfiguration", value: `
"driveWheelConfiguration": "https://schema.org/FourWheelDriveConfiguration"`
					},
					{id: "duns", name: "duns", value: `
"duns": "0060"`
					},
					{id: "duration", name: "duration", value: `
"duration": "PT1H"`
					},
					{id: "educationalAlignment", name: "educationalAlignment", value: `
"educationalAlignment": [
        {
          "@type": "AlignmentObject",
          "alignmentType": "educationalSubject",
          "targetName": "Biology"
        }
]`
					},
					{id: "educationalCredentialAwarded", name: "educationalCredentialAwarded", value: `
"educationalCredentialAwarded": [
    {
        "@type": "EducationalOccupationalCredential",
        "name": "CourseProvider Certificate",
        "url": "www.example.com",
        "credentialCategory": "Certificate",
        "offers": [
                {
                    "@type": "Offer",
                    "category": "Paid",
                    "price": 5,
                    "priceCurrency": "USD"
                }
       ]
    }
]`
					},
					{id: "educationalFramework", name: "educationalFramework", value: `
"educationalFramework": "Common Core"`
					},
					{id: "educationalLevel", name: "educationalLevel", value: `
"educationalLevel": "Advanced"`
					},
					{id: "educationRequirements", name: "educationRequirements", value: `
"educationRequirements": {
        "@type": "EducationalOccupationalCredential",
        "credentialCategory": "bachelor degree"
}`
					},
					{id: "eduQuestionType", name: "eduQuestionType", value: `
"eduQuestionType": "Flashcard"`
					},
					{id: "eligibleRegion", name: "eligibleRegion", value: `
"eligibleRegion": {
    "@type": "Country",
    "name": "US"
}`
					},
					{id: "email", name: "email", value: `
"email": "%%business_email%%"`
					},
					{id: "employmentType", name: "employmentType", value: `
"employmentType": "CONTRACTOR"`
					},
					{id: "encodingFormat", name: "encodingFormat", value: `
"encodingFormat": "CSV"`
					},
					{id: "endDate", name: "endDate", value: `
"endDate": "YYYY-MM-DD"`
					},
					{id: "endTime", name: "endTime", value: `
"endTime": "YYYY-MM-DDT09:00:00+00:00"`
					},
					{id: "endOffset", name: "endOffset", value: `
"endOffset": "45"`
					},
					{id: "estimatedSalary", name: "estimatedSalary", value: `
"estimatedSalary": [{
  "@type": "MonetaryAmountDistribution",
  "name": "base",
  "currency": "USD",
  "duration": "P1Y",
  "minValue": "100000",
  "maxValue": "150000",
  "median": "124900"
}]`
					},
					{id: "eventAttendanceMode", name: "eventAttendanceMode", value: `
"eventAttendanceMode": "https://schema.org/OnlineEventAttendanceMode"`
					},
					{id: "eventStatus", name: "eventStatus", value: `
"eventStatus": "https://schema.org/EventScheduled"`
					},
					{id: "expectsAcceptanceOf", name: "expectsAcceptanceOf", value: `
"expectsAcceptanceOf": [
    {
        "@type": "Offer",
        "category": "Subscription",
        "availabilityStarts": "2020-01-01T11:0:00-04:00",
        "availabilityEnds": "2050-06-30T23:59:00-04:00",
        "eligibleRegion": {
            "@type": "Country",
            "name": "US"
        }
    }
],"`
					},
					{id: "experienceRequirements", name: "experienceRequirements", value: `
"experienceRequirements" : {
        "@type" : "OccupationalExperienceRequirements",
        "monthsOfExperience" : "36"
}`
					},
					{id: "expires", name: "expires", value: `
"expires": "2024-10-30T14:00:00+10:00"`
					},
					{id: "financialAidEligible", name: "financialAidEligible", value: `
"financialAidEligible": "Scholarship Available"`
					},
					{id: "firstAppearance", name: "firstAppearance", value: `
"firstAppearance": {
    "@type": "OpinionNewsArticle",
    "url": "https://example.com/news/a122121",
    "headline": "%%title%%",
    "datePublished": "2016-06-22",
    "author": {
            "@type": "Person",
            "name": "T. Tellar"
    },
    "image": "https://example.com/photos/1x1/photo.jpg",
    "publisher": {
            "@type": "Organization",
            "name": "Skeptical News",
            "logo": {
              "@type": "ImageObject",
              "url": "https://example.com/logo.jpg"
            }
    }
}`
					},
					{id: "foundingDate", name: "foundingDate", value: `
"foundingDate": "YYYY-MM-DD"`
					},
					{id: "funder", name: "funder", value: `
"funder":{
         "@type": "Organization",
         "name": "National Weather Service"
}`
					},
					{id: "geo", name: "geo", value: `
"geo": {
        "@type": "GeoCoordinates",
        "latitude": 40.761293,
        "longitude": -73.982294
}`
					},
					{id: "globalLocationNumber", name: "globalLocationNumber", value: `
"globalLocationNumber": "0088"`
					},
					{id: "hasCourseInstance", name: "hasCourseInstance", value: `
"hasCourseInstance": [
    {
            "@type": "CourseInstance",
            "courseMode": "Blended",
            "location": "Example University",
            "courseSchedule": {
                "@type": "Schedule",
                "duration": "PT3H",
                "repeatFrequency": "Daily",
                "repeatCount": 31,
                "startDate": "YYYY-MM-DD",
                "endDate": "YYYY-MM-DD"
            },
            "courseWorkload": "PT22H",
            "instructor": [{
                "@type": "Person",
                "name": "Ira D.",
                "description": "Professor at X-University",
                "image": "http://example.com/person.jpg"
            }]
    },{
            "@type": "CourseInstance",
            "courseMode": "Online",
            "courseWorkload": "P2D"
    },{
            "@type": "CourseInstance",
            "courseMode": "Onsite",
            "location": "Example University",
            "courseSchedule": {
                "@type": "Schedule",
                "duration": "PT5H",
                "repeatCount": 4,
                "repeatFrequency": "Weekly",
                "startDate": "2023-08-01",
                "endDate": "2023-8-31"
            }
    }
]`
					},
					{id: "hasPart", name: "hasPart", value: `
"hasPart": [
    {
        "@type": "Article",
        "headline": "%%title%%",
        "url": "%%post_url%%",
        "datePublished": "%%date%%",
        "author": "author": {
            "@type": "Person",
            "name": "T. Tellar"
          }
    },{
        "@type": "Course",
        "name": "%%title%%",
        "url": "%%post_url%%",
        "description": "%%meta_description%%"
    },{
        "@id": "%%post_url%%#book",
        "@type": "Book",
        "name": "%%title%%",
        "about": "http://id.worldcat.org/fast/1020337",
        "isPartOf": "#trilogy",
        "inLanguage": "en",
        "volumeNumber": "3",
        "author": {
            "@type": "Person",
            "name": "T. Tellar"
          }
    },{
          "@type": "Dataset",
          "name": "Sub dataset 01",
          "description": "Informative description of the first subdataset...",
          "license": "https://creativecommons.org/publicdomain/zero/1.0/",
          "creator":{
             "@type":"Organization",
             "name": "Sub dataset 01 creator"
          }
    },{
          "@context": "https://schema.org/",
          "@type": "Question",
          "eduQuestionType": "Flashcard",
          "text": "This is some fact about receptor molecules.",
          "acceptedAnswer": {
            "@type": "Answer",
            "text": "receptor molecules"
          }
    },{
            "@type": "WebPageElement",
            "isAccessibleForFree": "False",
            "cssSelector" : ".paywall"
}
]`
					},
					{id: "hiringOrganization", name: "hiringOrganization", value: `
"hiringOrganization": {
        "@type": "Organization",
        "name": "%%business_name%%",
        "sameAs": "https://www.google.com",
        "logo": "%%logo_url%%"
}`
					},
					{id: "honorificPrefix", name: "honorificPrefix", value: `
"honorificPrefix": "Dr"`
					},
					{id: "honorificSuffix", name: "honorificSuffix", value: `
"honorificSuffix": "PhD"`
					},
					{id: "headline", name: "headline", value: `
"headline": "%%title%%"`
					},
					{id: "identifier", name: "identifier", value: `
"identifier": {
    "@type": "PropertyValue",
    "name": " <- Enter the name of the item. -> ",
    "value": "1234567"
}`
					},
					{id: "image", name: "image", value: `
"image": "%%post_thumbnail_url%%"`
					},
					{id: "includedInDataCatalog", name: "includedInDataCatalog", value: `
"includedInDataCatalog":{
         "@type":"DataCatalog",
         "name":"data.gov"
}`},
					{id: "industry", name: "industry", value: `
"industry": "Technology"`
					},
					{id: "inLanguage", name: "inLanguage", value: `
"inLanguage": "en"`
					},
					{id: "instructor", name: "instructor", value: `
"instructor": [{
   "@type": "Person",
   "name": "Dana A.",
   "description": "Professor at X-University",
   "image": "http://examplePerson.jpg"
}
]`
					},
					{id: "interactionStatistic", name: "interactionStatistic", value: `
"interactionStatistic": {
    "@type": "InteractionCounter",
    "interactionType": "https://schema.org/LikeAction",
    "userInteractionCount": "27"
}`
					},
					{id: "interactionType", name: "interactionType", value: `
"interactionType": "https://schema.org/LikeAction"`
					},
					{id: "isAccessibleForFree", name: "isAccessibleForFree", value: `
"isAccessibleForFree": "False"`
					},
					{id: "isbn", name: "isbn", value: `
"isbn": "9787543321724"`
					},
					{id: "isLiveBroadcast", name: "isLiveBroadcast", value: `
"isLiveBroadcast": true`
					},
					{id: "iso6523Code", name: "iso6523Code", value: `
"iso6523Code": "0199: Legal Entity Identifier (LEI)"`
					},
					{id: "isPartOf", name: "isPartOf", value: `
"isPartOf": {
    "@type" : "Blog",
    "@id": "%%post_url%%#blog",
    "name": "%%business_name%% Blog",
    "publisher": {
        "@type": "Organization",
        "@id": "%%post_url%%#organization",
        "name": "%%business_name%%"
    }
}`
					},
					{id: "item", name: "item", value: `
"item": "{
        "@type": "Recipe",
        "name": "Name",
        "url": "https://example.com/recipe"
}`
					},
					{id: "itemCondition", name: "itemCondition", value: `
"itemCondition": "https://schema.org/NewCondition"`
					},
					{id: "itemListElement", name: "itemListElement", value: `
"itemListElement": [
    {
        "@type": "ListItem",
        "position": 1,
        "name": "Books",
        "item": "https://example.com/books"
    },{
        "@type": "ListItem",
        "position": 2,
        "name": "Science Fiction",
        "item": "https://example.com/books/sciencefiction"
    },{
        "@type": "ListItem",
        "position": 3,
        "name": "Award Winners"
    }
]`
					},
					{id: "itemReviewed", name: "itemReviewed", value: `
"itemReviewed": {
        "@type": "Claim",
        "author": {
          "@type": "Organization",
          "name": "%%business_name%%",
          "sameAs": "https://example.flatworlders.com/we-know-that-the-world-is-flat"
        },
        "datePublished": "2016-06-20",
        "appearance": {
          "@type": "OpinionNewsArticle",
          "url": "https://example.com/news/a122121",
          "headline": "%%title%%",
          "datePublished": "%%date%%",
          "author": {
            "@type": "Person",
            "name": "T. Tellar"
          },
          "image": "https://example.com/photos/1x1/photo.jpg",
          "publisher": {
            "@type": "Organization",
            "name": "%%business_name%%",
            "logo": {
              "@type": "ImageObject",
              "url": "https://example.com/logo.jpg"
            }
          }
        }
    },{
      "@type": "EmployerAggregateRating",
      "itemReviewed": {
        "@type": "Organization",
        "name" : "%%business_name%%",
        "sameAs" : "https://example.com"
      },
      "ratingValue": "91",
      "bestRating": "100",
      "worstRating": "1",
      "ratingCount" : "10561"
    }
]`
					},
					{id: "jobBenefits", name: "jobBenefits", value: `
"jobBenefits": "6 weeks paid vacation every year"`
					},
					{id: "jobLocation", name: "jobLocation", value: `
"jobLocation": {
    "@type": "Place",
    "address": {
        "@type": "PostalAddress",
        "streetAddress": "%%street_address%%",
        "addressLocality": "%%locality%%",
        "addressRegion": "%%region%%",
        "postalCode": "%%postal_code%%",
        "addressCountry": "US"
    }
}`
					},
					{id: "jobLocationType", name: "jobLocationType", value: `
"jobLocationType": "TELECOMMUTE"`
					},
					{id: "jobTitle", name: "jobTitle", value: `
"jobTitle": "Job Title"`
					},
					{id: "keywords", name: "keywords", value: `
"keywords":[
         " <- Keywords or tags used to describe some item. -> ",
         " <- Multiple textual entries in a keywords list are typically delimited by commas. -> "
]`
					},
					{id: "lastReviewed", name: "lastReviewed", value: `
"lastReviewed": "YYYY-MM-YYT14:20:00+10:00"`
					},
					{id: "latitude", name: "latitude", value: `
"latitude": 40.761293`
					},
					{id: "learningResourceType", name: "learningResourceType", value: `
"learningResourceType": "Problem walkthrough"`
					},
					{id: "legalName", name: "legalName", value: `
"legalName": "The registered, legal name, and different from the name property."`
					},
					{id: "leiCode", name: "leiCode", value: `
"leiCode": "0199"`
					},
					{id: "lender", name: "lender", value: `
"lender": [
    {
        "@type": "Person",
        "name": "Steve"
    },
    {
        "@type": "LibrarySystem",
        "@id": "%%post_url%%#librarysystem"
    },
]`},
					{id: "license", name: "license", value: `
"license" : {
        "@type": "CreativeWork",
        "name": "Custom license",
        "url": "https://example.com/custom_license"
}`
					},
					{id: "location", name: "location", value: `
"location": [
    {
        "@type": "PostalAddress",
        "streetAddress": "%%street_address%%",
        "addressLocality": "%%locality%%",
        "addressRegion": "%%region%%",
        "postalCode": "%%postal_code%%",
        "addressCountry": "US"
    },{
        "@type": "VirtualLocation",
        "url": "https://operaonline.stream5.com/"
    }
]`
					},
					{id: "logo", name: "logo", value: `
"logo": "%%logo_url%%"`
					},
					{id: "mainEntity", name: "mainEntity", value: `
"mainEntity": [
    {
        "@type": "Question",
        "name": " <- Enter the name of the item. -> ",
        "acceptedAnswer": {
            "@type": "Answer",
            "text": "This is an example answer to question 1."
        }
    },{
        "@type": "Person",
        "name": " <- Enter the name of the item. -> ",
        "alternateName": "ahuff23",
        "identifier": "123475623"
    }
]`},
					{id: "mainEntityOfPage", name: "mainEntityOfPage", value: `
"mainEntityOfPage": " <- Enter a page (or other CreativeWork) for which this thing is the main entity being described. -> "`
					},
					{id: "maxValue", name: "maxValue", value: `
"maxValue": "999"`
					},
					{id: "median", name: "median", value: `
"median": "124900"`
					},
					{id: "member", name: "member", value: `
"member": [{
  "@type": "Library",
  "@id": "%%post_url%%#library",
  "name": "Campbell Library",
  "location": {
    "@type": "PostalAddress",
    "streetAddress": "%%street_address%%",
    "addressLocality": "%%locality%%",
    "addressRegion": "%%region%%",
    "postalCode": "%%postal_code%%",
    "addressCountry": "US"
  }
}
]`
					},
					{id: "mileageFromOdometer", name: "mileageFromOdometer", value: `
"mileageFromOdometer": {
        "@type": "QuantitativeValue",
        "value": "20170",
        "unitCode": "SMI"
}`
					},
					{id: "minValue", name: "minValue", value: `
"minValue": "100"`
					},
					{id: "model", name: "model", value: `
"model": "Ram"`
					},
					{id: "monthsOfExperience", name: "monthsOfExperience", value: `
"monthsOfExperience": "36"`
					},
					{id: "naics", name: "naics", value: `
"naics": "naics code"`
					},
					{id: "name", name: "name", value: `
"name": " <- Enter the name of the item. -> "`
					},
					{id: "numberOfDoors", name: "numberOfDoors", value: `
"numberOfDoors": "4"`
					},
					{id: "numberOfEmployees", name: "numberOfEmployees", value: `
"numberOfEmployees": {
  "@type": "QuantitativeValue",
  "value": 2056
}`},
					{id: "object", name: "object", value: `
"object": {
    "@type": "ScholarlyArticle",
    "name": "Article"
}`
					},
					{id: "occupationLocation", name: "occupationLocation", value: `
"occupationLocation": [
    {
        "@type": "City",
        "name": "Seattle, Washington, US"
    },{
        "@type": "State",
        "name": "WA, US"
    },{
        "@type": "Country",
        "name": "US"
    }
]`
					},
					{id: "offers", name: "offers", value: `
"offers": [
    {
        "@type": "Offer",
        "category": "Paid",
        "url": "https://www.example.com/event_offer/12345_201803180430",
        "price": "30",
        "priceCurrency": "USD",
        "availability": "https://schema.org/InStock",
        "validFrom": "2024-05-21T12:00"
    },{
      "@type": "Offer",
      "availability": "https://schema.org/InStock",
      "serialNumber": "CONC91000937",
      "sku": "780 R2",
      "offeredBy": {
          "@type": "Library",
          "@id": "%%post_url%%#library",
          "name": "Anytown City Library"
      },
      "businessFunction": "http://purl.org/goodrelations/v1#LeaseOut",
      "itemOffered": "#record"
    }
]`},
					{id: "operatingSystem", name: "operatingSystem", value: `
"operatingSystem": "iOS"`
					},
					{id: "openingHoursSpecification", name: "openingHoursSpecification", value: `
"openingHoursSpecification": [
    {
        "dayOfWeek": [
          "Monday",
          "Tuesday",
          "Wednesday",
          "Thursday",
          "Friday"
        ],
        "opens": "09:00",
        "closes": "21:00"
    },
    {
        "@type": "OpeningHoursSpecification",
        "dayOfWeek": [
          "Saturday",
          "Sunday"
        ],
        "opens": "10:00",
        "closes": "23:00"
    }
]`
					},
					{id: "organizer", name: "organizer", value: `
"organizer": {
    "@type": "Organization",
    "name": "Kira and Morrison Music",
    "url": "https://kiraandmorrisonmusic.com"
}`
					},
					{id: "percentile10", name: "percentile10", value: `
"percentile10": "10000"`
					},
					{id: "percentile25", name: "percentile25", value: `
"percentile25": "20000"`
					},
					{id: "percentile75", name: "percentile75", value: `
"percentile75": "27000"`
					},
					{id: "percentile90", name: "percentile90", value: `
"percentile90": "60000"`
					},
					{id: "performer", name: "performer", value: `
"performer": {
    "@type": "PerformingGroup",
    "name": "Kira and Morrison"
}`
					},
					{id: "position", name: "position", value: `
"position": "1"`
					},
					{id: "publication", name: "publication", value: `
"publication": {
    "@type": "BroadcastEvent",
    "name": "First scheduled broadcast",
    "isLiveBroadcast": true,
    "startDate": "2018-10-27T14:00:00+00:00",
    "endDate": "2018-10-27T14:37:14+00:00"
}`
					},
					{id: "previousStartDate", name: "previousStartDate", value: `
"previousStartDate": [
        "2020-03-21T19:00-05:00",
        "2020-03-20T19:00-05:00",
        "2020-03-21T19:00-05:00"
]`
					},
					{id: "price", name: "price", value: `
"price": "6.99"}`
					},
					{id: "priceCurrency", name: "priceCurrency", value: `
"priceCurrency": "USD"}`
					},
					{id: "provider", name: "provider", value: `
"provider": {
    "@type": "Organization",
    "name": "%%business_name%%",
    "url": "%%home_url%%"
}`
					},
					{id: "postalCode", name: "postalCode", value: `
"postalCode": "%%postal_code%%"`
					},
					{id: "potentialAction", name: "potentialAction", value: `
"potentialAction": [{
  "@type": "SearchAction",
  "target": {
    "@type": "EntryPoint",
    "urlTemplate": "https://query.example.com/search?q={search-term}"
  },
  "query-input": "required name=search-term"
}]`
					},
					{id: "propertyID", name: "propertyID", value: `
"propertyID": "LCCN"`
					},
					{id: "publisher", name: "publisher", value: `
"publisher": {
    "@type": "Organization",
    "name": "%%business_name%%",
    "url": "%%home_url%%",
    "logo": "%%logo_url%%"
}`
					},
					{id: "ratingCount", name: "ratingCount", value: `
"ratingCount": "10561"`
					},
					{id: "ratingValue", name: "ratingValue", value: `
"ratingValue": "91"`
					},
					{id: "regionsAllowed", name: "regionsAllowed", value: `
"regionsAllowed": "US"`
					},
					{id: "repeatCount", name: "repeatCount", value: `
"repeatCount": "28"`
					},
					{id: "review", name: "Review", value: `
"review": [
		{
			"@type": "Review",
			"author": {
				"@type": "Person",
				"name": "Reviewer Name"
			},
			"datePublished": "2020-08-31",
			"reviewBody": "The review text.",
			"reviewRating": {
			  "@type": "Rating",
			  "ratingValue": "3",
			  "bestRating": "5"
			}
		},{
			"@type": "Review",
			"author": {
				"@type": "Person",
				"name": "Second Reviewer"
			},
			"datePublished": "2024-01-01",
			"reviewBody": "The review text.",
			"reviewRating": {
			  "@type": "Rating",
			  "ratingValue": "4",
			  "bestRating": "5"
			}
		}
	],`
					},
					{id: "reviewCount", name: "reviewCount", value: `
"reviewCount": "0"`
					},
					{id: "reviewRating", name: "reviewRating", value: `
"reviewRating": {
    "@type": "Rating",
    "ratingValue": "4",
    "bestRating": "5"
}`
					},
					{id: "repeatFrequency", name: "repeatFrequency", value: `
"repeatFrequency": "Daily"`
					},
					{id: "sameAs", name: "sameAs", value: `
"sameAs": " <- Enter a URL of a reference Web page that unambiguously indicates the item's identity. E.g., the URL of the item's Wikipedia page, Wikidata entry, or official website. -> "`
					},
					{id: "sampleSize", name: "sampleSize", value: `
"sampleSize": "42"`
					},
					{id: "sharedContent", name: "sharedContent", value: `
"sharedContent": {
    "@type": "WebPage",
    "url": "https://example.com/external-url"
}`
					},
					{id: "spatialCoverage", name: "spatialCoverage", value: `
"spatialCoverage:" "Brisbane, Qld"`
					},
					{id: "startDate", name: "startDate", value: `
"startDate": "YYYY-MM-DD"`
					},
					{id: "startOffset", name: "startOffset", value: `
"startOffset": "201"`
					},
					{id: "startTime", name: "startTime", value: `
"startTime": "YYYY-MM-DDT09:00:00+00:00"`
					},
					{id: "streetAddress", name: "streetAddress", value: `
"streetAddress": "%%street_address%%"`
					},
					{id: "syllabusSections", name: "syllabusSections", value: `
"syllabusSections": [
        {
          "@type": "Syllabus",
          "name": "Memory Allocation",
          "description": "Learn how memory is allocated when creating C++ variables.",
          "timeRequired": "PT6H"
        },
        {
          "@type": "Syllabus",
          "name": "C++ Pointers",
          "description": "Learn what a C++ pointer is and when they are used.",
          "timeRequired": "PT11H"
        }
]`
					},
					{id: "target", name: "target", value: `
"target": {
    "@type": "EntryPoint",
    "urlTemplate": "https://example.com/borrowpurchase?bookId=170",
    "actionPlatform": [
        "https://schema.org/DesktopWebPlatform",
        "https://schema.org/AndroidPlatform",
        "https://schema.org/IOSPlatform"
    ]
}`
					},
					{id: "targetName", name: "targetName", value: `
"targetName": "Biology"`
					},
					{id: "targetUrl", name: "targetUrl", value: `
"targetUrl": "https://www.corestandards.org/Math/Content/7/SP/B/4/"`
					},
					{id: "teaches", name: "teaches", value: `
"teaches": [
    "Practice and apply systems thinking to plan for change",
    "Understand how memory allocation works."
]`
					},
					{id: "telephone", name: "telephone", value: `
"telephone": "<?php echo $metadata['phone_number']; ?>"`
					},
					{id: "temporalCoverage", name: "temporalCoverage", value: `
"temporalCoverage": "1950-01-01/2013-12-18"`
					},
					{id: "text", name: "text", value: `
"text": "Look at how cool this concert was!"`
					},
					{id: "timeRequired", name: "timeRequired", value: `
"timeRequired": "PT5H"`
					},
					{id: "unitCode", name: "unitCode", value: `
"unitCode": "SMI"`
					},
					{id: "url", name: "url", value: `
"url": "%%post_url%%"`
					},
					{id: "urlTemplate", name: "urlTemplate", value: `
"urlTemplate": "https://example.com/borrowpurchase?bookId=170"`
					},
					{id: "userInteractionCount", name: "userInteractionCount", value: `
"userInteractionCount": "27"`
					},
					{id: "validFrom", name: "validFrom", value: `
"validFrom": "YYYY-MM-DDT12:00+10:00"`
					},
					{id: "validThrough", name: "validThrough", value: `
"validThrough": "YYYY-MM-DDT12:00+10:00"`
					},
					{id: "value", name: "value", value: `
"value": "2056"`
					},
					{id: "vatID", name: "vatID", value: `
"vatID": "VAT Code"`
					},
					{id: "vehicleConfiguration", name: "vehicleConfiguration", value: `
"vehicleConfiguration": "ST"`
					},
					{id: "vehicleEngine", name: "vehicleEngine", value: `
"vehicleEngine": {
        "@type": "EngineSpecification",
        "fuelType": "Gasoline"
}`
					},
					{id: "vehicleIdentificationNumber", name: "vehicleIdentificationNumber", value: `
"vehicleIdentificationNumber": "1BXKF23ZXXJ000000"`
					},
					{id: "vehicleInteriorColor", name: "vehicleInteriorColor", value: `
"vehicleInteriorColor": "Gray"`
					},
					{id: "vehicleInteriorType", name: "vehicleInteriorType", value: `
"vehicleInteriorType": "Standard"`
					},
					{id: "vehicleModelDate", name: "vehicleModelDate", value: `
"vehicleModelDate": "2024"`
					},
					{id: "vehicleSeatingCapacity", name: "vehicleSeatingCapacity", value: `
"vehicleSeatingCapacity": "5"`
					},
					{id: "vehicleTransmission", name: "vehicleTransmission", value: `
"vehicleTransmission": "Manual"`
					},
					{id: "version", name: "version", value: `
"version": "version"`
					},
					{id: "video", name: "video", value: `
"video": {
        "@type": "VideoObject",
        "name": "Video name",
        "description": "The description of the video.",
        "uploadDate": "YYYY-MM-DD",
        "contentUrl": "www.example.come/mp4",
        "thumbnailUrl": "www.example.com/thumbnailurl.jpg"
}`
					},
					{id: "workExample", name: "workExample", value: `
"workExample": [
    {
          "@type": "Book",
          "@id": "%%post_url%%#book",
          "inLanguage": "zh",
          "isbn": "9787543321721",
          "bookEdition": "2nd Edition",
          "bookFormat": "https://schema.org/Hardcover"
    }
],`},
					{id: "worstRating", name: "worstRating", value: `
"worstRating": "1"`
					},
					{id: "yearsExperienceMax", name: "yearsExperienceMax", value: `
"yearsExperienceMax": "5"`
					},
					{id: "yearsExperienceMin", name: "yearsExperienceMin", value: `
"yearsExperienceMin": "10"`
					},
	
					{id: "distribution", name: "distribution",
					 value: `
"distribution":[
         {
            "@type":"DataDownload",
            "encodingFormat":"CSV",
            "contentUrl":"https://www.ncdc.noaa.gov/stormevents/ftp.jsp"
         },
         {
            "@type":"DataDownload",
            "encodingFormat":"XML",
            "contentUrl":"https://gis.ncdc.noaa.gov/all-records/catalog/search/resource/details.page?id=gov.noaa.ncdc:C00510"
         }
]`
					},					
					{id: "menu",
					 name: "menu",
					 value: `
"menu": "https://www.example.com/menu"`},
					{id: "nutrition", name: "nutrition",
					 value: `
"nutrition": {
        "@type": "NutritionInformation",
        "calories": "270 calories"
}`
					},
					{id: "prepTime",
					 name: "prepTime",
					 value: `
"prepTime": "PT20M"`
					},
					{id: "priceRange",
					 name: "priceRange",
					 value: `
"priceRange": "$$$"`
					},
					{id: "recipeCategory",
					 name: "recipeCategory",
				 value: `
"recipeCategory": "Dessert",`},
					{id: "recipeCuisine",
					 name: "recipeCuisine",
					 value: `
"recipeCuisine": "American"`
					},
					{id: "recipeIngredient", name: "recipeIngredient",
					 value: `
"recipeIngredient": [
        "2 cups of flour",
        "3/4 cup white sugar",
        "2 teaspoons baking powder",
        "1/2 teaspoon salt",
        "1/2 cup butter",
        "2 eggs",
        "3/4 cup milk"
]`
					},
					{id: "recipeInstructions", name: "recipeInstructions",
					 value: `
"recipeInstructions": [
        {
          "@type": "HowToStep",
          "name": "Preheat",
          "text": "Preheat the oven to 350 degrees F. Grease and flour a 9x9 inch pan.",
          "url": "https://example.com/party-coffee-cake#step1",
          "image": "https://example.com/photos/party-coffee-cake/step1.jpg"
        },
        {
          "@type": "HowToStep",
          "name": "Mix dry ingredients",
          "text": "In a large bowl, combine flour, sugar, baking powder, and salt.",
          "url": "https://example.com/party-coffee-cake#step2",
          "image": "https://example.com/photos/party-coffee-cake/step2.jpg"
        },
        {
          "@type": "HowToStep",
          "name": "Add wet ingredients",
          "text": "Mix in the butter, eggs, and milk.",
          "url": "https://example.com/party-coffee-cake#step3",
          "image": "https://example.com/photos/party-coffee-cake/step3.jpg"
        },
        {
          "@type": "HowToStep",
          "name": "Spread into pan",
          "text": "Spread into the prepared pan.",
          "url": "https://example.com/party-coffee-cake#step4",
          "image": "https://example.com/photos/party-coffee-cake/step4.jpg"
        },
        {
          "@type": "HowToStep",
          "name": "Bake",
          "text": "Bake for 30 to 35 minutes, or until firm.",
          "url": "https://example.com/party-coffee-cake#step5",
          "image": "https://example.com/photos/party-coffee-cake/step5.jpg"
        },
        {
          "@type": "HowToStep",
          "name": "Enjoy",
          "text": "Allow to cool and enjoy.",
          "url": "https://example.com/party-coffee-cake#step6",
          "image": "https://example.com/photos/party-coffee-cake/step6.jpg"
        }
]`
					},
					{id: "recipeYield", name: "recipeYield",
					 value: `
"recipeYield": "10"`
					},
					{id: "servesCuisine",
					 name: "servesCuisine", note: "",
					 value: `
"servesCuisine": "American"`
					},
					{id: "suggestedAnswer",name: "suggestedAnswer",
					 value: `
"suggestedAnswer": ""`
					},
					{id: "totalTime",
					 name: "totalTime", note: "",
				 value: `
"totalTime": "PT50M"`
					},
					{id: "upvoteCount", name: "upvoteCount",
					 value: `
"upvoteCount": "0"`},
				];
				let select_schema = document.getElementById('select_schema');				
				
				function set_schema_example() {
					let inclusion_index = -1;
					let schema_index = -1;
					
					if (!select_schema.value.startsWith('template_')) {
						for (let index = 0; index < SCHEMA.length; index++) { if (select_schema.value == SCHEMA[index].id) { schema_index = index; break; } }
						document.getElementById('p_schema_desc').innerHTML = SCHEMA[schema_index].desc;
						if (SCHEMA[schema_index].desc.length > 0) {
							document.getElementById('p_schema_desc').style.display = 'block';
						}
						else {
							document.getElementById('p_schema_desc').style.display = 'none';
						}
						document.getElementById('a_schema_link').href = SCHEMA[schema_index].slug;
						document.getElementById('a_schema_link').innerHTML = "Learn More";
						if (SCHEMA[schema_index].note.length > 0) {
							document.getElementById('as_schema').style.display = 'block';
							document.getElementById('as_schema').innerHTML = SCHEMA[schema_index].note;
						}
						else {
							document.getElementById('as_schema').style.display = 'none';
						}
						
						let inclusions_html = '';
						if (SCHEMA[schema_index].inclusions.length > 0) inclusions_html += '<p>\'' + SCHEMA[schema_index].id + '\' Properties</p>';
						for (let index = 0; index < SCHEMA[schema_index].inclusions.length; index++) {
							for (let j_index = 0; j_index < SCHEMA_INCLUSIONS.length; j_index++) {
								if (SCHEMA[schema_index].inclusions[index] == SCHEMA_INCLUSIONS[j_index].id) {
									inclusions_html += '<input type="checkbox" class="input_schema_inclusions" id="input_schema_inclusion_' + j_index + '" value="' + SCHEMA_INCLUSIONS[j_index].id + '" />' +
										'<label for="input_schema_inclusion_' + j_index + '">' + SCHEMA_INCLUSIONS[j_index].name + '</label>';
								}
							}
						}
						let inclusion_ids = SCHEMA[schema_index].default.concat(SCHEMA[schema_index].inclusions);
						let check_for_parent = SCHEMA[schema_index].parent || false;
						let parent_schema_id = -1;
						while (check_for_parent) {
							for (let index = 0; index < SCHEMA.length; index++) {
								if (parent_schema_id == -1) {
									if (SCHEMA[schema_index].parent == SCHEMA[index].id) {
										parent_schema_id = index;
										break;
									}
								}
								else {
									if (SCHEMA[parent_schema_id].parent == SCHEMA[index].id) {
										parent_schema_id = index;
										break;
									}
								}
							}
							let new_heading = false;
							if (SCHEMA[parent_schema_id].inclusions.length > 0) inclusions_html += '<p>\'' + SCHEMA[parent_schema_id].id + '\' Properties</p>';
							for (let index = 0; index < SCHEMA[parent_schema_id].inclusions.length; index++) {
								let existing_inclusion = false;
								for (let j_index = 0; j_index < inclusion_ids.length; j_index++) {
									if (SCHEMA[parent_schema_id].inclusions[index] == inclusion_ids[j_index]) {
										existing_inclusion = true;
										break;
									}
								}
								if (!existing_inclusion) {
									for (let j_index = 0; j_index < SCHEMA_INCLUSIONS.length; j_index++) {
										if (SCHEMA[parent_schema_id].inclusions[index] == SCHEMA_INCLUSIONS[j_index].id) {
											new_heading = true;
											inclusion_ids[inclusion_ids.length] = SCHEMA_INCLUSIONS[j_index].id;
											inclusions_html += '<input type="checkbox" class="input_schema_inclusions" id="input_schema_inclusion_' + j_index + '" value="' + SCHEMA_INCLUSIONS[j_index].id + '" style="margin: 3px;" />' +
												'<label for="input_schema_inclusion_' + j_index + '">' + SCHEMA_INCLUSIONS[j_index].name + '</label>';
										}
									}
								}
							}
							check_for_parent = SCHEMA[parent_schema_id].parent || false; 
						}
						
						let div_schema_inclusions = document.getElementById('div_schema_inclusions');
						div_schema_inclusions.innerHTML = '';
						div_schema_inclusions.innerHTML = inclusions_html;
						
						let schema_inclusions = document.getElementsByClassName('input_schema_inclusions');
						if (schema_inclusions) {
							if (schema_inclusions.length > 0) {
								document.getElementById('div_schema_inclusions_container').style.display = 'flex';
								if (div_schema_inclusions) {
									div_schema_inclusions.addEventListener('click', function(event) {
										if (event.target.classList.contains('input_schema_inclusions')) {
											let inclusion_index_array = event.target.id.split("input_schema_inclusion_");
											inclusion_index = inclusion_index_array[1];
											set_schema_example_code(schema_index, inclusion_index);
										}
									});
								}
							}
							else { document.getElementById('div_schema_inclusions_container').style.display = 'none'; }
						}
						else { document.getElementById('div_schema_inclusions_container').style.display = 'none'; }
					}
					else {
						document.getElementById('p_schema_desc').style.display = 'none';
						document.getElementById('as_schema').style.display = 'none';
						document.getElementById('a_schema_link').href = 'https://schema.org/docs/full.html';
						document.getElementById('a_schema_link').innerHTML = "Learn More on Schema.org";
						document.getElementById('div_schema_inclusions_container').style.display = 'none';
					}
					set_schema_example_code(schema_index, inclusion_index);
				}
				function set_schema_example_code(schema_index, inclusion_index) {
					let new_schema_example = '';
					if (schema_index > -1) {
						let check_for_defaults = SCHEMA[schema_index].value || false;
						if (check_for_defaults) { new_schema_example = check_for_defaults; }
						else {
							new_schema_example = `{"@context": "http://schema.org/",
"@id": "%%post_url%%#` + (SCHEMA[schema_index].id).toLowerCase() + `",
"@type": "` + SCHEMA[schema_index].id + `"`;
							for (let index = 0; index < SCHEMA[schema_index].default.length; index++) {
								for (let inc_index = 0; inc_index < SCHEMA_INCLUSIONS.length; inc_index++) {
									if (SCHEMA_INCLUSIONS[inc_index].id == SCHEMA[schema_index].default[index]) {
										new_schema_example += `,` + SCHEMA_INCLUSIONS[inc_index].value;
									}
								}
							}
						}
						
						new_schema_example = new_schema_example.trim();
						if (new_schema_example.endsWith("}")) { new_schema_example = new_schema_example.slice(0, -1); }
						if (new_schema_example.endsWith(',')) { new_schema_example = new_schema_example.slice(0, -1); }
						
						let inclusions_checked = Array.from(document.getElementsByClassName('input_schema_inclusions')).filter(function(element) { return element.type === 'checkbox' && element.checked; });
						if (inclusions_checked) {
							for (index = 0; index < inclusions_checked.length; index++) {
								for (let j_index = 0; j_index < SCHEMA_INCLUSIONS.length; j_index++) {
									if (inclusions_checked[index].value == SCHEMA_INCLUSIONS[j_index].id) {
										new_schema_example += `,` + SCHEMA_INCLUSIONS[j_index].value;
									}
								}
							}
						}
						new_schema_example += `
}`;
					}
					else {
						let templates = <?php echo $encoded_templates; ?>;
						let index = select_schema.value.split('template_');
						new_schema_example = templates[index[1]].schema;
					}
					let schema_example = document.getElementById('schema_example_ta');
					schema_example.value = new_schema_example;
					let custom_schema = document.getElementById("custom_schema");
					if (custom_schema.value.length == 0) { document.getElementById('b_copy_schema').innerHTML = 'Add Schema Code'; }
					else { document.getElementById('b_copy_schema').innerHTML = 'Append Schema Code'; }
				}
				set_schema_example();
				select_schema.addEventListener('change', set_schema_example);
				document.getElementById('b_copy_schema').addEventListener('click', function() {
					let custom_schema = document.getElementById("custom_schema");
					let schema_example = document.getElementById('schema_example_ta');
					let new_schema = "";
					if (custom_schema.value.length > 0) {
						if (!custom_schema.value.startsWith('[')) { new_schema = `[` + custom_schema.value; }
						if (custom_schema.value.endsWith(']')) { new_schema = custom_schema.value.slice(0,-1); }						
						if (new_schema.endsWith('}')) { new_schema += `,`; }
					}
					new_schema += schema_example.value;
					if (new_schema.startsWith('[') && !new_schema.endsWith(']')) {
						new_schema += `]`;
					}
					custom_schema.value = new_schema;
					document.getElementById('b_copy_schema').innerHTML = 'Append Schema Code';
				});
			});
		</script>
		<?php
		$html_element .= ob_get_clean();
        return $html_element;
	}
	
	public static function setObjectMetadata($type, $object) {
		$metadata = self::initializeMetadata();
		$metadata['object_id'] = $object->ID ?? '';
		switch ($type) {
			case 'taxonomy':
				self::populateTaxonomyMetadata($metadata, $object);
				break;
			case 'author':
				self::populateAuthorMetadata($metadata, $object);
				break;
			case 'post':
				self::populatePostMetadata($metadata, $object);
				break;
			case 'home':
				self::populateHomeMetadata($metadata);
				break;
		}
		return $metadata;
	}
	
	private static function initializeMetadata() {
		return [
			'object_id' => '',
			'title' => '',
			'author_name' => '',
			'content' => '',
			'meta_og_image' => '',
			'modified_date' => '',
			'noindex' => '',
			'nofollow' => '',
			'post_date' => '',
			'schema' => '',
			'target_keyword' => '',
			'url' => '',
			'post_excerpt' => '',
			'meta_title' => '',
			'meta_description' => '',
			'meta_title_updated' => '',
			'meta_description_updated' => '',
			'currentyear' => date('Y'),
			'sitetitle' => get_bloginfo('name'),
			'tagline' => get_bloginfo('description'),
			'business_name' => get_option('zynith_business_name'),
			'business_email' => get_option('zynith_business_email'),
			'phone_number' => get_option('zynith_phone_number'),
			'street_address' => get_option('zynith_street_address'),
			'address_locality' => get_option('zynith_address_locality'),
			'address_region' => get_option('zynith_address_region'),
			'postal_code' => get_option('zynith_postal_code'),
			'address_country' => get_option('zynith_address_country'),
			'address_country_code' => get_option('zynith_address_country_code'),
			'home_url' => home_url(),
			'logo_url' => get_option('zynith_logo') ? wp_get_attachment_url(get_option('zynith_logo')) : ''
		];
	}

	private static function populateTaxonomyMetadata(&$metadata, $object) {
		if (!isset($object->term_id)) return;
		$metadata['object_id'] = $object->term_id;
		$metadata['meta_title'] = get_term_meta($metadata['object_id'], '_custom_meta_title', true) ?: '';
    	$metadata['meta_description'] = get_term_meta($metadata['object_id'], '_custom_meta_description', true) ?: '';
		$metadata['noindex'] = get_term_meta($metadata['object_id'], '_custom_noindex', true) ?: '';
		$metadata['nofollow'] = get_term_meta($metadata['object_id'], '_custom_nofollow', true) ?: '';
		$metadata['target_keyword'] = get_term_meta($metadata['object_id'], '_custom_target_keyword', true) ?: '';
		$metadata['meta_og_image'] = get_term_meta($metadata['object_id'], '_custom_meta_og_image', true) ?: '';
		$metadata['schema'] = get_term_meta($metadata['object_id'], '_custom_schema', true) ?: '';
		$metadata['content'] = wp_strip_all_tags(term_description($metadata['object_id']));
		$metadata['url'] = get_term_link($metadata['object_id'], $object->taxonomy);
		if (is_wp_error($metadata['url'])) $metadata['url'] = '';
		$metadata['title'] = $object->name ?: '';
		$metadata['author_name'] = get_the_author_meta('display_name', get_current_user_id());
		$metadata['post_date'] = current_time('Y-m-d');
		$metadata['modified_date'] = current_time('Y-m-d');
		if (!empty($object->post_excerpt)) $metadata['post_excerpt'] = apply_filters('the_excerpt', $object->post_excerpt);
		if ($metadata['meta_description_updated'] != '1' && empty($metadata['meta_description'])) $metadata['meta_description'] = !empty($metadata['content']) ? $metadata['content'] : wp_trim_words($metadata['post_excerpt'], 56, '...');
	}
	
	private static function populateAuthorMetadata(&$metadata, $object) {
		if (!isset($object->ID)) return;
		$metadata['object_id'] = $object->ID;
		$metadata['meta_title'] = sanitize_text_field(get_user_meta($metadata['object_id'], '_custom_meta_title', true));
		$metadata['meta_description'] = sanitize_textarea_field(html_entity_decode(get_user_meta($metadata['object_id'], '_custom_meta_description', true), ENT_QUOTES, 'UTF-8'));
		$metadata['noindex'] = sanitize_text_field(get_user_meta($metadata['object_id'], '_custom_noindex', true));
		$metadata['nofollow'] = sanitize_text_field(get_user_meta($metadata['object_id'], '_custom_nofollow', true));
		$metadata['target_keyword'] = sanitize_text_field(get_user_meta($metadata['object_id'], '_custom_target_keyword', true));
		$metadata['meta_og_image'] = esc_url(get_user_meta($metadata['object_id'], '_custom_meta_og_image', true));
		$metadata['schema'] = sanitize_textarea_field(get_user_meta($metadata['object_id'], '_custom_schema', true));
		$metadata['content'] = wp_kses_post(apply_filters('the_content', get_the_author_meta('description', $metadata['object_id'])));
		$metadata['url'] = esc_url(get_author_posts_url($metadata['object_id'], $object->user_nicename));
		$metadata['author_name'] = sanitize_text_field($object->display_name);
		$metadata['title'] = $metadata['author_name'];
		$metadata['modified_date'] = current_time('Y-m-d');
		$registered = new DateTime($object->user_registered);
		$metadata['post_date'] = $registered->format('Y-m-d');
	}
	
	private static function populatePostMetadata(&$metadata, $object) {
		if (!isset($object->ID)) return;
		$metadata['object_id'] = $object->ID;
		if (!empty($metadata['object_id'])) {
			$metadata['meta_title'] = sanitize_text_field(get_post_meta($metadata['object_id'], '_custom_meta_title', true));
			$metadata['meta_description'] = sanitize_textarea_field(get_post_meta($metadata['object_id'], '_custom_meta_description', true));
			$metadata['noindex'] = sanitize_text_field(get_post_meta($metadata['object_id'], '_custom_noindex', true));
			$metadata['nofollow'] = sanitize_text_field(get_post_meta($metadata['object_id'], '_custom_nofollow', true));
			$metadata['target_keyword'] = sanitize_text_field(get_post_meta($metadata['object_id'], '_custom_target_keyword', true));
			$metadata['meta_og_image'] = esc_url(get_post_meta($metadata['object_id'], '_custom_meta_og_image', true));
			$metadata['schema'] = sanitize_textarea_field(get_post_meta($metadata['object_id'], '_custom_schema', true));
			$metadata['url'] = esc_url(get_permalink($metadata['object_id']));
			$metadata['content'] = wp_kses_post($object->post_content);
			$metadata['author_name'] = sanitize_text_field(get_the_author_meta('display_name', $object->post_author));
			$metadata['meta_description_updated'] = sanitize_text_field(get_post_meta($metadata['object_id'], '_custom_meta_description_updated', true));
			$metadata['modified_date'] = current_time('Y-m-d');
			$metadata['post_date'] = current_time('Y-m-d');
			$metadata['post_excerpt'] = sanitize_textarea_field(get_the_excerpt($metadata['object_id']));
			$metadata['title'] = sanitize_text_field(get_the_title($metadata['object_id']));
			if (($metadata['meta_description_updated'] != '1' && empty($metadata['meta_description'])) || ($metadata['meta_description_updated'] != '1' && $metadata['meta_description'] == $metadata['post_excerpt'])) { 
				$metadata['meta_description'] = $metadata['post_excerpt'];
			}
		}
	}
	
	private static function populateHomeMetadata(&$metadata) {
		$metadata['object_id'] = '';
		$metadata['meta_title'] = get_option('zynith_homepage_meta_title');
		$metadata['meta_description'] = get_option('zynith_homepage_meta_description');
		$metadata['schema'] = get_option('zynith_homepage_schema_markup');
	}
	
	public static function calculate_keyword_density($content, $keyword) {
		$keyword = strtolower(trim($keyword));
        $content = strtolower(wp_strip_all_tags($content));
		$word_count = str_word_count($content);
        $keyword_count = substr_count($content, $keyword);
		return ($word_count > 0) ? round(($keyword_count / $word_count) * 100, 2) : 0;
	}
	
	public static function check_missing_alt_tags($content) {
		$content = html_entity_decode($content, ENT_QUOTES, 'UTF-8');
		preg_match_all('/<img[^>]+>/i', $content, $img_tags);
		$missing_alts = [];
		if (empty($img_tags[0])) return $missing_alts;
		foreach ($img_tags[0] as $img_tag) if (!preg_match('/\balt=("[^"]*"|\'[^\']*\')/i', $img_tag, $matches) || $matches[1] === '""' || $matches[1] === "''") $missing_alts[] = $img_tag;
		return $missing_alts;
	}
	
	public static function detect_broken_links($content, $object) {
    $content = html_entity_decode($content, ENT_QUOTES, 'UTF-8');
    $broken_links = [];
    if (empty($content) || !is_object($object)) return $broken_links;

    $object_id = $object->ID;
    $option = 'broken_links_' . get_class($object);
    $title = $object->post_title ?? $object->name ?? $object->display_name;
    $edit = admin_url(get_class($object) === 'WP_Post' ? "/post.php?post=$object_id&action=edit" : "/user-edit.php?user_id=$object_id");

    preg_match_all('/<a\s[^>]*href=["\']([^"\']+)["\']/i', $content, $links);
    $max_links_to_check = 18;
    $home_url = home_url();

    foreach (array_slice($links[1], 0, $max_links_to_check) as $link) {

        if (strpos($link, '#') === 0) {
            continue;
        }

        if (strpos($link, 'http') !== 0) {
            $link = $home_url . '/' . ltrim($link, '/');
        }

        $cache_key = 'link_status_' . md5($link);
        if (false === ($status = get_transient($cache_key))) {
            $response = wp_safe_remote_get($link);
            $status = !is_wp_error($response) && wp_remote_retrieve_response_code($response) >= 200 && wp_remote_retrieve_response_code($response) < 300;
            set_transient($cache_key, $status, 12 * HOUR_IN_SECONDS);
        }

        if (!$status) $broken_links[] = $link;
    }

    $broken_links_options = get_option($option, []);
    unset($broken_links_options[$object_id]);
    if (!empty($broken_links)) $broken_links_options[$object_id] = ['broken_links' => $broken_links, 'title' => $title, 'edit' => $edit];
    update_option($option, $broken_links_options);

    return $broken_links;
}

    public function save_metabox($post_id, $post) {
		if (!isset($_POST['seo_metabox_nonce']) || !wp_verify_nonce($_POST['seo_metabox_nonce'], 'seo_metabox_nonce_action') || !isset($_POST['dynamic_schema_meta_box_nonce']) ||
			!wp_verify_nonce($_POST['dynamic_schema_meta_box_nonce'], 'dynamic_schema_save_postdata') || (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || !current_user_can('edit_post', $post_id)) return;
		
		$noindex = isset($_POST['custom_noindex']) && $_POST['custom_noindex'] == 'on' ? 'yes' : 'no';
		$nofollow = isset($_POST['custom_nofollow']) && $_POST['custom_nofollow'] == 'on' ? 'yes' : 'no';
		$schema = isset($_POST['custom_schema']) ? $_POST['custom_schema'] : '';
		$target_keyword = isset($_POST['custom_target_keyword']) ? sanitize_text_field($_POST['custom_target_keyword']) : '';
		$meta_og_image = isset($_POST['custom_meta_og_image']) ? sanitize_text_field($_POST['custom_meta_og_image']) : '';
		$meta_title = isset($_POST['custom_meta_title']) ? sanitize_text_field($_POST['custom_meta_title']) : '';
		$meta_title_updated = isset($_POST['custom_meta_title_updated']) ? $_POST['custom_meta_title_updated'] : '';
		$meta_description = isset($_POST['custom_meta_description']) ? sanitize_textarea_field($_POST['custom_meta_description']) : '';
		$meta_description_updated = isset($_POST['custom_meta_description_updated']) ? $_POST['custom_meta_description_updated'] : '';
		update_post_meta($post_id, '_custom_meta_description_updated', $meta_description_updated);
		update_post_meta($post_id, '_custom_meta_title', $meta_title);
		update_post_meta($post_id, '_custom_meta_title_updated', $meta_title_updated);
        update_post_meta($post_id, '_custom_meta_description', $meta_description);
		update_post_meta($post_id, '_custom_noindex', $noindex);
        update_post_meta($post_id, '_custom_nofollow', $nofollow);
        update_post_meta($post_id, '_custom_schema', $schema);
        update_post_meta($post_id, '_custom_target_keyword', $target_keyword);
        update_post_meta($post_id, '_custom_meta_og_image', $meta_og_image);
    }
	
	public static function replace_seo_variables($text, $metadata) {
		$timezone = wp_timezone_string();
		$modified_date = isset($metadata['modified_date']) ? date('Y-m-d\TH:i:sP', strtotime($metadata['modified_date'])) : '';
		$post_date = isset($metadata['post_date']) ? date('Y-m-d\TH:i:sP', strtotime($metadata['post_date'])) : '';
		$modified_datetime = new DateTime($modified_date, new DateTimeZone('UTC'));
		$modified_datetime->setTimezone(new DateTimeZone($timezone));
		$post_datetime = new DateTime($post_date, new DateTimeZone('UTC'));
		$metadata['modified_date'] = $modified_datetime->format('Y-m-d\TH:i:sP');
		$metadata['post_date'] = $post_datetime->format('Y-m-d\TH:i:sP');		
		$replacements = [
			'%%title%%' => esc_html($metadata['title'] ?? ''),
			'%%post_url%%' => esc_url($metadata['url'] ?? ''),
			'%%date%%' => isset($metadata['post_date']) ? esc_html((new DateTime($metadata['post_date'], new DateTimeZone('UTC')))->setTimezone(new DateTimeZone($timezone))->format('Y-m-d\TH:i:sP')) : '',
			'%%modified%%' => isset($metadata['modified_date']) ? esc_html((new DateTime($metadata['modified_date'], new DateTimeZone('UTC')))->setTimezone(new DateTimeZone($timezone))->format('Y-m-d\TH:i:sP')) : '',
			'%%post_thumbnail_url%%' => esc_url($metadata['meta_og_image'] ?? ''),
			'%%post_excerpt%%' => esc_html($metadata['post_excerpt'] ?? ''),
			'%%title_tag%%' => esc_html($metadata['meta_title'] ?? ''),
			'%%meta_description%%' => esc_html($metadata['meta_description'] ?? ''),
			'%%target_keyword%%' => esc_html($metadata['target_keyword'] ?? ''),
			'%%sitetitle%%' => esc_html($metadata['sitetitle'] ?? ''),
			'%%tagline%%' => esc_html($metadata['tagline'] ?? ''),
			'%%logo_url%%' => esc_url($metadata['logo_url'] ?? ''),
			'%%home_url%%' => esc_url($metadata['home_url'] ?? ''),
			'%%business_name%%' => esc_html($metadata['business_name'] ?? ''),
			'%%business_email%%' => sanitize_email($metadata['business_email'] ?? ''),
			'%%business_phone%%' => esc_html($metadata['phone_number'] ?? ''),
			'%%street_address%%' => esc_html($metadata['street_address'] ?? ''),
			'%%locality%%' => esc_html($metadata['address_locality'] ?? ''),
			'%%region%%' => esc_html($metadata['address_region'] ?? ''),
			'%%postal_code%%' => esc_html($metadata['postal_code'] ?? ''),
			'%%country_name%%' => esc_html($metadata['address_country'] ?? ''),
			'%%country_code%%' => esc_html($metadata['address_country_code'] ?? ''),
			'%%currentyear%%' => date('Y')
			/*'%%parent_title%%' => get_the_title($post->post_parent)*/
        ];
		
		// ACF and Meta Box field replacements
		if (isset($metadata['object_id']) && !empty($metadata['object_id'])) {
			$object_id = $metadata['object_id'];

			// Handle ACF fields if ACF is active
			if (function_exists('get_fields')) {
				$acf_fields = get_fields($object_id);
				if ($acf_fields) foreach ($acf_fields as $key => $value) $replacements['%%' . $key . '%%'] = $value;
			}

			// Handle Meta Box fields if Meta Box is active
			if (function_exists('rwmb_meta')) {
				$meta_box_fields = get_post_meta($object_id);
				foreach ($meta_box_fields as $key => $values) if (is_array($values) && count($values) === 1) $replacements['%%' . $key . '%%'] = $values[0];
			}
		}
		
		$iterations = 0;
		while (strpos($text, '%%') !== false && $iterations < 2) {
			foreach ($replacements as $variable => $replacement) {
				if (is_array($replacement)) {
					$replacement = array_map(function ($item) {
						if (is_object($item) && method_exists($item, '__toString')) {
							return $item->__toString();
						}
						elseif (is_object($item)) {
							return json_encode($item);
						}
						return (string) $item;
					}, $replacement);
					$replacement = implode(', ', $replacement);
				}
				elseif (is_object($replacement)) {
					if (method_exists($replacement, '__toString')) {
						$replacement = $replacement->__toString();
					}
					else {
						$replacement = json_encode($replacement);
					}
				}
				$text = str_replace($variable, (string) $replacement, $text);
			}
			$iterations++;
		}		
		return $text;
	}
}