<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Images {
	
	public static function init() {
        return new self();
    }
	
	public function __construct() {
        add_action('add_attachment', [$this, 'auto_alt_text_on_upload']);
	}

	public function auto_alt_text_on_upload($post_id) {
		if (!wp_attachment_is_image($post_id)) return;
		$attachment = get_post($post_id);
		$image_title = preg_replace('%\s*[-_\s]+\s*%', ' ', $attachment->post_title);
		$image_alt_text = ucwords(mb_strtolower(trim($image_title)));
		update_post_meta($post_id, '_wp_attachment_image_alt', $image_alt_text);
	}
}