<?php
defined('ABSPATH') or exit;

class Zynith_SEO_DB_Handler {
    private $wpdb;

    public function __construct() {
        global $wpdb;
        $this->wpdb = $wpdb;
    }

	public function handleDatabaseOperations() {
		$this->delete_table('redirects');
		$this->create_404_log_table();
		$this->create_snippets_table();
    }
	
	private function table_exists($table_name) {
        return $this->wpdb->get_var("SHOW TABLES LIKE '{$table_name}'") === $table_name;
    }
	
	private function create_table($table_name, $sql) {
		if (!$this->table_exists($table_name)) {
			require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
			dbDelta($sql);
			if (!$this->table_exists($table_name)) {
				$error = $this->wpdb->last_error;
				error_log("Failed to create table: {$table_name}, Error: {$error}");
			}
		}
	}
	
	private function delete_table($table_suffix) {
		$table_name = $this->wpdb->prefix . ZYNITH_SEO_TEXT_PREFIX . $table_suffix;
        if ($this->table_exists($table_name)) $this->wpdb->query("DROP TABLE IF EXISTS {$table_name}");
    }

	private function create_404_log_table() {
        $table_name = $this->wpdb->prefix . ZYNITH_SEO_TEXT_PREFIX . '404_log';
		$sql = "CREATE TABLE {$table_name} (
                	id mediumint(9) NOT NULL AUTO_INCREMENT,
                	url varchar(255) NOT NULL,
                	user_agent varchar(255) NOT NULL,
                	timestamp timestamp DEFAULT CURRENT_TIMESTAMP NOT NULL,
                	PRIMARY KEY  (id)
            	) {$this->wpdb->get_charset_collate()};";
		$this->create_table($table_name, $sql);
    }
	
	private function create_snippets_table() {
		$table_name = $this->wpdb->prefix . ZYNITH_SEO_TEXT_PREFIX . 'snippets';
		$sql = "CREATE TABLE {$table_name} (
                	id mediumint(9) NOT NULL AUTO_INCREMENT,
                	name tinytext NOT NULL,
					pages_posts text NOT NULL,
					placement varchar(100) NOT NULL,
					enabled tinyint(1) NOT NULL DEFAULT '0',
					code text NOT NULL,
					added datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
                	PRIMARY KEY  (id)
            	) {$this->wpdb->get_charset_collate()};";
		$this->create_table($table_name, $sql);
		if ($this->table_exists($table_name)) {
			$this->migrate_script($table_name, 'gtm_header_script', 'Zynith Head', 'head');
			$this->migrate_script($table_name, 'gtm_body_script', 'Zynith Body', 'body');
		}
	}
	
	private function migrate_script($table_name, $option_name, $script_name, $placement) {
		$script = get_option(ZYNITH_SEO_TEXT_PREFIX . $option_name);
		if ($script) {
			$data = [
				'name' => $script_name,
				'pages_posts' => '',
				'placement' => $placement,
				'enabled' => 1,
				'code' => $script
			];
			$formats = ['%s', '%s', '%s', '%d', '%s'];
			if (!$this->wpdb->insert($table_name, $data, $formats)) error_log("Failed to insert {$script_name} script into {$table_name}");
		}
	}
}