<?php
if (!defined('ABSPATH')) exit;

class Zynith_SEO_Category_Base {

	public static function init() {
        return new self();
    }
	
    public function __construct() {
        $remove_category_base = get_option('zynith_remove_category_base', false);
        if (!$remove_category_base) return;
        add_action('created_category', 'flush_rewrite_rules');
        add_action('delete_category', 'flush_rewrite_rules');
        add_action('edited_category', 'flush_rewrite_rules');
        add_action('init', [$this, 'permastruct']);
        add_filter('category_rewrite_rules', [$this, 'rewrite_rules']);
        add_filter('query_vars', [$this, 'query_vars']);
        add_filter('request', [$this, 'request']);
    }

    public function permastruct() {
        global $wp_rewrite;
        $wp_rewrite->extra_permastructs['category']['struct'] = '%category%';
    }

    public function rewrite_rules($category_rewrite) {
        global $wp_rewrite;
        $category_rewrite = [];
        if (class_exists('Sitepress')) {
            global $sitepress;
            remove_filter('terms_clauses', [$sitepress, 'terms_clauses']);
            $categories = get_categories(['hide_empty' => false]);
            add_filter('terms_clauses', [$sitepress, 'terms_clauses'], 10, 4);
        }
		else {
            $categories = get_categories(['hide_empty' => false]);
        }
    
        foreach($categories as $category) {
            $category_nicename = $category->slug;
            if ($category->parent == $category->cat_ID) {
                $category->parent = 0;
            }
			elseif ($category->parent != 0) {
                $category_nicename = get_category_parents($category->parent, false, '/', true) . $category_nicename;
            }
    
            $category_rewrite['('.$category_nicename.')/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$'] = 'index.php?category_name=$matches[1]&feed=$matches[2]';
            $category_rewrite["({$category_nicename})/{$wp_rewrite->pagination_base}/?([0-9]{1,})/?$"] = 'index.php?category_name=$matches[1]&paged=$matches[2]';
            $category_rewrite['('.$category_nicename.')/?$'] = 'index.php?category_name=$matches[1]';
        }
    
        $old_category_base = get_option('category_base') ? get_option('category_base') : 'category';
        $old_category_base = trim($old_category_base, '/');
        $category_rewrite[ $old_category_base.'/(.*)$' ] = 'index.php?category_redirect=$matches[1]';
        return $category_rewrite;
    }

    public function query_vars($public_query_vars) {
        $public_query_vars[] = 'category_redirect';
        return $public_query_vars;
    }

    public function request($query_vars) {
        if (isset($query_vars['category_redirect'])) {
            $catlink = trailingslashit(get_option('home')) . user_trailingslashit($query_vars['category_redirect'], 'category');
            status_header(301);
            header("Location: $catlink");
            exit;
        }
        return $query_vars;
    }
}