<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Breadcrumbs {

    public $post_types;
    public $args;

	public static function init() {
        return new self();
    }
	
    public function __construct() {
        add_action('template_redirect', [$this, 'set_post_types'], 1);
        $this->args = apply_filters('zynith_breadcrumb_args', [
            'wrap_start' => '<div class="breadcrumbs">',
            'wrap_end' => '</div>',
            'separator' => ' <span class="sep">&raquo;</span> ',
        ]);
        add_shortcode('zynith-breadcrumbs', [$this, 'render_breadcrumbs']);
    }  

    public function set_post_types() {
        $this->post_types = array_keys(Zynith_SEO_Post_Types::get_post_types());
    }

    public function render_breadcrumbs() {
        if (is_admin() || is_front_page()) return;
		
		$custom_label = '';
        if (is_404()) {
            $custom_label = __('404 Error - Page not found', ZYNITH_SEO_TEXT_DOMAIN);
        }
		elseif (is_author()) {
            $custom_label = __('Author: ', ZYNITH_SEO_TEXT_DOMAIN) . get_the_author();
        }
		elseif (is_archive()) {
            $custom_label = __('Archive: ', ZYNITH_SEO_TEXT_DOMAIN) . get_the_archive_title();
        }
        
		$schema_array = [
            '@context' => 'https://schema.org',
            '@type' => 'BreadcrumbList',
            'itemListElement' => [
                [
                    '@type' => 'ListItem',
                    'position' => 1,
                    'item' => [
                        '@id' => home_url(),
                        'name' => _x('Home', 'Breadcrumbs Home', ZYNITH_SEO_TEXT_DOMAIN)
                    ]
                ]
            ]
        ];
		
		$breadcrumbs = $this->args['wrap_start'] . '<a href="' . home_url() . '">' . _x('Home', 'Breadcrumbs Home', ZYNITH_SEO_TEXT_DOMAIN) . '</a>' . $this->args['separator'];
        $uri_parts = parse_url(trim(filter_input(INPUT_SERVER, 'REQUEST_URI'), '/'));
        $uri = isset($uri_parts['path']) ? $uri_parts['path'] : '';
        $url = !empty($uri) ? explode('/', $uri) : [];
        if (empty(array_filter($url))) return '';
        
		$breadcrumb_url = home_url('/');
		$item_position = 2;
		$url = array_filter($url);
        
        foreach ($url as $key => $segment) {
            $breadcrumb_url .= $segment . '/';
            $label = mb_convert_case(trim(preg_replace('%\s*[-_\s]+\s*%', ' ', $segment)), MB_CASE_TITLE, "UTF-8");
            if ($key === count($url) - 1) {
                if (!empty($custom_label)) $label = $custom_label;
                $breadcrumbs .= '<span class="current">' . $label . '</span>';
            }
			else {
                $breadcrumbs .= '<a href="' . esc_url($breadcrumb_url) . '">' . $label . '</a>' . $this->args['separator'];
            }
            $schema_array['itemListElement'][] = [
                '@type' => 'ListItem',
                'position' => $item_position,
                'item' => [
                    '@id' => esc_url($breadcrumb_url),
                    'name' => $label,
                ],
            ];
            $item_position++;
        }
        $breadcrumbs .= $this->args['wrap_end'];
        
		$add_schema = (bool)get_option('zynith_add_breadcrumbs_schema', false);
		if ($add_schema) $breadcrumbs .= '<script type="application/ld+json">' . json_encode($schema_array, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) . '</script>';
		
		return $breadcrumbs;
    }
}