<?php
defined('ABSPATH') or exit;

class Zynith_SEO_Authors {
	
	public static function init() {
        return new self();
    }
	
	public function __construct() {
        add_action('show_user_profile', [$this, 'zynith_seo_metabox']);
        add_action('edit_user_profile', [$this, 'zynith_seo_metabox']);
        add_action('profile_update', [$this, 'save_metabox']);
	}

	public function zynith_seo_metabox($user) {
        if (empty($user->ID)) return;
		wp_nonce_field('seo_metabox_nonce_action', 'seo_metabox_nonce');
		echo '<div id="zynith_seo_metabox" class="postbox">
				<div class="postbox-header">
					<h2 class="hndle ui-sortable-handle">' . __('Zynith SEO', ZYNITH_SEO_TEXT_DOMAIN) . '</h2>
				</div>
            <div class="inside">' . Zynith_SEO_Meta_Boxes::get_zynith_seo_metabox($user, 'author') . '</div>
        </div>';
    }
    
    public function save_metabox($user_id) {
        if (!isset($_POST['seo_metabox_nonce']) || !wp_verify_nonce($_POST['seo_metabox_nonce'], 'seo_metabox_nonce_action')) return;
        if (! isset($_POST['dynamic_schema_meta_box_nonce']) || ! wp_verify_nonce($_POST['dynamic_schema_meta_box_nonce'], 'dynamic_schema_save_postdata')) return;
        $meta_title = sanitize_text_field($_POST['custom_meta_title']);
        $meta_description = sanitize_textarea_field($_POST['custom_meta_description']);
        $noindex = isset($_POST['custom_noindex']) && $_POST['custom_noindex'] == 'on' ? 'yes' : 'no';
        $nofollow = isset($_POST['custom_nofollow']) && $_POST['custom_nofollow'] == 'on' ? 'yes' : 'no';
        $schema = sanitize_textarea_field($_POST['custom_schema']);
        $target_keyword = sanitize_text_field($_POST['custom_target_keyword']);
        $meta_og_image = sanitize_text_field($_POST['custom_meta_og_image']);
        update_user_meta($user_id, '_custom_meta_title', $meta_title);
        update_user_meta($user_id, '_custom_meta_description', $meta_description);
        update_user_meta($user_id, '_custom_noindex', $noindex);
        update_user_meta($user_id, '_custom_nofollow', $nofollow);
        update_user_meta($user_id, '_custom_schema', $schema);
        update_user_meta($user_id, '_custom_target_keyword', $target_keyword);
        update_user_meta($user_id, '_custom_meta_og_image', $meta_og_image);
    }	
}