function calculateKeywordDensity(content, keyword) {
	keyword = keyword.toLowerCase().trim();
	content = content.toLowerCase().replace(/<\/?[^>]+(>|$)/g, "");
	const wordCount = content.split(/\s+/).length;
	const keywordCount = content.split(keyword).length - 1;
	if (wordCount === 0) return 0;
	const density = (keywordCount / wordCount) * 100;
	return parseFloat(density.toFixed(2));
}

function updateKeywordDensity() {
	const content = $("#content").val();
    const targetKeyword = $("#custom_target_keyword").val();
    const keywordDensity = calculateKeywordDensity(content, targetKeyword);
    $("#p_density").text("Keyword Density: " + keywordDensity + "%");
}

document.addEventListener("DOMContentLoaded", function() {
	let isEditPage = document.getElementById('zynith_seo_metabox');
	if (isEditPage) {
		let tabContents = document.querySelectorAll('.tab-content');
		let navTabs = document.querySelectorAll('.nav-tab');
		let googlePreview = document.getElementsByClassName('zynith-seo-preview-container')[0];
		let titleInput = document.getElementById("custom_meta_title") ? document.getElementById("custom_meta_title") : false;
		let descriptionInput = document.getElementById("custom_meta_description") ? document.getElementById("custom_meta_description") : false;
		let metadata = [
			{variable: '%%title%%', value: document.getElementById("metadata_title") ? document.getElementById("metadata_title").value : ""},
			{variable: '%%sitetitle%%', value: document.getElementById("metadata_sitetitle") ? document.getElementById("metadata_sitetitle").value : ""},
			{variable: '%%tagline%%', value: document.getElementById("metadata_tagline") ? document.getElementById("metadata_tagline").value : ""},
			{variable: '%%currentyear%%', value: document.getElementById("metadata_currentyear") ? document.getElementById("metadata_currentyear").value : ""},
			{variable: '%%target_keyword%%', value: document.getElementById("metadata_target_keyword") ? document.getElementById("metadata_target_keyword").value : ""},
			{variable: '%%business_name%%', value: document.getElementById("metadata_business_name") ? document.getElementById("metadata_business_name").value : ""},
			{variable: '%%business_phone%%', value: document.getElementById("metadata_business_phone") ? document.getElementById("metadata_business_phone").value : ""},
			{variable: '%%country_name%%', value: document.getElementById("metadata_country_name") ? document.getElementById("metadata_country_name").value : ""},
			{variable: '%%post_excerpt%%', value: document.getElementById("metadata_post_excerpt") ? document.getElementById("metadata_post_excerpt").value : ""}
		];
		let contentElement = document.getElementById('content');
		let keywordInput = document.getElementById('custom_target_keyword');
		let metadataKeyword = document.getElementById('metadata_target_keyword');
		
		function toggleGooglePreview() {
			if ((titleInput && titleInput.value.trim() === '') && (descriptionInput && descriptionInput.value.trim() === '')) {
				googlePreview.style.display = 'none';
			}
			else {
				googlePreview.style.display = 'block';
			}
		}
		function updateSERPPreview() {
			let titleValue = titleInput.value.trim();
			let post_title = document.getElementById("metadata_title").value;
			let site_title = document.getElementById("metadata_sitetitle").value;
			let descriptionValue = descriptionInput.value.trim();
			let serp_title = document.getElementById("serp-title");
			let serp_desc = document.getElementById("serp-desc");
			metadata.forEach(function(item) {
				titleValue = titleValue.replace(new RegExp(item.variable, 'g'), item.value);
				descriptionValue = descriptionValue.replace(new RegExp(item.variable, 'g'), item.value);
			});
			let finalTitle = post_title.trim() ? post_title + ' | ' + site_title : "Title will appear here";
			serp_title.textContent = titleValue.length > 0 ? titleValue : finalTitle;
			serp_desc.textContent = descriptionValue.length > 0 ? descriptionValue : "Page description will appear here";
		}
		updateSERPPreview();
		toggleGooglePreview();
		if (titleInput) {
			titleInput.addEventListener("input", function() {
				updateSERPPreview();
				document.getElementById("custom_meta_title_updated").value = this.value.length == 0 ? '' : '1';
				if (this.value == document.getElementById('metadata_title') && this.value.length > 0) {
					this.classList.add('default');
				}
				else {
					this.classList.remove('default');
				}
				toggleGooglePreview();
			});
		}
		if (descriptionInput) {
			descriptionInput.addEventListener("input", function() {
				updateSERPPreview();
				document.getElementById("custom_meta_description_updated").value = this.value.length == 0 ? '' : '1';

				if (this.value == document.getElementById('metadata_post_excerpt') && this.value.length > 0) {
					this.classList.add('default');
				}
				else {
					this.classList.remove('default');
				}
				toggleGooglePreview();
			});	
		}
		
		tabContents.forEach(function(content) {
			content.style.display = 'none';
		});
		if (tabContents.length > 0) tabContents[0].style.display = 'block';
		navTabs.forEach(function(tab) {
			tab.addEventListener('click', function(e) {
				e.preventDefault();

				navTabs.forEach(function(innerTab) {
					innerTab.classList.remove('nav-tab-active');
				});

				this.classList.add('nav-tab-active');

				tabContents.forEach(function(content) {
					content.style.display = 'none';
				});

				let activeTab = this.getAttribute('href');
				let currentTabContent = document.querySelector(activeTab);
				if (currentTabContent) currentTabContent.style.display = 'block';
			});
		});		
		
		let lastFocusedElement = null;
		document.querySelectorAll('input[type="text"], textarea').forEach(element => {
			element.addEventListener('focus', function() {
				lastFocusedElement = this;
			});
		});
		document.querySelectorAll('.insert-placeholder').forEach(button => {
			button.addEventListener('click', function() {
				if (lastFocusedElement && ['INPUT', 'TEXTAREA'].includes(lastFocusedElement.tagName)) {
					let placeholder = this.getAttribute('data-z-var');
					let startPos = lastFocusedElement.selectionStart;
					let endPos = lastFocusedElement.selectionEnd;
					lastFocusedElement.value = lastFocusedElement.value.substring(0, startPos) + placeholder + lastFocusedElement.value.substring(endPos);
					lastFocusedElement.selectionStart = lastFocusedElement.selectionEnd = startPos + placeholder.length;
					lastFocusedElement.focus();
					let event = new Event('input', {
						bubbles: true,
						cancelable: true,
					});
					lastFocusedElement.dispatchEvent(event);
				}
			});
		});
		
		let customUploader;
		const ogImageButton = document.getElementById('custom_meta_og_image_button');
		if (ogImageButton) {
			ogImageButton.addEventListener('click', function (e) {
				e.preventDefault();
				if (customUploader) {
					customUploader.open();
					return;
				}
				customUploader = wp.media({
					title: custom_image.og_title,
					button: {
						text: custom_image.og_button
					},
					multiple: false
				});
				customUploader.on('select', function () {
					const attachment = customUploader.state().get('selection').first().toJSON();
					document.getElementById('custom_meta_og_image').value = attachment.url;
				});
				customUploader.open();
			});
		}
		
		if (contentElement) {
			contentElement.addEventListener('input', function() {
				updateKeywordDensity();
				if (metadataKeyword) metadataKeyword.value = keywordInput.value;
			});
		}
		if (keywordInput) {
			keywordInput.addEventListener('input', function() {
				updateKeywordDensity();
				if (metadataKeyword) metadataKeyword.value = this.value;
			});
		}
	}
});