function restore_toc_css() {
	const cssCode = `details.zynith-toc > * {
	transition: max-height 0.5s ease-in-out;
    overflow: auto;
}
details.zynith-toc[open] > * { max-height: 500px; }
details.zynith-toc:not([open]) > * { max-height: 44px; }
details.zynith-toc {
	max-width: 100%;
	width: fit-content;
	border: 1px solid gray;
    padding: 20px;
}
details.zynith-toc > summary {
	font-size: 1.3em;
	cursor: pointer;
}
.zynith-toc ul {
	margin: 0;
	padding: 0;
	list-style-type: none;
}
.zynith-toc li { margin-bottom: 0; }
.zynith-toc .toc-h1 { padding: 6px 0 0 6px; font-size: 110%; }
.zynith-toc .toc-h2 { padding: 5px 0 0 22px; }
.zynith-toc .toc-h3 { padding: 4px 0 0 33px; font-size: 90%; }
.zynith-toc .toc-h4 { padding: 3px 0 0 44px; font-size: 90%; }
.zynith-toc .toc-h5 { padding: 2px 0 0 55px; font-size: 80%; }
.zynith-toc .toc-h6 { padding: 1px 0 0 66px; font-size: 80%; }`;
	document.getElementById('zynith_toc_css').value = cssCode;
}

jQuery(document).ready(function ($) {
	let custom_uploader;
	$('.upload-image').on('click', function(e) {
		e.preventDefault();
		let object_id = $( this ).data( 'id' );
		let $input_object = $( '#'+object_id );
		let $remove_button = $( this ).next();
		if (object_id === 'zynith_logo') {
			custom_uploader = wp.media.frames.file_frame = wp.media({
				title: custom_image.logo_title,
				button: {
					text: custom_image.logo_button
				},
				multiple: false
			});
		}
		else if (object_id === 'zynith_default_og_image') {
			custom_uploader = wp.media.frames.file_frame = wp.media( {
				title: custom_image.og_title,
				button: {
					text: custom_image.og_button
				},
				multiple: false
			});
		}
		
		custom_uploader.on('select', function() {
			attachment = custom_uploader.state().get('selection').first().toJSON();
			let image_url = attachment.url;
			if (attachment.sizes.medium !== undefined) image_url = attachment.sizes.medium.url;
			$input_object.val(attachment.id);
			$('#'+object_id+'-preview .image').html('<img src="'+image_url+'" alt="">');
			$remove_button.show(0);
		});
		custom_uploader.open();
	});
	$('.remove-image').on('click', function(e) {
		let object_id = $(this).data('id');
		let $input_object = $('#'+object_id);
		$input_object.val('');
		$('#'+object_id+'-preview .image').html('');
		$(this).hide(0);
	});	
	$('.sortable').click(function () {
		let table = $(this).closest('table');
		let rows = table.find('tbody tr').get();
		let index = $(this).index();
		let order = 'asc';

		if ($(this).hasClass('sorted-asc')) order = 'desc';

		table.find('th').removeClass('sorted-asc sorted-desc');

		$(this).removeClass('sorted-asc sorted-desc').addClass('sorted-' + order);

		rows.sort(function (a, b) {
			let A = $(a).children('td').eq(index).text().toUpperCase();
			let B = $(b).children('td').eq(index).text().toUpperCase();
			if (A < B) return (order === 'asc') ? -1 : 1;
			if (A > B) return (order === 'desc') ? 1 : -1;
			return 0;
		});

		if ($(this).hasClass('sorted-desc')) rows.reverse();

		$.each(rows, function (index, row) {
			table.children('tbody').append(row);
		});
	});
	$('#select-all').on('change', function() {
		$('.log-checkbox').prop('checked', $(this).prop('checked'));
		if ($(this).prop('checked')) {
			$('.log-checkbox').closest('tr').addClass('selected');
		}
		else {
			$('.log-checkbox').closest('tr').removeClass('selected');
		}
	});
	$('.log-checkbox').on('change', function() {
		let allChecked = $('.log-checkbox:checked').length === $('.log-checkbox').length;
		$('#select-all').prop('checked', allChecked);
		if ($(this).prop('checked')) {
			$(this).closest('tr').addClass('selected');
		}
		else {
			$(this).closest('tr').removeClass('selected');
		}
	});
	$('#zynith-table-404 tbody tr').on('click', function(e) {
		if (e.target.type !== 'checkbox') {
			let checkbox = $(this).find('.log-checkbox');
			checkbox.prop('checked', !checkbox.prop('checked')).change();
			if (checkbox.prop('checked')) {
				$(this).addClass('selected');
			}
			else {
				$(this).removeClass('selected');
			}
		}
	});
});