<?php
function nasa_sc_product_deal($atts, $content = null) {
    global $woocommerce, $nasa_opt;
    
    if (!$woocommerce) {
        return $content;
    }
    
    $dfAttr = array(
        'id' => '',
        'title' => 'Deal for',
        'btn_shop_now' => 'yes',
        'btn_text' => 'SHOP NOW',
        'btn_url' => '',
        'el_class' => ''
    );
    extract(shortcode_atts($dfAttr, $atts));
    
    if(!(int) $id) {
        return '';
    }
    
    $_id = rand();
    $product = nasa_getProductDeals($id);

    ob_start();
    if ($product && $product->is_visible()) :
        $id_post = $product->get_type() == 'variation' ? wp_get_post_parent_id($id) : $id;
        $product_error = $id_post ? false : true;
        
        $product_name = $product->get_title() . ($product_error ? esc_html__(' - Has been error. You need rebuilt this product.', 'nasa-core') : '');
        $link = $product_error ? '#' : get_the_permalink($id);
        
        $stock_sold = ($total_sales = get_post_meta($id, 'total_sales', true)) ? round($total_sales) : 0;
        $stock_available = ($stock = get_post_meta($id, '_stock', true)) ? round($stock) : 0;
        $percentage = $stock_available > 0 ? round($stock_sold/($stock_available + $stock_sold) * 100) : 0;
        
        if($btn_shop_now == 'yes') :
            if($btn_url == ''):
                $shop_page_id = get_option('woocommerce_shop_page_id', 0);

                // If permalinks contain the shop page in the URI prepend the breadcrumb with shop
                if ($shop_page_id && get_option('page_on_front') !== $shop_page_id) {
                    $btn_url = get_permalink($shop_page_id);
                }
            endif; 
        else:
            $btn_url = '';
        endif;
        
        ?>
        <div class="woocommerce nasa-product-deal<?php echo ' nasa-product-deal-' . $_id . ($el_class != '' ? ' ' . $el_class : ''); ?>">
            <div class="inner-content">
                <?php
                if(is_file(NASA_CORE_PRODUCT_LAYOUTS . 'nasa_products_deal/single_product_deal.php')) :
                    include NASA_CORE_PRODUCT_LAYOUTS . 'nasa_products_deal/single_product_deal.php';
                endif;
                ?>
            </div>
        </div>
    <?php
    endif;
    wp_reset_postdata();
    $content = ob_get_clean();

    return $content;
}

// **********************************************************************// 
// ! Register New Element: Nasa product Deal
// **********************************************************************//
function nasa_register_product_deals(){
    vc_map(array(
        "name" => esc_html__("Product Deal Schedule", 'nasa-core'),
        "base" => "nasa_product_deal",
        'icon' => 'icon-wpb-nasatheme',
        'description' => esc_html__("Only show one product deal.", 'nasa-core'),
        "class" => "",
        "category" => 'Nasa Core',
        "params" => array(
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Select a product deal", 'nasa-core'),
                "param_name" => "id",
                "value" => nasa_getListProductDeals(),
                "admin_label" => true
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Title", 'nasa-core'),
                "param_name" => "title",
                "value" => 'Deal for',
                "admin_label" => true
            ),
            
            array(
                "type" => "dropdown",
                "heading" => esc_html__("Show button store", 'nasa-core'),
                "param_name" => "btn_shop_now",
                "value" => array(
                    esc_html__('Yes', 'nasa-core') => 'yes',
                    esc_html__('No', 'nasa-core') => 'no'
                ),
                "std" => 'yes',
                "admin_label" => true
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Text button", 'nasa-core'),
                "param_name" => "btn_text",
                "value" => 'SHOP NOW',
                "admin_label" => true
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Url button (default shop page)", 'nasa-core'),
                "param_name" => "btn_url",
                "value" => '',
                "admin_label" => true
            ),
            
            array(
                "type" => "textfield",
                "heading" => esc_html__("Extra class name", 'nasa-core'),
                "param_name" => "el_class",
                "description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'nasa-core')
            )
        )
    ));
}
