<?php
/**
 * Single Product Meta
 *
 * @see 	https://docs.woocommerce.com/document/template-structure/
 * @author 	WooThemes
 * @override 	NasaTheme
 * @package 	WooCommerce/Templates
 * @version     3.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}

global $product;
$sku = $product->get_sku();
?>
<div class="product_meta">

    <?php
    do_action('woocommerce_product_meta_start');
    if (wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type('variable') )) : ?>
        <span class="sku_wrapper">
            <span class="nasa-meta-label"><?php esc_html_e('SKU:', 'zella-theme'); ?></span> <span class="sku"><?php if($sku): echo zella_str($sku); else: echo esc_html__('N/A', 'zella-theme'); endif; ?></span>
        </span>
    <?php
    endif;
    
    echo wc_get_product_category_list($product->get_id(), ', ', '<span class="posted_in"><span class="nasa-meta-label">' . _n('Category:', 'Categories:', count($product->get_category_ids()), 'zella-theme') . '</span> ', '</span>');
    echo wc_get_product_tag_list($product->get_id(), ', ', '<span class="tagged_as"><span class="nasa-meta-label">' . _n('Tag:', 'Tags:', count($product->get_tag_ids()), 'zella-theme') . '</span> ', '</span>');
    
    do_action('woocommerce_product_meta_end');
    ?>

</div>
