<?php
/**
 * Order Customer Details
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.4
 */
if (!defined('ABSPATH')) {
    exit;
}
return;
$show_shipping = !wc_ship_to_billing_address_only() && $order->needs_shipping_address();
?>
<section class="woocommerce-customer-details">

    <?php if ($show_shipping) : ?>

        <section class="woocommerce-columns woocommerce-columns--2 woocommerce-columns--addresses col2-set addresses">
            <div class="woocommerce-column woocommerce-column--1 woocommerce-column--billing-address col-1">

            <?php endif; ?>

            <h2 class="woocommerce-column__title"><?php esc_html_e('Billing address', 'zella-theme'); ?></h2>

            <address>
                <?php echo wp_kses_post($order->get_formatted_billing_address(esc_html__('N/A', 'zella-theme'))); ?>

                <?php if ($order->get_billing_phone()) : ?>
                    <p class="woocommerce-customer-details--phone"><?php echo esc_html($order->get_billing_phone()); ?></p>
                <?php endif; ?>

                <?php if ($order->get_billing_email()) : ?>
                    <p class="woocommerce-customer-details--email"><?php echo esc_html($order->get_billing_email()); ?></p>
                <?php endif; ?>
            </address>

            <?php if ($show_shipping) : ?>

            </div><!-- /.col-1 -->

            <div class="woocommerce-column woocommerce-column--2 woocommerce-column--shipping-address col-2">
                <h2 class="woocommerce-column__title"><?php esc_html_e('Shipping address', 'zella-theme'); ?></h2>
                <address>
                    <?php echo wp_kses_post($order->get_formatted_shipping_address(esc_html__('N/A', 'zella-theme'))); ?>
                </address>
            </div><!-- /.col-2 -->

        </section><!-- /.col2-set -->

    <?php endif; ?>

    <?php do_action('woocommerce_order_details_after_customer_details', $order); ?>

</section>
