<?php

/**
 * Shop breadcrumb
 *
 * @author 	WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.3.0
 */
if (!defined('ABSPATH')) :
    exit; // Exit if accessed directly
endif;

// var_dump($breadcrumb);
if (!empty($breadcrumb)) {
    global $post, $nasa_opt, $wp_query;
    $queried_object = $wp_query->get_queried_object();
    
    /**
     * Single Portfolio
     */
    if (is_singular('portfolio')) {
        $breadcrumb = zella_rebuilt_breadcrumb_portfolio($breadcrumb);
    }
    
    /**
     * Archive Portfolio
     */
    elseif(isset($queried_object->taxonomy) && $queried_object->taxonomy == 'portfolio_category') {
        $breadcrumb = zella_rebuilt_breadcrumb_portfolio($breadcrumb, false);
    }
    
    echo $wrap_before;
    
    $key = 0;
    $sizeof = sizeof($breadcrumb);
    foreach ($breadcrumb as $crumb) {
        echo $before;
        echo (!empty($crumb[1]) && $sizeof !== $key + 1) ?
            '<a href="' . esc_url($crumb[1]) . '" title="' . esc_attr($crumb[0]) . '">' .
                esc_html($crumb[0]) .
            '</a>' :
            esc_html($crumb[0]);
        
        echo $after;
        echo ($sizeof !== $key + 1) ? $delimiter : '';
        
        $key++;
    }

    echo $wrap_after;
}
