<?php
/**
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     3.4.0
 */
if (!defined('ABSPATH')){
    exit; // Exit if accessed directly
}
global $nasa_opt, $wp_query;

$typeView = !isset($nasa_opt['products_type_view']) ?
    'grid' : ($nasa_opt['products_type_view'] == 'list' ? 'list' : 'grid');

$nasa_opt['products_per_row'] = isset($nasa_opt['products_per_row']) && (int) $nasa_opt['products_per_row'] ?
    (int) $nasa_opt['products_per_row'] : 5;
$nasa_opt['products_per_row'] = $nasa_opt['products_per_row'] > 5 || $nasa_opt['products_per_row'] < 3 ? 5 : $nasa_opt['products_per_row'];
$nasa_change_view = !isset($nasa_opt['enable_change_view']) || $nasa_opt['enable_change_view'] ? true : false;
$typeShow = $typeView == 'grid' ? ($typeView . '-' . ((int) $nasa_opt['products_per_row'])) : 'list';
$typeShow = $nasa_change_view && isset($_COOKIE['gridcookie']) ? $_COOKIE['gridcookie'] : $typeShow;

$nasa_cat_obj = $wp_query->get_queried_object();
$nasa_term_id = 0;
$nasa_type_page = 'product_cat';

$shop_page_id = get_option('woocommerce_shop_page_id', 0);
$nasa_href_page = $shop_page_id ? get_permalink($shop_page_id) : home_url('/');

if (isset($nasa_cat_obj->term_id) && isset($nasa_cat_obj->taxonomy)) {
    $nasa_term_id = (int) $nasa_cat_obj->term_id;
    $nasa_type_page = $nasa_cat_obj->taxonomy;
    $nasa_href_page = esc_url(get_term_link($nasa_cat_obj, $nasa_type_page));
}

$nasa_description = zella_term_description($nasa_term_id, $nasa_type_page);
$nasa_sidebar = isset($nasa_opt['category_sidebar']) ? $nasa_opt['category_sidebar'] : 'left-classic';
$nasa_has_get_sidebar = false;

if (isset($_GET['sidebar'])):
    $nasa_has_get_sidebar = true;
    switch ($_GET['sidebar']) :
        case 'left' :
            $nasa_sidebar = 'left';
            break;
        
        case 'right' :
            $nasa_sidebar = 'right';
            break;
        
        case 'right-classic' :
            $nasa_sidebar = 'right-classic';
            break;
        
        case 'left-classic' :
            $nasa_sidebar = 'left-classic';
            break;
        
        case 'top-1' :
            $nasa_sidebar = 'top-1';
            break;
        
        case 'top-2' :
            $nasa_sidebar = 'top-2';
            break;
        
        case 'no' :
        default:
            $nasa_sidebar = 'no';
            
            break;
    endswitch;
endif;

$hasSidebar = is_active_sidebar('shop-sidebar');
$topSidebar = false;
$attr = 'nasa-products-page-wrap ';
switch ($nasa_sidebar):
    case 'right':
    case 'left':
        $attr .= 'large-12 columns has-sidebar';
        break;
    
    case 'right-classic':
        $attr .= 'large-9 columns left has-sidebar';
        break;
    
    case 'left-classic':
        $attr .= 'large-9 columns right has-sidebar';
        break;
    
    case 'top-1':
    case 'top-2':
        $topSidebar = true;
        $attr .= 'large-12 columns no-sidebar top-sidebar';
        break;
    
    case 'no':
    default :
        $hasSidebar = false;
        $attr .= 'large-12 columns no-sidebar';
        break;
endswitch;

$nasa_recom_pos = isset($nasa_opt['recommend_product_position']) ? $nasa_opt['recommend_product_position'] : 'bot';

$layout_style = '';
if(isset($nasa_opt['products_layout_style']) && $nasa_opt['products_layout_style'] == 'masonry-isotope') :
    $layout_style = ' nasa-products-masonry-isotope';
endif;

get_header('shop');

$classCategoryPage = 'fullwidth category-page';
if($nasa_sidebar == 'top-1') :
    echo '<div class="nasa-topbar-wrap-content-default"></div>';
    $classCategoryPage .= ' nasa-with-topbar-type-1';
endif;
?>

<div class="<?php echo esc_attr($classCategoryPage); ?>">
    <?php do_action('woocommerce_before_main_content'); ?>
    
    <div class="row">
        <div class="large-12 columns nasa-with-topbar-type-2">
            <div class="row filters-container nasa-filter-wrap">
                <?php if($topSidebar) : ?>
                    <?php
                        $topSidebar_wrap = $nasa_change_view ? 'large-10 ' : 'large-12 ';
                        
                        if(!isset($nasa_opt['showing_info_top']) || $nasa_opt['showing_info_top']) :
                            echo '<div class="showing_info_top hidden-tag">';
                            do_action('nasa_shop_category_count');
                            echo '</div>';
                        endif;
                    ?>

                    <div class="<?php echo esc_attr($topSidebar_wrap); ?>columns nasa-topbar-filter-wrap">
                        <div class="row">
                            <div class="large-10 medium-10 small-8 columns nasa-filter-action">
                                <div class="nasa-labels-filter-top">
                                    <input name="nasa-labels-filter-text" type="hidden" value="<?php echo (!isset($nasa_opt['top_bar_archive_label']) || $nasa_opt['top_bar_archive_label'] == 'Filter by:') ? esc_attr__('Filter by:', 'zella-theme') : esc_attr($nasa_opt['top_bar_archive_label']); ?>" />
                                    <input name="nasa-widget-show-more-text" type="hidden" value="<?php echo esc_attr__('More +', 'zella-theme'); ?>" />
                                    <input name="nasa-widget-show-less-text" type="hidden" value="<?php echo esc_attr__('Less -', 'zella-theme'); ?>" />
                                    <input name="nasa-limit-widgets-show-more" type="hidden" value="<?php echo (!isset($nasa_opt['limit_widgets_show_more']) || (int) $nasa_opt['limit_widgets_show_more'] < 0) ? '2' : (int) $nasa_opt['limit_widgets_show_more']; ?>" />
                                    <input name="nasa-empty-attr-label" type="hidden" value="<?php echo esc_attr__('Any', 'zella-theme'); ?>" />
                                    <input name="nasa-reset-text-top" type="hidden" value="<?php echo esc_attr__('Reset', 'zella-theme'); ?>" />
                                    <span class="nasa-labels-filter-accordion hidden-tag"></span>
                                </div>
                            </div>

                            <div class="large-2 medium-2 small-4 columns nasa-sort-by-action">
                                <ul class="sort-bar nasa-float-none margin-top-0">
                                    <?php if(have_posts()) : ?>
                                        <li class="sort-bar-text nasa-order-label hidden-tag"><?php esc_html_e('Sort by', 'zella-theme'); ?></li>
                                    <?php endif; ?>
                                    <li class="nasa-filter-order filter-order"><?php do_action('woocommerce_before_shop_loop'); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <?php if($nasa_change_view) : ?>
                        <div class="large-2 columns nasa-topbar-change-view-wrap">
                            <?php /* Change view ICONS */
                            do_action('nasa_change_view', $nasa_change_view, $typeShow); ?>
                        </div>
                    <?php endif; ?>

                    <?php /* Sidebar TOP */
                    do_action('nasa_top_sidebar_shop', $nasa_sidebar);

                /*
                 * TOGGLE Sidebar in side
                 */
                elseif ($hasSidebar && in_array($nasa_sidebar, array('left', 'right'))) : ?>
                    <div class="large-4 medium-4 small-6 columns nasa-toggle-layout-side-sidebar">
                        <div class="li-toggle-sidebar">
                            <a class="toggle-sidebar-shop" href="javascript:void(0);">
                                <i class="nasa-icon pe-7s-filter"></i> <?php esc_html_e('Filters', 'zella-theme'); ?>
                            </a>
                        </div>
                    </div>

                    <div class="large-4 medium-4 columns hide-for-small nasa-change-view-layout-side-sidebar">
                        <?php /* Change view ICONS */
                        do_action('nasa_change_view', $nasa_change_view, $typeShow); ?>
                    </div>

                    <div class="large-4 medium-4 small-6 nasa-clear-none columns nasa-sort-bar-layout-side-sidebar">
                        <ul class="sort-bar">
                            <li class="sort-bar-text nasa-order-label hidden-tag">
                                <?php esc_html_e('Sort by: ', 'zella-theme'); ?>
                            </li>
                            <li class="nasa-filter-order filter-order">
                                <?php do_action('woocommerce_before_shop_loop'); ?>
                            </li>
                        </ul>
                    </div>
                <?php

                // No | left-classic | right-classic side bar
                else : ?>
                    <div class="large-4 columns hide-for-small">
                        <?php
                        if(!isset($nasa_opt['showing_info_top']) || $nasa_opt['showing_info_top']) :
                            echo '<div class="showing_info_top">';
                            do_action('nasa_shop_category_count');
                            echo '</div>';
                        else :
                            echo '&nbsp;';
                        endif;
                        ?>
                    </div>
                    <div class="large-4 columns hide-for-small nasa-change-view-layout-side-sidebar">
                        <?php /* Change view ICONS */
                        do_action('nasa_change_view', $nasa_change_view, $typeShow);
                        ?>
                    </div>

                    <div class="large-4 medium-12 small-12 columns nasa-sort-bar-layout-side-sidebar">
                        <ul class="sort-bar">
                            <?php if ($hasSidebar): ?>
                                <li class="li-toggle-sidebar">
                                    <a class="toggle-sidebar" href="javascript:void(0);">
                                        <i class="nasa-icon pe-7s-filter"></i> <?php esc_html_e('Filters', 'zella-theme'); ?>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <li class="sort-bar-text nasa-order-label hidden-tag">
                                <?php esc_html_e('Sort by: ', 'zella-theme'); ?>
                            </li>
                            <li class="nasa-filter-order filter-order">
                                <?php do_action('woocommerce_before_shop_loop'); ?>
                            </li>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="large-12 columns nasa-padding-content-wrap">
            <div class="row nasa-archive-product-content">
                <?php if($topSidebar && (!isset($nasa_opt['top_bar_cat_pos']) || $nasa_opt['top_bar_cat_pos'] == 'left-bar')) :
                    $attr .= ' nasa-has-push-cat';
                    $class_cat_top = 'nasa-push-cat-filter';
                    if(isset($_REQUEST['push_cat_filter']) && $_REQUEST['push_cat_filter']) :
                        $class_cat_top .= ' nasa-push-cat-show';
                        $attr .= ' nasa-push-cat-show';
                    endif;
                    ?>
                    <div class="<?php echo esc_attr($class_cat_top); ?>"></div>
                <?php endif; ?>
                <div class="<?php echo esc_attr($attr); ?>">

                    <?php if(!isset($nasa_opt['disable_ajax_product_progress_bar']) || $nasa_opt['disable_ajax_product_progress_bar'] != 1) : ?>
                        <div class="nasa-progress-bar-load-shop"><div class="nasa-progress-per"></div></div>
                    <?php endif; ?>

                    <?php if($nasa_recom_pos !== 'bot' && defined('NASA_CORE_ACTIVED') && NASA_CORE_ACTIVED) : ?>
                        <span id="position-nasa-recommend-product" class="hidden-tag"></span>
                        <?php do_action('nasa_recommend_product', $nasa_term_id); ?>
                    <?php endif; ?>

                    <span id="position-nasa-cat-header margin-top-30" class="hidden-tag"></span>
                    <?php echo zella_cat_header($nasa_term_id); ?>

                    <div class="row">
                        <?php
                        /**
                         * Hook: woocommerce_archive_description.
                         *
                         * @hooked woocommerce_taxonomy_archive_description - 10
                         * @hooked woocommerce_product_archive_description - 10
                         */
                        do_action('woocommerce_archive_description');
                        ?>
                        <div class="large-12 columns nasa_shop_description text-justify<?php echo !empty($nasa_description) ? ' margin-bottom-20' : ''; ?>">
                            <?php echo zella_str($nasa_description); ?>
                        </div>
                    </div>

                    <div class="nasa-archive-product-warp<?php echo esc_attr($layout_style); ?>">
                        <?php
                        if(woocommerce_product_loop()) :
                            // Content products in shop
                            if(NASA_WOO_ACTIVED && version_compare(wc()->version, '3.3.0', "<")) :
                                do_action('nasa_archive_get_sub_categories');
                            endif;
                            woocommerce_product_loop_start();
                            do_action('nasa_get_content_products', $nasa_sidebar);
                            woocommerce_product_loop_end();
                        else :
                            echo '<div class="row"><div class="large-12 columns">';
                            do_action('woocommerce_no_products_found');
                            echo '</div></div>';
                        endif;
                        ?>
                    </div>

                    <div class="row nasa-paginations-warp filters-container-down">
                        <?php
                        // Pagination -->
                        do_action('woocommerce_after_shop_loop');
                        ?>
                    </div>

                    <?php if($nasa_recom_pos == 'bot' && defined('NASA_CORE_ACTIVED') && NASA_CORE_ACTIVED) : ?>
                        <span id="position-nasa-recommend-product" class="hidden-tag"></span>
                        <?php do_action('nasa_recommend_product', $nasa_term_id); ?>
                    <?php endif; ?>
                </div>

                <?php /* Sidebar LEFT | RIGHT */
                do_action('nasa_sidebar_shop', $nasa_sidebar);
                do_action('woocommerce_after_main_content');
                ?>
            </div>
        </div>
    </div>
</div>

<?php
$disable_ajax_product = false;
if((isset($nasa_opt['disable_ajax_product']) && $nasa_opt['disable_ajax_product']) || get_option('woocommerce_shop_page_display', '') != '' || get_option('woocommerce_category_archive_display', '') != '') :
    $disable_ajax_product = true;
endif;

if(!$disable_ajax_product) : ?>
    <div id="nasa-has-filter-ajax" class="nasa-has-filter-ajax hidden-tag">
        <div class="current-cat hidden-tag">
            <a data-id="<?php echo (int) $nasa_term_id; ?>" href="<?php echo esc_url($nasa_href_page); ?>" class="nasa-filter-by-cat" id="nasa-hidden-current-cat" data-taxonomy="<?php echo esc_attr($nasa_type_page); ?>" data-sidebar="<?php echo esc_attr($nasa_sidebar); ?>"></a>
        </div>
        <p><?php esc_html_e('No products were found matching your selection.', 'zella-theme'); ?></p>
        <?php if ($s = get_search_query()): ?>
            <input type="hidden" name="nasa_hasSearch" id="nasa_hasSearch" value="<?php echo esc_attr($s); ?>" />
        <?php endif; ?>
        <?php if($nasa_has_get_sidebar) : ?>
            <input type="hidden" name="nasa_getSidebar" id="nasa_getSidebar" value="<?php echo esc_attr($nasa_sidebar); ?>" />
        <?php endif; ?>
        <input type="hidden" name="nasa_min-price" id="nasa_min-price" value="<?php echo isset($_REQUEST['min_price']) ? intval($_REQUEST['min_price']) : ''; ?>" />
        <input type="hidden" name="nasa_max-price" id="nasa_max-price" value="<?php echo isset($_REQUEST['max_price']) ? intval($_REQUEST['max_price']) : ''; ?>" />
        <input type="hidden" name="nasa_hasPrice" class="nasa_hasPrice" value="<?php echo (isset($_REQUEST['min_price']) || isset($_REQUEST['max_price'])) ? '1' : '0'; ?>" />
        
        <?php
        // <!-- Current URL -->
        $slug_nopaging = zella_nopaging_url();
        echo $slug_nopaging ? '<input type="hidden" name="nasa_current-slug" id="nasa_current-slug" value="' . esc_url($slug_nopaging) . '" />' : '';
        ?>
    </div>
<?php endif;

get_footer('shop');
