<?php
/**
 * The template for displaying search forms in nasatheme
 *
 * @package nasatheme
 */

$_id = rand();
?>

<div class="search-wrapper nasa-searchform-container <?php echo esc_attr($_id); ?>_container">
    <table class="nasa-table-search-wrapper">
        <tr>
            <td>
                <div class="nasa-search-form-warp">
                    <form method="get" class="nasa-searchform" action="<?php echo esc_url(home_url('/')); ?>">
                        <div class="search-control-group control-group">
                            <label class="sr-only screen-reader-text">
                                <?php esc_html_e('Search here', 'zella-theme'); ?>
                            </label>
                            <input id="nasa-input-<?php echo esc_attr($_id); ?>" type="text" class="search-field search-input" value="<?php echo get_search_query(); ?>" name="s" placeholder="<?php esc_attr_e("Search ...", 'zella-theme'); ?>" />
                            <span class="nasa-icon-submit-page">
                                <input type="submit" name="page" value="search" />
                            </span>
                            <input type="hidden" name="post_type" value="post" />
                        </div>
                    </form>
                </div>
            </td>
        </tr>
    </table>
</div>