<?php
/**
 * The template for displaying Search Results pages.
 *
 * @package nasatheme
 */

$nasa_sidebar = isset($nasa_opt['blog_layout']) ? $nasa_opt['blog_layout'] : '';

// Check sidebar
if (isset($_GET['sidebar'])):
    switch ($_GET['sidebar']) :
        case 'right' :
            $nasa_sidebar = 'right';
            break;
        
        case 'no' :
            $nasa_sidebar = 'no';
            break;
        
        case 'left' :
        default:
            $nasa_sidebar = 'left';
            break;
    endswitch;
endif;

$hasSidebar = true;
$left = false;
switch ($nasa_sidebar):
    case 'right':
        $attr = 'large-9 desktop-padding-right-30 left columns';
        break;
    
    case 'no':
        $hasSidebar = false;
        $attr = 'large-12 columns';
        break;
    
    case 'left':
    default:
        $left = true;
        $attr = 'large-9 desktop-padding-left-30 right columns';
        break;
endswitch;

if (isset($nasa_opt['nasa_in_mobile']) && $nasa_opt['nasa_in_mobile']) :
    $attr .= ' nasa-blog-in-mobile';
endif;

get_header();
?>

<div class="container-wrap page-<?php echo !$nasa_sidebar ? 'left' : esc_attr($nasa_sidebar); ?>-sidebar">
    <?php if ($hasSidebar): ?>
        <div class="div-toggle-sidebar center">
            <a class="toggle-sidebar" href="javascript:void(0);">
                <i class="fa fa-bars"></i>
            </a>
        </div>
    <?php endif; ?>

    <div class="row">
        <div id="content" class="<?php echo esc_attr($attr); ?>" role="main">
            <div class="page-inner margin-bottom-50">
                <?php if (have_posts()) : ?>
                    <header class="page-header">
                        <h1 class="page-title">
                            <?php printf(esc_html__('Search Results for: %s', 'zella-theme'), '<span>' . get_search_query() . '</span>'); ?>
                        </h1>
                    </header>

                <?php
                    get_template_part('content', get_post_format());
                    zella_content_nav('nav-below');
                else :
                    get_template_part('no-results', 'search');
                endif;
                ?>
            </div>
        </div>

        <?php if($nasa_sidebar != 'no'):?>
            <div class="large-3 columns <?php echo !$left ? 'right' : 'left'; ?> col-sidebar">
                <?php get_sidebar(); ?>
            </div>
        <?php endif;?>

    </div>	
</div>

<?php
get_footer();
