<?php
/**
 * 
 * @param type $font_families
 * @param type $font_set
 * @return string The cleaned URL.
 */
function zella_google_fonts_url($font_families = array(), $font_set = array()) {
    if (empty($font_families) || empty($font_set)) {
        return false;
    }
    
    $query_args = array(
        'family' => urlencode(implode('|', $font_families)),
        'subset' => urlencode(implode(',', $font_set))
    );
    
    return esc_url_raw(add_query_arg($query_args, 'https://fonts.googleapis.com/css'));
}

/**
 * Select Font custom use load site
 */
if(!isset($nasa_opt['type_font_select']) || $nasa_opt['type_font_select'] == 'custom') {
    $nasa_custom_font = 'Zella-NS-True';
    if(isset($nasa_opt['custom_font']) && $nasa_opt['custom_font']) {
        $nasa_custom_font = $nasa_opt['custom_font'];
    }
    
    /**
     * Default Custom Font
     */
    if($nasa_custom_font == 'Zella-NS-True') {
        add_action('wp_enqueue_scripts', 'zella_custom_fonts_site_default');
        function zella_custom_fonts_site_default() {
            wp_enqueue_style('nasa-customfonts', ZELLA_THEME_URI . '/assets/font-ns-true/NS-True.css');
        }
    }
    
    /**
     * Upload Custom font
     */
    else {
        $nasa_upload_dir = !isset($nasa_upload_dir) ? wp_upload_dir() : $nasa_upload_dir;
        if(is_file($nasa_upload_dir['basedir'] . '/nasa-custom-fonts/' . $nasa_opt['custom_font'] . '/' . $nasa_opt['custom_font'] . '.css')) {
            add_action('wp_enqueue_scripts', 'zella_custom_fonts_site');
            function zella_custom_fonts_site() {
                global $nasa_opt, $nasa_upload_dir;
                $urlFont = $nasa_upload_dir['baseurl'] . '/nasa-custom-fonts/' . $nasa_opt['custom_font'] . '/' . $nasa_opt['custom_font'] . '.css';
                wp_enqueue_style('nasa-customfonts', $urlFont);
            }
        }
    }
}

/**
 * Select Google Font use load site
 */
elseif (
    isset($nasa_opt['type_font_select']) &&
    $nasa_opt['type_font_select'] == 'google' &&
    isset($nasa_opt['type_headings'])
) {
    $default_fonts = array(
        "Open Sans",
        "Helvetica",
        "Arial",
        "sans-serif"
    );

    $googlefonts = array(
        $nasa_opt['type_headings'],
        $nasa_opt['type_texts'],
        $nasa_opt['type_nav'],
        $nasa_opt['type_banner'],
        $nasa_opt['type_price']
    );
    
    $nasa_font_family = array();
    $nasa_font_set = array('latin');

    if (!empty($nasa_opt['type_subset'])) {
        foreach ($nasa_opt['type_subset'] as $key => $val) {
            if($val && !in_array($key, $nasa_font_set)) {
                $nasa_font_set[] = $key;
            }
        }
    }

    foreach ($googlefonts as $googlefont) {
        if (!in_array($googlefont, $default_fonts)) {
            $default_fonts[] = $googlefont;
            $nasa_font_family[] = $googlefont . ':400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';
        }
    }

    if (!empty($nasa_font_family) && !empty($nasa_font_set)) {
        add_action('wp_enqueue_scripts', 'zella_google_fonts');
        function zella_google_fonts() {
            global $nasa_font_family, $nasa_font_set;
            $font_google_url = zella_google_fonts_url($nasa_font_family, $nasa_font_set);
            if($font_google_url) {
                wp_enqueue_style('nasa-googlefonts', $font_google_url);
            }
        }
    }
}
