<?php $class_col = 'large-12 columns'; ?>
<div class="blog-list-style">
    <article id="post-<?php echo absint($postId); ?>" <?php post_class(); ?>>
        <div class="row">
            <?php if (has_post_thumbnail()) : ?>
                <div class="large-4 columns">
                    <div class="entry-image">
                        <a href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($title); ?>">
                            <?php the_post_thumbnail('medium'); ?>
                            <div class="image-overlay"></div>
                        </a>
                    </div>
                </div>
            <?php
            $class_col = 'large-8 columns';
            endif; ?>

            <div class="<?php echo esc_attr($class_col); ?>">
                <div class="entry-content">
                    <h3 class="entry-title">
                        <a href="<?php echo esc_url($link); ?>" title="<?php echo esc_attr($title); ?>" rel="bookmark">
                            <?php echo zella_str($title); ?>
                        </a>
                    </h3>
                    <?php the_excerpt(); ?>
                    
                    <?php
                    $tags_list = $show_tag_info ? get_the_tag_list('', esc_html__(', ', 'zella-theme')) : false;
                    if($show_cat_info || ($show_tag_info && $tags_list)) : ?>
                        <div class="margin-top-15 margin-bottom-5">
                            <?php if ('post' == get_post_type()) : ?>
                                <?php if ($show_cat_info) : ?>
                                    <?php $categories_list = get_the_category_list(esc_html__(', ', 'zella-theme')); ?>
                                    <span class="cat-links">
                                        <?php printf(esc_html__('Posted in %1$s', 'zella-theme'), $categories_list); ?>
                                    </span>
                                <?php endif; ?>

                                <?php
                                if ($show_tag_info) :
                                    if ($tags_list) :
                                        ?>
                                        <?php if ($show_cat_info) : ?>
                                            <span class="sep"> | </span>
                                        <?php endif; ?>
                                        <span class="tags-links">
                                            <?php printf(esc_html__('Tagged %1$s', 'zella-theme'), $tags_list); ?>
                                        </span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($show_author_info || $show_date_info) : ?>
                        <div class="entry-meta">
                            <?php if($show_author_info) : ?>
                                <span class="meta-author"><?php echo esc_html__('By', 'zella-theme'); ?> <strong><a href="<?php echo esc_url($link_author); ?>" title="<?php echo esc_attr($author); ?>" rel="author"><?php echo esc_attr($author); ?></a></strong>. </span>
                            <?php
                            endif;
                            if($show_date_info) : ?>
                                <?php echo esc_html__('Posted on', 'zella-theme'); ?> <a href="<?php echo esc_url($link_date); ?>" title="<?php echo esc_attr($date_post); ?>" rel="bookmark"><time class="entry-date" datetime="<?php echo esc_attr($date_post); ?>"><?php echo $date_post; ?></time></a>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </article>
</div>