<div class="<?php echo esc_attr($header_classes); ?>">
    <?php //!-- Top bar --
    zella_header_topbar($hstructure);
    //!-- End Top bar --
    
    //!-- Masthead --?>
    <div class="sticky-wrapper">
        <header id="masthead" class="site-header">
            <div class="row">
                <div class="large-12 columns header-container nasa-wrap-width-main-menu">
                    <!-- Mobile Menu -->
                    <div class="mobile-menu">
                        <?php zella_mobile_header(); ?>
                    </div>
                    
                    <div class="row nasa-site-header-desktop nasa-hide-for-mobile">
                        <div class="large-12 columns nasa-wrap-event-search">
                            <div class="row nasa-elements-wrap">
                                <div class="large-12 columns">
                                    <table class="nasa-table-header">
                                        <tr>
                                            <td class="nasa-td-45">
                                                <!-- Main menu -->
                                                <div class="wide-nav nasa-bg-wrap<?php echo esc_attr($menu_warp_class); ?>">
                                                    <div class="nasa-menus-wrapper-reponsive" data-padding_y="<?php echo (int) $data_padding_y; ?>" data-padding_x="<?php echo (int) $data_padding_x; ?>">
                                                        <?php zella_main_menu(); ?>
                                                    </div>
                                                </div>
                                                
                                            </td>
                                            <td class="nasa-td-20">
                                                <div class="logo-wrapper nasa-fullwidth">
                                                    <?php echo zella_logo(true); ?>
                                                </div>
                                            </td>
                                            
                                            <td>
                                                <div class="rtl-left">
                                                    <?php echo zella_str($nasa_header_icons); ?>
                                                </div>
                                                <div class="nasa-menus-account-wrap rtl-left">
                                                    <?php echo zella_tiny_account(); ?>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>

                            <!-- Search form in header -->
                            <div class="nasa-header-search-wrap nasa-hide-for-mobile">
                                <?php echo zella_search('icon'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if(isset($show_cat_top_filter) && $show_cat_top_filter) : ?>
                <div class="nasa-top-cat-filter-wrap">
                    <?php echo zella_all_categories(false, true); ?>
                    <a href="javascript:void(0);" title="<?php esc_attr_e('Close categories filter', 'zella-theme'); ?>" class="nasa-close-filter-cat"><i class="pe-7s-close"></i></a>
                </div>
            <?php endif; ?>
        </header>
    </div>
</div>
