<?php

/**
 * VC SETUP
 */
add_action('init', 'zella_vc_setup');
if (!function_exists('zella_vc_setup')) :

    function zella_vc_setup() {
        if (!class_exists('WPBakeryVisualComposerAbstract')){
            return;
        }

        // **********************************************************************// 
        // ! Row (add fullwidth, parallax option)
        // **********************************************************************//
        vc_add_param('vc_row', array(
            "type" => 'checkbox',
            "heading" => esc_html__("Fullwidth?", 'zella-theme'),
            "param_name" => "fullwidth",
            "value" => array(
                esc_html__('Yes, please', 'zella-theme') => '1'
            )
        ));
        
        //Add param from tab element
        vc_add_param('vc_tta_tabs', array(
            "type" => "dropdown",
            "heading" => esc_html__("Tabs title display type", 'zella-theme'),
            "param_name" => "tabs_display_type",
            "value" => array(
                esc_html__('Classic 2D - No border', 'zella-theme') => '2d-no-border',
                esc_html__('Classic 2D - Has BG color', 'zella-theme') => '2d-has-bg',
                esc_html__('Classic 2D', 'zella-theme') => '2d',
                esc_html__('Classic 3D', 'zella-theme') => '3d',
                esc_html__('Slide', 'zella-theme') => 'slide'
            ),
            "std" => '2d-no-border'
        ));
        
        vc_add_param('vc_tta_tabs', array(
            "type" => "colorpicker",
            "heading" => esc_html__("Tabs Background color", 'zella-theme'),
            "param_name" => "tabs_bg_color",
            "std" => '#efefef',
            "dependency" => array(
                "element" => "tabs_display_type",
                "value" => array(
                    "2d-has-bg"
                )
            )
        ));
        
        vc_add_param('vc_tta_tabs', array(
            "type" => "colorpicker",
            "heading" => esc_html__("Tabs text color", 'zella-theme'),
            "param_name" => "tabs_text_color",
            "std" => '',
            "dependency" => array(
                "element" => "tabs_display_type",
                "value" => array(
                    "2d-has-bg"
                )
            )
        ));
        
        vc_add_param('vc_tta_accordion', array(
            "type" => "dropdown",
            "heading" => esc_html__("Layout", 'zella-theme'),
            "param_name" => "accordion_layout",
            'value' => array(
                esc_html__('Border Wrapper', 'zella-theme') => 'has-border',
                esc_html__('Without Border Wrapper', 'zella-theme') => 'no-border'
            ),
            'std' => 'has-border',
            "description" => esc_html__('Only use for Accordion.', 'zella-theme'),
        ));
        
        vc_add_param('vc_tta_accordion', array(
            "type" => "dropdown",
            "heading" => esc_html__("Toggle Icon", 'zella-theme'),
            "param_name" => "accordion_icon",
            'value' => array(
                esc_html__('Plus', 'zella-theme') => 'plus',
                esc_html__('Arrow', 'zella-theme') => 'arrow'
            ),
            'std' => 'plus',
            "description" => esc_html__('Only use for Accordion.', 'zella-theme'),
        ));
        
        vc_add_param('vc_tta_accordion', array(
            "type" => 'checkbox',
            "heading" => esc_html__("Hide First Section ?", 'zella-theme'),
            "param_name" => "accordion_hide_first",
            "value" => array(
                esc_html__('Yes, please', 'zella-theme') => '1'
            )
        ));
        
        vc_add_param('vc_tta_accordion', array(
            "type" => 'checkbox',
            "heading" => esc_html__("Show Multi", 'zella-theme'),
            "param_name" => "accordion_show_multi",
            "value" => array(
                esc_html__('Yes, please', 'zella-theme') => '1'
            )
        ));
        
        // Add param from columns element
        vc_add_param('vc_column', array(
            "type" => "dropdown",
            "heading" => esc_html__("Width full side", 'zella-theme'),
            "param_name" => "width_side",
            'value' => array(
                esc_html__('None', 'zella-theme') => '',
                esc_html__('Full width to left', 'zella-theme') => 'left',
                esc_html__('Full width to right', 'zella-theme') => 'right'
            ),
            'std' => '',
            "description" => esc_html__('Only use for Visual Composer Template.', 'zella-theme'),
        ));
    }

endif;

// **********************************************************************// 
// ! Add Font Awesome, Font Pe7s
// **********************************************************************//
add_action('wp_enqueue_scripts', 'zella_add_fonts_style');
if(!function_exists('zella_add_fonts_style')) :
    function zella_add_fonts_style() {
        global $nasa_opt;
        /**
         * Add Font Awesome
         */
        wp_enqueue_style('zella-font-awesome-style', ZELLA_THEME_URI . '/assets/font-awesome-4.7.0/css/font-awesome.min.css', array(), false, 'all');
        
        /**
         * Add Font Awesome 5.0.13
         */
        if(isset($nasa_opt['include_font_awesome_new']) && $nasa_opt['include_font_awesome_new']) {
            wp_enqueue_style('zella-font-awesome-5-free-style', ZELLA_THEME_URI . '/assets/font-awesome-5.0.13/css/fontawesome-all.min.css', array(), false, 'all');
        }
        
        /**
         * Add Font Pe7s
         */
        wp_enqueue_style('zella-font-pe7s-style', ZELLA_THEME_URI . '/assets/font-pe-icon-7-stroke/css/pe-icon-7-stroke.css', array(), false, 'all');
    }
endif;

/**
 * Dequeue scripts and styles
 */
add_action('wp_enqueue_scripts', 'zella_dequeue_scripts', 100);
function zella_dequeue_scripts() {
    /**
     * dequeue_wc_fragments
     */
    // wp_dequeue_script('wc-cart-fragments');
    
    /**
     * Ignore css
     */
    if (!NASA_CORE_IN_ADMIN) {
        wp_deregister_style('woocommerce-layout');
        wp_deregister_style('woocommerce-smallscreen');
        wp_deregister_style('woocommerce-general');
    }
    
    /**
     * Dequeue contact-form-7 css
     */
    if(function_exists('wpcf7_style_is') && wpcf7_style_is()) {
        wp_dequeue_style('contact-form-7');
    }
    
    /**
     * Dequeue YITH WooCommerce Product Compare colorbox css
     */
    if(class_exists('YITH_Woocompare_Frontend') && (!isset($nasa_opt['nasa-product-compare']) || $nasa_opt['nasa-product-compare'])) {
        wp_dequeue_style('jquery-colorbox');
        wp_dequeue_script('jquery-colorbox');
    }
    
    /**
     * Dequeue YITH WooCommerce Product Wishlist css
     */
    if(NASA_WISHLIST_ENABLE && !defined('YITH_WCWL_PREMIUM')) {
        wp_deregister_style('jquery-selectBox');
        wp_deregister_style('yith-wcwl-font-awesome');
        wp_deregister_style('yith-wcwl-font-awesome-ie7');
        wp_deregister_style('yith-wcwl-main');
    }
    
    /**
     * Dequeue YITH WooCommerce Product Bundles css
     */
    if(defined('YITH_WCPB')) {
        wp_deregister_style('yith_wcpb_bundle_frontend_style');
    }
}

/**
 * enqueue_scripts
 */
add_action('wp_enqueue_scripts', 'zella_enqueue_scripts', 998);
function zella_enqueue_scripts() {
    global $nasa_opt;
    // Main Css
    wp_enqueue_style('zella-style', get_stylesheet_uri());
    
    // RTL CSS
    if (
        (isset($nasa_opt['nasa_rtl']) && $nasa_opt['nasa_rtl']) ||
        (isset($_REQUEST['rtl']) && $_REQUEST['rtl'] == '1')
    ) {
        wp_enqueue_style('zella-style-rtl', ZELLA_THEME_URI . '/style-rtl.css', array('zella-style'));
    }
    
    wp_enqueue_script('jquery-cookie', ZELLA_THEME_URI . '/assets/js/min/jquery.cookie.min.js', array('jquery'), null, true);
    wp_enqueue_script('modernizr', ZELLA_THEME_URI . '/assets/js/min/modernizr.min.js', array('jquery'), null, true);
    
    wp_enqueue_script('jquery-JRespond', ZELLA_THEME_URI . '/assets/js/min/jquery.jRespond.min.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-waypoints', ZELLA_THEME_URI . '/assets/js/min/jquery.waypoints.min.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-tipr', ZELLA_THEME_URI . '/assets/js/min/jquery.tipr.min.js', array('jquery'), null, true);
    wp_enqueue_script('jquery-variations', ZELLA_THEME_URI . '/assets/js/min/jquery.variations.min.js', array('jquery'), null, true);
    
    if(class_exists('WC_AJAX')) {
        $params_variations = array(
            'wc_ajax_url' => WC_AJAX::get_endpoint( '%%endpoint%%' ),
            'i18n_no_matching_variations_text' => esc_attr__('Sorry, no products matched your selection. Please choose a different combination.', 'zella-theme'),
            'i18n_make_a_selection_text' => esc_attr__('Please select some product options before adding this product to your cart.', 'zella-theme'),
            'i18n_unavailable_text' => esc_attr__('Sorry, this product is unavailable. Please choose a different combination.', 'zella-theme')
        );
        wp_add_inline_script('jquery-variations', 'var nasa_params_variations=' . json_encode($params_variations) . '; var _quicked_gallery = true;', 'before');
    }
    
    /**
     * magnific popup
     */
    if(!wp_script_is('jquery-magnific-popup')) {
        wp_enqueue_script('jquery-magnific-popup', ZELLA_THEME_URI . '/assets/js/min/jquery.magnific-popup.js', array('jquery'), null, true);
    }
    
    /**
     * owl carousel slider
     */
    if(!wp_script_is('owl-carousel')) {
        wp_enqueue_script('owl-carousel', ZELLA_THEME_URI . '/assets/js/min/owl.carousel.min.js', array('jquery'), null, true);
    }
    
    /**
     * Slick slider
     */
    if(!wp_script_is('jquery-slick')) {
        wp_enqueue_script('jquery-slick', ZELLA_THEME_URI . '/assets/js/min/jquery.slick.min.js', array('jquery'), null, true);
    }
    
    /**
     * Parallax
     */
    wp_enqueue_script('jquery-stellar', ZELLA_THEME_URI . '/assets/js/min/jquery.stellar.min.js', array('jquery'), null, true);
    
    /**
     * Countdown js
     */
    if(!wp_script_is('countdown')) {
        wp_enqueue_script('countdown', ZELLA_THEME_URI . '/assets/js/min/countdown.min.js', array('jquery'), null, true);
        wp_localize_script(
            'zella-countdown', 'nasa_countdown_l10n',
            array(
                'days'      => esc_html__('Days', 'zella-theme'),
                'months'    => esc_html__('Months', 'zella-theme'),
                'weeks'     => esc_html__('Weeks', 'zella-theme'),
                'years'     => esc_html__('Years', 'zella-theme'),
                'hours'     => esc_html__('Hours', 'zella-theme'),
                'minutes'   => esc_html__('Mins', 'zella-theme'),
                'seconds'   => esc_html__('Secs', 'zella-theme'),
                'day'       => esc_html__('Day', 'zella-theme'),
                'month'     => esc_html__('Month', 'zella-theme'),
                'week'      => esc_html__('Week', 'zella-theme'),
                'year'      => esc_html__('Year', 'zella-theme'),
                'hour'      => esc_html__('Hour', 'zella-theme'),
                'minute'    => esc_html__('Min', 'zella-theme'),
                'second'    => esc_html__('Sec', 'zella-theme')
            )
        );
    }
    
    /**
     * Easy zoom js
     */
    wp_enqueue_script('jquery-easyzoom', ZELLA_THEME_URI . '/assets/js/min/jquery.easyzoom.min.js', array('jquery'), null, true);
    
    /**
     * Wow js
     */
    if(!isset($nasa_opt['disable_wow']) || !$nasa_opt['disable_wow']) {
        wp_enqueue_script('wow', ZELLA_THEME_URI . '/assets/js/min/wow.min.js', array('jquery'), null, true);
    }
    
    /**
     * masonry-isotope
     */
    if(!wp_script_is('jquery-masonry-isotope')) {
        wp_enqueue_script('jquery-masonry-isotope', ZELLA_THEME_URI . '/assets/js/min/jquery.masonry-isotope.min.js', array('jquery'), null, true);
    }
    
    /**
     * Theme js
     */
    wp_enqueue_script('zella-functions-js', ZELLA_THEME_URI . '/assets/js/min/functions.min.js', array('jquery'), null, true);
    wp_enqueue_script('zella-js', ZELLA_THEME_URI . '/assets/js/min/main.min.js', array('jquery'), null, true);
    $nasa_theme_js = 'var ajaxurl="' . esc_url(admin_url('admin-ajax.php')) . '";';
    wp_add_inline_script('zella-functions-js', $nasa_theme_js, 'before');
    
    /**
     * Add css comment reply
     */
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
