<?php

/* Mobile header */
if (!function_exists('zella_mobile_header')) :

    function zella_mobile_header() {
        global $nasa_opt;
        ?>
        <div class="row">
            <div class="large-12 columns">
                <table>
                    <tr>
                        <td class="nasa-td-20">
                            <div class="mini-icon-mobile">
                                <a href="javascript:void(0);" class="nasa-mobile-menu_toggle mobile_toggle"><span class="nasa-mobile-menu-icon pe-7s-menu"></span></a>
                                <a class="icon pe-7s-search mobile-search" href="javascript:void(0);"></a>
                            </div>
                        </td>

                        <td>
                            <div class="logo-wrapper">
                                <?php echo zella_logo(); ?>
                            </div>
                        </td>

                        <td class="nasa-td-mobile-icons">
                            <?php
                            $show_icons = isset($nasa_opt['topbar_mobile_icons_toggle']) && $nasa_opt['topbar_mobile_icons_toggle'] ? false : true;
                            $class_icons_wrap = '';
                            $toggle_icon = '';
                            
                            if(!$show_icons) :
                                $class_icons_wrap .= ' nasa-absolute-icons nasa-hide-icons';
                                $toggle_icon .= '<a class="nasa-toggle-mobile_icons" href="javascript:void(0);"><span class="nasa-icon"></span></a>';
                            endif;
                            
                            echo '<div class="nasa-mobile-icons-wrap' . $class_icons_wrap . '">';
                            echo zella_str($toggle_icon);
                            echo zella_header_icons(true, true, true, true, false);
                            echo '</div>';
                            ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <?php
    }
endif;

/**
 * Add Block header
 */
if (!function_exists('zella_block_header')):

    function zella_block_header() {
        global $nasa_opt, $wp_query;
        
        $object = $wp_query->get_queried_object();
        $pageOption = isset($object->post_type) && $object->post_type == 'page' ? true : false;
        $objectId = $pageOption ? $object->ID : 0;

        $custom_header = $objectId ? get_post_meta($objectId, '_nasa_custom_header', true) : '';
        $header_block = ($custom_header !== '' && $objectId) ? get_post_meta($objectId, '_nasa_header_block', true) : $nasa_opt['header-block'];

        if($header_block == '-1' || $header_block == 'default') {
            return;
        }
        
        $header_block = $header_block == '' ? (isset($nasa_opt['header-block']) && $nasa_opt['header-block'] != 'default' ? $nasa_opt['header-block'] : false) : $header_block;
        $header_block = $header_block ? $header_block : false;
        
        echo !empty($header_block) ? zella_block($header_block) : '';
    }

endif;

/**
 * Add action header
 */
add_action('init', 'zella_add_action_header');
if (!function_exists('zella_add_action_header')):

    function zella_add_action_header() {
        /* INIT Header site */
        add_action('nasa_get_header_theme', 'zella_header_theme', 10);
        
        /* Header Promotion */
        add_action('nasa_before_header_structure', 'zella_promotion_recent_post', 1);
        
        /* Header Default */
        add_action('nasa_header_structure', 'zella_header_structure', 10);
        add_action('nasa_header_structure', 'zella_block_header', 100);
        
        /* Breadcrumb site */
        add_action('nasa_after_header_structure', 'zella_breadcrumb', 999);
    }

endif;

/**
 * Add custom meta to head tag
 */
if (!is_home()) :
    add_action('wp_head', 'zella_share_meta_head');
    if(!function_exists('zella_share_meta_head')):
        function zella_share_meta_head() {
            global $post;
            ?>
            <meta property="og:title" content="<?php the_title(); ?>" />
            <?php if (isset($post->ID)) : ?>
                <?php if (has_post_thumbnail($post->ID)) :
                    $image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'single-post-thumbnail'); ?>
                    <meta property="og:image" content="<?php echo esc_url($image[0]); ?>" />
                <?php endif; ?>
            <?php endif; ?>
            <meta property="og:url" content="<?php the_permalink(); ?>" />
            <?php
        }
    endif;
endif;

// **********************************************************************// 
// ! Header main
// **********************************************************************//
if(!function_exists('zella_header_theme')) :
    function zella_header_theme() {
        global $nasa_opt;
        $file = ZELLA_CHILD_PATH . '/headers/header-main.php';
        include_once is_file($file) ? $file : ZELLA_THEME_PATH . '/headers/header-main.php';
    }
endif;

// **********************************************************************// 
// ! Get header structure
// **********************************************************************//
if (!function_exists('zella_header_structure')):

    function zella_header_structure() {
        global $woocommerce, $woo_options, $nasa_opt, $wp_query;

        $fixed_nav = '';
        $hstructure = isset($nasa_opt['header-type']) ? $nasa_opt['header-type'] : '1';
        
        /**
         * Swith header structure
         */
        $object = $wp_query->get_queried_object();
        $pageOption = isset($object->post_type) && $object->post_type == 'page' ? true : false;
        $objectId = $pageOption ? $object->ID : 0;
        if($objectId) {
            $custom_header = get_post_meta($objectId, '_nasa_custom_header', true);
            if (!empty($custom_header)) {
                $hstructure = $custom_header;
            }
            
            $fixed_nav = get_post_meta($objectId, '_nasa_fixed_nav', true);
            $fixed_nav = $fixed_nav == '-1' ? false : $fixed_nav;
        }
        
        if ($fixed_nav === '') {
            $fixed_nav = (!isset($nasa_opt['fixed_nav']) || $nasa_opt['fixed_nav']);
        }
        
        /**
         * Header builder
         */
        if($hstructure == 'nasa-custom') {
            remove_action('nasa_header_structure', 'zella_block_header', 100);
            $header_slug = get_post_meta($objectId, '_nasa_header_builder', true);
            $globalBuilder = isset($nasa_opt['header-type']) && $nasa_opt['header-type'] == 'nasa-custom' ? true : false;
            $header_slug = !$header_slug ? (($globalBuilder && isset($nasa_opt['header-custom']) && $nasa_opt['header-custom'] != '') ? $nasa_opt['header-custom'] : '') : $header_slug;
            zella_header_builder($header_slug);
            
            return;
        }
        
        $header_classes = array();
        
        /**
         * Transparent header
         */
        $header_transparent = $pageOption ? get_post_meta($objectId, '_nasa_header_transparent', true) : '';
        $header_transparent = $header_transparent == '-1' ? '0' : $header_transparent;
        $header_transparent = $header_transparent == '' ? ((!isset($nasa_opt['header_transparent']) || !$nasa_opt['header_transparent']) ? false : true) : (bool) $header_transparent;
        if($header_transparent) {
            $header_classes[] = 'nasa-header-transparent';
        }
        
        /**
         * Mobile Detect
         */
        if (isset($nasa_opt['nasa_in_mobile']) && $nasa_opt['nasa_in_mobile']) {
            $header_classes[] = 'mobile-menu nasa-header-mobile-layout';
            if ($fixed_nav) {
                $header_classes[] = 'nasa-header-sticky';
            }
            
            $topMenu = in_array($hstructure, array('4', '5', '6')) ? true : false;
            $header_classes = !empty($header_classes) ? implode(' ', $header_classes) : '';
            
            $file = ZELLA_CHILD_PATH . '/headers/header-mobile.php';
            include is_file($file) ? $file : ZELLA_THEME_PATH . '/headers/header-mobile.php';
            
            return;
        }
        
        /**
         * Init vars
         */
        $menu_warp_class = array();
        $header_classes[] = 'header-wrapper';
        $full_rule_headers = array('5', '6');
        
        /**
         * Extra class name
         */
        $el_class_header = $pageOption ? get_post_meta($objectId, '_nasa_el_class_header', true) : '';
        if($el_class_header != '') {
            $header_classes[] = $el_class_header;
        }
        
        /**
         * Main menu style
         */
        $menu_warp_class[] = 'nasa-nav-style-1';
        $data_padding_y = 20;
        $data_padding_x = 15;
        
        $menu_warp_class = !empty($menu_warp_class) ? ' ' . implode(' ', $menu_warp_class) : '';
        
        /**
         * Fullwidth main menu
         */
        $fullwidth_main_menu = true;
        if(in_array($hstructure, $full_rule_headers)) {
            $fullwidth_main_menu = $pageOption ? get_post_meta($objectId, '_nasa_fullwidth_main_menu', true) : true;
            $fullwidth_main_menu = $fullwidth_main_menu === '-1' ? '0' : $fullwidth_main_menu;
            
            if($fullwidth_main_menu == '' && isset($nasa_opt['header-type']) && in_array($nasa_opt['header-type'], $full_rule_headers)) {
                $fullwidth_main_menu = (isset($nasa_opt['fullwidth_main_menu']) && !$nasa_opt['fullwidth_main_menu']) ? false : true;
            }
            else {
                $fullwidth_main_menu = $fullwidth_main_menu ? true : false;
            }
        }
        
        $header_classes[] = 'header-type-' . $hstructure;
        
        /**
         * Sticky header
         */
        if ($fixed_nav) {
            $header_classes[] = 'nasa-header-sticky';
        }
        
        /**
         * $header_classes to string
         */
        $header_classes = !empty($header_classes) ? implode(' ', $header_classes) : '';
        
        /**
         * Top filter cats
         */
        $show_icon_cat_top = isset($nasa_opt['show_icon_cat_top']) ? $nasa_opt['show_icon_cat_top'] : 'show-in-shop';
        switch ($show_icon_cat_top) :
            case 'show-all-site':
                $show_cat_top_filter = true;
                break;

            case 'not-show':
                $show_cat_top_filter = false;
                break;

            case 'show-in-shop':
            default:
                $show_cat_top_filter = (!is_post_type_archive('product') && !is_tax(get_object_taxonomies('product'))) ? false : true;
                break;
        endswitch;
        
        $show_product_cat = in_array((int) $hstructure, array(4, 5, 6)) ? true : false;
        $show_cart = true;
        $show_compare = in_array((int) $hstructure, array(4, 5, 6)) ? true : false;
        $show_wishlist = in_array((int) $hstructure, array(4, 5, 6)) ? true : false;
        $show_search = in_array((int) $hstructure, array(6)) ? false : true;
        $nasa_header_icons = zella_header_icons($show_product_cat, $show_cart, $show_compare, $show_wishlist, $show_search);
        
        /**
         * Main header incl
         */
        $file = ZELLA_CHILD_PATH . '/headers/header-structure-' . ((int) $hstructure) . '.php';
        if (is_file($file)) {
            include $file;
        } else {
            $file = ZELLA_THEME_PATH . '/headers/header-structure-' . ((int) $hstructure) . '.php';
            include is_file($file) ? $file : ZELLA_THEME_PATH . '/headers/header-structure-1.php';
        }
    }

endif;

/**
 * Group header icons
 */
if (!function_exists('zella_header_icons')) :
    function zella_header_icons($product_cat = true, $cart = true, $compare = true, $wishlist = true, $search = true) {
        global $nasa_opt;
        
        $icons = '';
        $first = false;
        
        if(NASA_WOO_ACTIVED && $product_cat) {
            $show_icon_cat_top = isset($nasa_opt['show_icon_cat_top']) ? $nasa_opt['show_icon_cat_top'] : 'show-in-shop';
            
            switch ($show_icon_cat_top) {
                case 'show-all-site':
                    $show_icon = true;
                    break;
                
                case 'not-show':
                    $show_icon = false;
                    break;
                
                case 'show-in-shop':
                default:
                    $show_icon = (!is_post_type_archive('product') && !is_tax(get_object_taxonomies('product'))) ? false : true;
                    break;
            }
            
            if($show_icon) {
                $nasa_icon_cat = 
                    '<a class="filter-cat-icon nasa-hide-for-mobile" href="javascript:void(0);" title="' . esc_attr__('Product Categories', 'zella-theme') . '">' .
                        '<i class="nasa-icon pe-7s-keypad"></i>' .
                    '</a>' .
                    '<a class="filter-cat-icon-mobile" href="javascript:void(0);" title="' . esc_attr__('Product Categories', 'zella-theme') . '">' .
                        '<i class="nasa-icon pe-7s-keypad"></i>' .
                    '</a>';
                $class = !$first ? 'first ' : '';
                $first = true;
                $icons .= '<li class="' . $class . 'nasa-icon-filter-cat">' . $nasa_icon_cat . '</li>';
            }
        }
        
        if($cart) {
            $nasa_mini_cart = zella_mini_cart();
            if($nasa_mini_cart != '') {
                $class = !$first ? 'first ' : '';
                $first = true;
                $icons .= '<li class="' . $class . 'nasa-icon-mini-cart">' . $nasa_mini_cart . '</li>';
            }
        }
        
        if($wishlist) {
            $nasa_icon_wishlist = zella_icon_wishlist();
            if($nasa_icon_wishlist != '') {
                $class = !$first ? 'first ' : '';
                $first = true;
                $icons .= '<li class="' . $class . 'nasa-icon-wishlist">' . $nasa_icon_wishlist . '</li>';
            }
        }
        
        if($compare && (!isset($nasa_opt['nasa-product-compare']) || $nasa_opt['nasa-product-compare'])) {
            $nasa_icon_compare = zella_icon_compare();
            if($nasa_icon_compare != '') {
                $class = !$first ? 'first ' : '';
                $first = true;
                $icons .= '<li class="' . $class . 'nasa-icon-compare">' . $nasa_icon_compare . '</li>';
            }
        }
        
        if($search) {
            $search_icon = 
            '<a class="search-icon desk-search" href="javascript:void(0);" data-open="0" title="' . esc_attr__('Search', 'zella-theme') . '">' .
                '<i class="nasa-icon icon-nasa-search"></i>' .
            '</a>';
            $class = !$first ? 'first ' : '';
            $first = true;
            $icons .= '<li class="' . $class . 'nasa-icon-search nasa-hide-for-mobile">' . $search_icon . '</li>';
        }
        
        $icons_wrap = ($icons != '') ? '<div class="nasa-header-icons-wrap"><ul class="header-icons">' . $icons . '</ul></div>' : '';
        
        return apply_filters('nasa_header_icons', $icons_wrap);
    }
endif;

// **********************************************************************// 
// ! Get header builder custom
// **********************************************************************//
if(!function_exists('zella_header_builder')) :
    function zella_header_builder($header_slug) {
        if(!empty($header_slug)) {
            $args = array(
                'name' => $header_slug,
                'posts_per_page' => 1,
                'post_type' => 'header',
                'post_status' => 'publish'
            );

            $headers_type = get_posts($args);
            $header = isset($headers_type[0]) ? $headers_type[0] : null;
            $header_id = isset($header->ID) ? (int) $header->ID : null;

            if (class_exists('SitePress') && function_exists('icl_object_id') && (int) $header_id) {
                $header_langID = icl_object_id($header_id, 'header', true);
                if($header_langID && $header_langID != $header_id) {
                    $headerLang = get_post($header_langID);
                    $header = $headerLang && $headerLang->post_status == 'publish' ? $headerLang : $header;
                }
            }

            $header_builder = ($header && isset($header->post_content)) ? do_shortcode($header->post_content) : '';

            $file = ZELLA_CHILD_PATH . '/headers/header-builder.php';
            include is_file($file) ? $file : ZELLA_THEME_PATH . '/headers/header-builder.php';
        }
    }
endif;

// **********************************************************************// 
// ! Mobile account menu
// **********************************************************************//
if (!function_exists('zella_header_topbar')) :

    function zella_header_topbar($hstructure = '1') {
        global $wp_query, $nasa_opt;
        
        $hstructure = !in_array((int) $hstructure, array(1, 2, 3, 4, 5, 6)) ? 1 : (int) $hstructure;
        $nasa_topbar_icons = in_array((int) $hstructure, array(1, 2, 3)) ? zella_header_icons_topbar() : '';
        $file = ZELLA_CHILD_PATH . '/headers/top-bar-' . ((int) $hstructure) . '.php';
        include is_file($file) ? $file : ZELLA_THEME_PATH . '/headers/top-bar-' . ((int) $hstructure) . '.php';
    }

endif;

/**
 * Group icons topbar
 */
if (!function_exists('zella_header_icons_topbar')) :
    function zella_header_icons_topbar() {
        $icons = '';
        
        // Search icon
        $search_icon = 
        '<a class="search-icon topbar-desk-search" href="javascript:void(0);" title="' . esc_attr__('Search', 'zella-theme') . '">' .
            '<i class="nasa-icon icon-nasa-search"></i>' .
        '</a>';
        $icons .= '<li class="first nasa-icon-search nasa-hide-for-mobile">' . $search_icon . '</li>';
        
        // Wishlist icon
        $nasa_icon_wishlist = zella_icon_wishlist();
        $icons .= $nasa_icon_wishlist ? '<li class="nasa-icon-wishlist">' . $nasa_icon_wishlist . '</li>' : '';
        
        // Compare icon
        $nasa_icon_compare = zella_icon_compare();
        $icons .= $nasa_icon_compare ? '<li class="nasa-icon-compare">' . $nasa_icon_compare . '</li>' : '';
        
        $icons_wrap = '<ul class="header-icons">' . $icons . '</ul>';
        
        return apply_filters('nasa_header_icons_topbar', $icons_wrap);
    }
endif;

// **********************************************************************// 
// ! Mobile account menu
// **********************************************************************//
if (!function_exists('zella_mobile_account')) :

    function zella_mobile_account() {
        $file = ZELLA_CHILD_PATH . '/includes/nasa-mobile-account.php';
        require is_file($file) ? $file : ZELLA_THEME_PATH . '/includes/nasa-mobile-account.php';
    }

endif;