<?php

if (!function_exists('zella_primary_color')) :

    function zella_primary_color($color_primary = '', $return = true) {
        if (trim($color_primary) == '') {
            return '';
        }
        if ($return) {
            ob_start();
        }
        ?><style>
            /* Start override primary color =========================================== */
            body .primary-color,
            body a:hover,
            body p a,
            body p a:hover,
            body .add-to-cart-grid .cart-icon strong,
            body .navigation-paging a,
            body .navigation-image a,
            body #header-outer-wrap .mobile-menu a,
            body .logo a,
            body li.mini-cart .cart-icon strong,
            body #header-outer-wrap .mobile-menu a.mobile-menu a,
            body .checkout-group h3,
            body .order-review h3,
            body #yith-searchsubmit .icon-search,
            body .mini-cart-item .cart_list_product_price,
            body .remove:hover i,
            body .support-icon,
            body .entry-meta a,
            body #order_review_heading,
            body .checkout-group h3,
            body .shop_table.cart td.product-name a,
            body a.shipping-calculator-button,
            body .widget_layered_nav li a:hover,
            body .widget_layered_nav_filters li a:hover,
            body .product_list_widget .text-info span,
            body .copyright-footer span,
            body #menu-shop-by-category li.active.menu-parent-item .nav-top-link::after,
            body .product_list_widget .product-title:hover,
            body .item-product-widget .product-meta .product-title a:hover,
            body .bread.nasa-breadcrumb-has-bg .row .breadcrumb-row a:hover,
            body .bread.nasa-breadcrumb-has-bg .columns .breadcrumb-row a:hover,
            body .group-blogs .blog_info .post-date span,
            body .header-type-1 ul.header-nav li a.nav-top-link:hover,
            body .widget_layered_nav li:hover a,
            body .widget_layered_nav_filters li:hover a,
            body .remove .icon-close:hover,
            body .absolute-footer .left .copyright-footer span,
            body .service-block .box .title .icon,
            body .service-block.style-3 .box .service-icon,
            body .contact-information .contact-text strong,
            body .nav-wrapper .header-nav li.root-item a:hover,
            body .group-blogs .blog_info .read_more a:hover,
            body .mini-cart .nav-dropdown .cart_list .mini-cart-item .mini-cart-info .cart_list_product_quantity,
            body #top-bar .top-bar-nav li.color a,
            body .mini-cart.mini-cart-type-full .cart-link .cart-icon:hover:before,
            body .mini-cart-type-simple .cart-link .cart-icon:hover:before,
            body .absolute-footer li a:hover,
            body .nasa-recent-posts li .post-date,
            body .nasa-recent-posts .read-more a,
            body .team-member .member-details h3,
            body .shop_table .remove-product .icon-close:hover,
            body .absolute-footer ul.menu li a:hover,
            body .vertical-menu h4.section-title:before,
            body .nasa-pagination.style-1 .page-number li span.current,
            body .nasa-pagination.style-1 .page-number li a.current,
            body .nasa-pagination.style-1 .page-number li a.nasa-current,
            body .nasa-pagination.style-1 .page-number li a:hover,
            body #vertical-menu-wrapper li.root-item:hover > a,
            body .widget.woocommerce li.cat-item a.nasa-active,
            body .widget.widget_recent_entries ul li a:hover,
            body .widget.widget_recent_comments ul li a:hover,
            body .widget.widget_meta ul li a:hover,
            body .widget.widget_categories li a.nasa-active,
            body .widget.widget_archive li a.nasa-active,
            body .nasa-filter-by-cat.nasa-active,
            body .nasa-table-search-wrapper tr td .nasa-root-cat-topbar-warp .nasa-root-cat li:hover a,
            body .nasa-table-search-wrapper tr td .nasa-root-cat-topbar-warp .nasa-root-cat li:hover a:before,
            body .nasa-table-search-wrapper tr td .nasa-root-cat-topbar-warp .nasa-root-cat li a.nasa-active,
            body .nasa-table-search-wrapper tr td .nasa-root-cat-topbar-warp .nasa-root-cat li a.nasa-active:before,
            body .widget .nasa-tag-cloud-ul li a:hover,
            body .widget .nasa-tag-cloud-ul li a.nasa-active:hover,
            body .product-info .stock.in-stock,
            body #nasa-footer .nasa-contact-footer-custom h5,
            body #nasa-footer .nasa-contact-footer-custom h5 i,
            body .group-blogs .nasa-blog-info-slider .nasa-post-date,
            body li.menu-item.nasa-megamenu > .nav-dropdown > .div-sub > ul > li.menu-item a:hover,
            body .nasa-tag-cloud a.nasa-active:hover,
            body .html-text i,
            body ul.header-nav li.active a.nav-top-link,
            body ul li .nav-dropdown > ul > li:hover > a,
            body ul li .nav-dropdown > ul > li:hover > a:before,
            body ul li .nav-dropdown > ul > li .nav-column-links > ul > li a:hover,
            body ul li .nav-dropdown > ul > li .nav-column-links > ul > li:hover > a:before,
            body .topbar-menu-container ul li a:hover,
            body .header-account ul li a:hover,
            body .header-icons > li a:hover i,
            body .nasa-title span.nasa-first-word,
            body .nasa-tabs-content.nasa-slide-style .nasa-tabs li.active a h5,
            body .woocommerce-tabs.nasa-slide-style .nasa-tabs li.active a h5,
            body .nasa-sc-pdeal.nasa-sc-pdeal-block .nasa-sc-p-img .images-popups-gallery a.product-image .nasa-product-label-stock .label-stock,
            body .nasa-sc-pdeal.nasa-sc-pdeal-block .nasa-sc-p-info .nasa-sc-p-title h3 a:hover,
            body #nasa-footer .nasa-footer-contact .wpcf7-form label span.your-email:after,
            body #nasa-footer .widget_nav_menu ul li a:hover,
            body #nasa-footer .nasa-footer-bottom .widget_nav_menu ul li a:hover,
            body #nasa-footer .nasa-nav-sc-menu ul li a:hover,
            body #nasa-footer .nasa-footer-bottom .nasa-nav-sc-menu ul li a:hover,
            body .owl-carousel .owl-nav div:hover,
            body .item-product-widget.nasa-list-type-2 .product-meta .product-interactions .btn-wishlist .btn-link:hover .wishlist-icon,
            body .item-product-widget.nasa-list-type-2 .product-meta .product-interactions .btn-wishlist .btn-link:hover .quick-view-icon,
            body .item-product-widget.nasa-list-type-2 .product-meta .product-interactions .quick-view .btn-link:hover .wishlist-icon,
            body .item-product-widget.nasa-list-type-2 .product-meta .product-interactions .quick-view .btn-link:hover .quick-view-icon,
            body .item-product-widget.nasa-list-type-2 .product-meta .product-title a:hover,
            body #nasa-wishlist-sidebar .wishlist_sidebar .wishlist_table tbody tr .product-wishlist-info .info-wishlist .nasa-wishlist-title a:hover,
            body #nasa-wishlist-sidebar .wishlist_sidebar .wishlist_table tbody tr .product-remove a:hover i,
            body #nasa-cart-sidebar .widget_shopping_cart_content .cart_list .mini-cart-item .mini-cart-info a:hover,
            body #nasa-cart-sidebar .widget_shopping_cart_content .cart_list .mini-cart-item .item-in-cart:hover i,
            body .mini-cart.mini-cart-type-simple .cart-link .cart-icon:hover:before,
            body .nasa-table-compare tr.stock td span,
            body .nasa-wrap-table-compare .nasa-table-compare tr.stock td span,
            body .item-product-widget.nasa-list-type-extra .product-meta .product-interactions .btn-wishlist-main-list:hover .pe-icon,
            body .item-product-widget.nasa-list-type-extra .product-meta .product-interactions .btn-wishlist-main-list:hover .nasa-icon,
            body .item-product-widget.nasa-list-type-main .product-interactions .btn-wishlist:hover .pe-icon,
            body .item-product-widget.nasa-list-type-main .product-interactions .btn-wishlist:hover .nasa-icon,
            body .nasa-login-register-warper #nasa-login-register-form .nasa-switch-form a,
            body .vertical-menu-container #vertical-menu-wrapper li.root-item:hover > a,
            body .vertical-menu-container .vertical-menu-wrapper li.root-item:hover > a,
            body .vertical-menu-container #vertical-menu-wrapper li.root-item:hover > a > i,
            body .vertical-menu-container .vertical-menu-wrapper li.root-item:hover > a > i,
            body #nasa-cart-sidebar .wishlist_sidebar .wishlist_table tbody tr .product-wishlist-info .info-wishlist .add-to-cart-wishlist .button-in-wishlist:hover,
            body #nasa-wishlist-sidebar .wishlist_sidebar .wishlist_table tbody tr .product-wishlist-info .info-wishlist .add-to-cart-wishlist .button-in-wishlist:hover,
            body .vertical-menu:hover h5.section-title span,
            body .vertical-menu:hover h5.section-title:before,
            body .topbar-menu-container .header-icons > li > a:hover .wishlist-number .nasa-text,
            body .topbar-menu-container .header-icons > li > a:hover .compare-number .nasa-text,
            body .header-type-1 #top-bar .topbar-menu-container ul li a:hover .wishlist-number .nasa-text,
            body .header-type-1 #top-bar .topbar-menu-container ul li a:hover .compare-number .nasa-text,
            body .header-type-1 #top-bar .header-icons > li a:hover .nasa-sl,
            body .product-item .info .name:hover,
            body .product-item .product-img-wrap .nasa-product-content-nasa_label-wrap .nasa-product-content-child > a.nasa-active,
            body .nasa-compare-list-bottom .nasa-compare-mess,
            body .tparrows:hover:before,
            body .nasa-labels-filter-top .nasa-labels-filter-accordion .nasa-top-row-filter > li.nasa-active a,
            body .nasa-wrap-slick-slide-products-title .nasa-slide-products-title-item.slick-current > a,
            body #nasa-footer .nasa-banner-gmap .banner-inner p a,
            body #nasa-footer .nasa-contact-footer-zella-2 .wpcf7 .btn-submit-newsletters,
            body .nasa-static-sidebar .wishlist_sidebar .wishlist_table .nasa-tbody .nasa-tr-wishlist-item .product-wishlist-info .info-wishlist .add-to-cart-wishlist .button-in-wishlist:hover,
            body .nasa-topbar-wrap-content-default .nasa-widget-avatar.nasa-widget-reset-filter .nasa-reset-filters-btn:hover,
            body article.post .entry-meta .meta-author a
            {
                color: <?php echo esc_attr($color_primary); ?>;
            }
            .blog_shortcode_item .blog_shortcode_text h3 a:hover,
            .main-navigation li.menu-item a:hover,
            .widget-area ul li a:hover,
            h1.entry-title a:hover,
            .progress-bar .bar-meter .bar-number,
            .product-item .info .name a:hover,
            .wishlist_table td.product-name a:hover,
            .product_list_widget .text-info a:hover,
            .product-list .info .name:hover,
            .product-info .compare:hover,
            .product-info .compare:hover:before,
            .product-info .yith-wcwl-add-to-wishlist:hover:before,
            .product-info .yith-wcwl-add-to-wishlist:hover a,
            .product-info .yith-wcwl-add-to-wishlist:hover .feedback,
            li.menu-item.nasa-megamenu > .nav-dropdown > .div-sub > ul > li.menu-item a:hover:before,
            #nasa-footer .widget_tag_cloud .nasa-tag-cloud a:hover,
            #nasa-footer .widget_tag_cloud .nasa-tag-cloud a.nasa-active,
            #nasa-footer .widget_tag_cloud .nasa-tag-products-cloud a:hover,
            #nasa-footer .widget_tag_cloud .nasa-tag-products-cloud a.nasa-active,
            ul.main-navigation li .nav-dropdown > ul > li .nav-column-links > ul > li a:hover,
            .nasa-table-search-wrapper tr td .nasa-root-cat-topbar-warp .nasa-root-cat li:hover a,
            rev-btn.zella-Button
            {
                color: <?php echo esc_attr($color_primary); ?> !important;
            }
            body .service-block.style-3 .box .service-icon
            {
                -webkit-text-stroke: 1px <?php echo esc_attr($color_primary); ?>;
            }
            /* BACKGROUND */
            body .tabbed-content.pos_pills ul.tabs li.active a,
            body li.featured-item.style_2:hover a,
            body .nasa_hotspot,
            body .label-new.menu-item a:after,
            body .text-box-primary,
            body .navigation-paging a:hover,
            body .navigation-image a:hover,
            body .next-prev-nav .prod-dropdown > a:hover,
            body .widget_product_tag_cloud a:hover,
            body .nasa-tag-cloud a.nasa-active,
            body .custom-cart-count,
            body a.button.trans-button:hover,
            body .please-wait i,
            body li.mini-cart .cart-icon .cart-count,
            body .product-img .product-bg,
            body #submit:hover,
            body button:hover,
            body #submit:hover,
            body button:hover,
            body input[type="submit"]:hover,
            body .post-item:hover .post-date,
            body .blog_shortcode_item:hover .post-date,
            body .group-slider .sliderNav a:hover,
            body .support-icon.square-round:hover,
            body .entry-header .post-date-wrapper,
            body .entry-header .post-date-wrapper:hover,
            body .comment-inner .reply a:hover,
            /* body .social-icons .icon.icon_email:hover, */
            body .widget_collapscat h3,
            body ul.header-nav li a.nav-top-link::before,
            body .sliderNav a span:hover,
            body .shop-by-category h3.section-title,
            body ul.header-nav li a.nav-top-link::before,
            body .custom-footer-1 .nasa-hr,
            body .products.list .product-interactions .yith-wcwl-add-button:hover,
            body ul.header-nav li a.nav-top-link::before,
            body .widget_collapscat h2,
            body .shop-by-category h2.widgettitle,
            body .rev_slider_wrapper .type-label-2,
            body .nasa-hr.primary-color,
            body .products.list .product-interactions .yith-wcwl-add-button:hover,
            body .pagination-centered .page-numbers a:hover,
            body .pagination-centered .page-numbers span.current,
            body .cart-wishlist .mini-cart .cart-link .cart-icon .products-number,
            body .load-more::before,
            body .products-arrow .next-prev-buttons .icon-next-prev:hover,
            body .widget_price_filter .ui-slider .ui-slider-handle:after,
            body #under-top-bar .header-icons li .products-number .nasa-sl,
            body #under-top-bar .header-icons li .wishlist-number .nasa-sl,
            body #under-top-bar .header-icons li .compare-number .nasa-sl,
            body .nasa-tabs-content .nasa-tabs li.active .nasa-hr,
            body .nasa-tabs-content .nasa-tabs li:hover .nasa-hr,
            body .woocommerce-tabs .nasa-tabs li.active .nasa-hr,
            body .woocommerce-tabs .nasa-tabs li:hover .nasa-hr,
            body .collapses.active .collapses-title a:before,
            body .title-block .heading-title span:after,
            body .mini-cart.mini-cart-type-full .cart-link .products-number .nasa-sl,
            body .mini-cart.mini-cart-type-simple .cart-link .products-number .nasa-sl,
            body .header-icons > li .products-number .nasa-sl,
            body .header-icons > li .wishlist-number .nasa-sl,
            body .header-icons > li .compare-number .nasa-sl,
            body .nasa-login-register-warper #nasa-login-register-form .login-register-close a:hover i:before,
            body .products-group.nasa-combo-slider .product-item.grid .nasa-product-bundle-btns .quick-view:hover,
            body .header-type-1 .nasa-header-icons-type-1 .header-icons > li.nasa-icon-mini-cart a .icon-nasa-cart-3,
            body .header-type-1 .nasa-header-icons-type-1 .header-icons > li.nasa-icon-mini-cart a:hover .icon-nasa-cart-3,
            body .header-type-1 .nasa-header-icons-type-1 .header-icons > li.nasa-icon-mini-cart a .icon-nasa-cart-3:hover:before,
            body .search-dropdown.nasa-search-style-3 .nasa-show-search-form .search-wrapper form .nasa-icon-submit-page:before,
            body .nasa-search-space.nasa-search-style-3 .nasa-show-search-form .search-wrapper form .nasa-icon-submit-page:before,
            body .product_list_widget .product-interactions .quick-view:hover,
            body #nasa-cart-sidebar.style-1 a.nasa-sidebar-return-shop:hover,
            body #nasa-wishlist-sidebar.style-1 a.nasa-sidebar-return-shop:hover,
            body #nasa-cart-sidebar .widget_shopping_cart_content .btn-mini-cart a.btn-viewcart,
            body #nasa-cart-sidebar .widget_shopping_cart_content .btn-mini-cart a.btn-viewcart:hover,
            body .nasa-gift-featured-wrap .nasa-gift-featured-event:hover,
            body #nasa-popup .wpcf7 input[type="button"],
            body #nasa-popup .wpcf7 input[type="submit"],
            body #nasa-popup .wpcf7 input[type="button"]:hover,
            body #nasa-popup .wpcf7 input[type="submit"]:hover,
            body .nasa-products-special-deal .product-special-deals .product-deal-special-progress .deal-progress .deal-progress-bar,
            body .badge .badge-inner,
            body .badge-inner,
            body .item-product-widget.row.nasa-list-type-1 .images .nasa-product-widget-image-wrap .product-interactions .quick-view:hover,
            body .product-item.nasa-type-2 .product-img-wrap .nasa-product-grid .product-summary .product-interactions .add-to-cart-btn .btn-link,
            body .owl-carousel .owl-dots .owl-dot.active span,
            body .nasa-loader .nasa-line,
            body .nasa-products-page-wrap .nasa-progress-bar-load-shop .nasa-progress-per,
            body .product-info .cart .single_add_to_cart_button:hover,
            body #nasa-footer .footer-contact .btn-submit-newsletters,
            body .easypin-marker > .nasa-marker-icon-wrap .nasa-marker-icon-bg,
            body .easypin-marker > .nasa-marker-icon-wrap .nasa-action-effect,
            body .vertical-menu.nasa-shortcode-menu .section-title,
            body .tp-bullets .tp-bullet.selected
            body #submit.small.nasa-button-banner,
            body button.small.nasa-button-banner,
            body .button.small.nasa-button-banner,
            body input[type="submit"].small.nasa-button-banner,
            body .header-type-1 #top-bar .topbar-menu-container .header-icons > li a .wishlist-number .nasa-sl,
            body .header-type-1 #top-bar .topbar-menu-container .header-icons > li a .compare-number .nasa-sl, .header-type-2 #top-bar .topbar-menu-container .header-icons > li a .wishlist-number .nasa-sl,
            body .header-type-2 #top-bar .topbar-menu-container .header-icons > li a .compare-number .nasa-sl, .header-type-3 #top-bar .topbar-menu-container .header-icons > li a .wishlist-number .nasa-sl,
            body .header-type-3 #top-bar .topbar-menu-container .header-icons > li a .compare-number .nasa-sl,
            body .product-info .nasa-buy-now,
            body .nasa-single-product-stock .nasa-product-stock-progress .nasa-product-stock-progress-bar,
            body .nasa-header-sticky.header-type-1 .sticky-wrapper.fixed-already .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .cart-link .products-number .nasa-sl,
            body .nasa-header-sticky.header-type-2 .sticky-wrapper.fixed-already .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .cart-link .products-number .nasa-sl,
            body .nasa-header-sticky.header-type-3 .sticky-wrapper.fixed-already .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .cart-link .products-number .nasa-sl,
            body .nasa-save-price
            {
                background-color: <?php echo esc_attr($color_primary); ?>;
            }
            body .product-item .product-img-wrap .nasa-product-grid .product-summary .product-interactions .add-to-cart-btn .btn-link .add-to-cart-grid .add_to_cart_text
            {
                color: #fff;
            }
            .button.trans-button.primary,
            button.primary-color,
            .newsletter-button-wrap .newsletter-button,
            body .easypin-marker > .nasa-marker-icon-wrap .nasa-marker-icon-bg:hover
            {
                background-color: <?php echo esc_attr($color_primary); ?> !important;
            }
            body .search-dropdown .nasa-show-search-form .search-wrapper form select[name="product_cat"],
            body .nasa-search-space .nasa-show-search-form .search-wrapper form select[name="product_cat"]
            {
                background-image: linear-gradient(45deg, transparent 50%, <?php echo esc_attr($color_primary); ?> 50%), linear-gradient(135deg, <?php echo esc_attr($color_primary); ?> 50%, transparent 50%);
            }
            body .search-dropdown .nasa-show-search-form .search-wrapper form select[name="product_cat"]:focus,
            body .nasa-search-space .nasa-show-search-form .search-wrapper form select[name="product_cat"]:focus
            {
                background-image: linear-gradient(45deg, <?php echo esc_attr($color_primary); ?> 50%, transparent 50%), linear-gradient(135deg, transparent 50%, <?php echo esc_attr($color_primary); ?> 50%);
            }
            /* BORDER COLOR */
            body .text-bordered-primary,
            body .add-to-cart-grid .cart-icon-handle,
            body .add-to-cart-grid.please-wait .cart-icon strong,
            body .navigation-paging a,
            body .navigation-image a,
            body .post.sticky,
            body .next-prev-nav .prod-dropdown > a:hover,
            body .iosSlider .sliderNav a:hover span,
            body .woocommerce-checkout form.login,
            body li.mini-cart .cart-icon strong,
            body li.mini-cart .cart-icon .cart-icon-handle,
            body .post-date,
            body .main-navigation .nav-dropdown ul,
            body .remove:hover i,
            body .support-icon.square-round:hover,
            body .widget_price_filter .ui-slider .ui-slider-handle,
            body h3.section-title span,
            body .social-icons .icon.icon_email:hover,
            body .button.trans-button.primary,
            body .seam_icon .seam,
            body .border_outner,
            body .pagination-centered .page-numbers a:hover,
            body .pagination-centered .page-numbers span.current,
            body .owl-carousel .owl-nav div:hover,
            body .products.list .product-interactions .yith-wcwl-wishlistexistsbrowse a,
            body li.menu-item.nasa-megamenu > .nav-dropdown > .div-sub > ul > li.menu-item.megatop > hr.hr-nasa-megamenu,
            body .owl-carousel .owl-dots .owl-dot.active,
            body .owl-carousel .owl-dots .owl-dot.active:hover,
            body .products-arrow .next-prev-buttons .icon-next-prev:hover,
            body .search-dropdown .nasa-show-search-form .search-wrapper form .nasa-icon-submit-page,
            body .nasa-search-space .nasa-show-search-form .search-wrapper form .nasa-icon-submit-page,
            body .item-product-widget.nasa-list-type-2:hover,
            body .products-group.nasa-combo-slider .product-item.grid .nasa-product-bundle-btns .quick-view:hover,
            body .nasa-table-compare tr.stock td span,
            body .nasa-tabs-content.nasa-slide-style .nasa-tabs li.nasa-slide-tab,
            body .woocommerce-tabs.nasa-slide-style .nasa-tabs li.nasa-slide-tab,
            body .nasa-wrap-table-compare .nasa-table-compare tr.stock td span,
            body .nasa-table-search-wrapper tr td .nasa-root-cat-topbar-warp .nasa-root-cat li:hover:before,
            body .vertical-menu-container #vertical-menu-wrapper li.root-item:hover > a:before,
            body .vertical-menu-container .vertical-menu-wrapper li.root-item:hover > a:before,
            body .product_list_widget .product-interactions .quick-view:hover,
            body #nasa-cart-sidebar.style-1 a.nasa-sidebar-return-shop:hover,
            body #nasa-wishlist-sidebar.style-1 a.nasa-sidebar-return-shop:hover,
            body #nasa-cart-sidebar .widget_shopping_cart_content .btn-mini-cart a.btn-viewcart,
            body .nasa-gift-featured-wrap .nasa-gift-featured-event:hover,
            body #nasa-wishlist-sidebar .wishlist_sidebar .wishlist_table tbody tr .product-wishlist-info .info-wishlist .add-to-cart-wishlist .button-in-wishlist:hover .add_to_cart_text,
            body .products.list .product-warp-item .inner-wrap .group-btn-in-list-wrap .group-btn-in-list .product-summary .product-interactions .add-to-cart-btn:hover .add-to-cart-grid .add_to_cart_text,
            body .nasa-title.hr-type-vertical .nasa-wrap,
            body .product-info .cart .single_add_to_cart_button:hover,
            body .product-info .nasa-buy-now,
            body #nasa-footer .footer-contact .btn-submit-newsletters,
            body .easypin-marker > .nasa-marker-icon-wrap .nasa-marker-icon-bg,
            body .easypin-marker > .nasa-marker-icon-wrap .nasa-marker-icon,
            body .vertical-menu.nasa-shortcode-menu .section-title,
            body .nasa-static-sidebar .wishlist_sidebar .wishlist_table .nasa-tbody .nasa-tr-wishlist-item .product-wishlist-info .info-wishlist .add-to-cart-wishlist .button-in-wishlist:hover,
            body .nasa-title.hr-type-under .nasa-heading-title .nasa-title-wrap .nasa-title-hr:before
            {
                border-color: <?php echo esc_attr($color_primary); ?>;
            }
            .promo .sliderNav span:hover,
            .remove .icon-close:hover
            {
                border-color: <?php echo esc_attr($color_primary); ?> !important;
            }
            body .tabbed-content ul.tabs li a:hover:after,
            body .tabbed-content ul.tabs li.active a:after
            {
                border-top-color: <?php echo esc_attr($color_primary); ?>;
            }
            .collapsing.categories.list li:hover,
            .please-wait,
            #menu-shop-by-category li.active
            {
                border-left-color: <?php echo esc_attr($color_primary); ?> !important;
            }
            body form.cart .button:hover,
            body a.primary.trans-button:hover,
            body .form-submit input:hover,
            body #payment .place-order input:hover,
            body input#submit:hover,
            body .add-to-cart-grid-style2:hover,
            body .add-to-cart-grid-style2.added,
            body .add-to-cart-grid-style2.loading,
            body .product-list .product-img .quick-view.fa-search:hover,
            body .footer-type-2 input.button,
            body button:hover,
            body .button:hover,
            body .cart-inner .button.secondary:hover,
            body .checkout-button:hover,
            body input#place_order:hover,
            body .btn-viewcart:hover,
            body input#submit:hover,
            body .add-to-cart-grid-style2:hover,
            body .add_to_cart:hover
            {
                background-color: <?php echo esc_attr($color_primary); ?>;
                border-color: <?php echo esc_attr($color_primary); ?>;
                color: #FFF;
            }

            /* For mobile */
            @media only screen and (max-width: 59.07692em) {
                html body .product-item .info .product-summary {
                    background-color: <?php echo esc_attr($color_primary); ?>;
                }
            }
            /* End Primary color =========================================== */
        </style>
        <?php
        if ($return) {
            $css = ob_get_clean();
            return zella_convert_css($css);
        }
    }

endif;

/**
 * CSS override color for main menu
 */
if (!function_exists('zella_main_menu_color')) :

    function zella_main_menu_color($bg_color = '', $text_color = '', $text_color_hover = '', $return = true) {
        if ($bg_color == '' && $text_color == '' && $text_color_hover == '') {
            return '';
        }

        if ($return) {
            ob_start();
        }
        ?><style>
            /* Start override main menu color =========================================== */
        <?php if ($bg_color != '') : ?>
                body .nasa-bg-dark
                {
                    background-color: <?php if($bg_color != '0'): echo esc_attr($bg_color); else: echo 'transparent'; endif; ?>;
                }
                <?php
            endif;

            if ($text_color != '') :
                ?>
                body .nav-wrapper .header-nav .root-item > a,
                body .nasa-bg-wrap .nasa-vertical-header h5.section-title span,
                body .nasa-bg-wrap .nasa-vertical-header h5.section-title:before,
                body .nav-wrapper .header-nav li.root-item:hover > a,
                body .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a,
                body .nav-wrapper .header-nav li.root-item.current-menu-item > a,
                body .nav-wrapper .header-nav li.root-item:hover > a:hover,
                body .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a:hover,
                body .nav-wrapper .header-nav li.root-item.current-menu-item > a:hover,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item > a,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item:hover > a,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-item > a,
                body .header-type-2 .nasa-bg-dark .nav-wrapper .header-nav li.root-item > a,
                body .header-type-2 .nasa-bg-dark .nav-wrapper .header-nav li.root-item:hover > a,
                body .header-type-2 .nasa-bg-dark .nav-wrapper .header-nav li.root-item:hover > a:hover,
                body .header-type-2 .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-item > a,
                body .header-type-3 .nasa-menus-account-wrap .nasa-menus-account > li > a,
                body .nasa-search-space .nasa-show-search-form .search-wrapper form .nasa-icon-submit-page:before,
                body .nasa-search-space .nasa-show-search-form .search-wrapper form .twitter-typeahead input[name="s"],
                body .nasa-search-space .nasa-show-search-form .nasa-close-search i
                {
                    color: <?php echo esc_attr($text_color); ?>;
                }
                body .nav-wrapper .header-nav li.root-item > a .nasa-text-menu:after,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item:hover > a .nasa-text-menu:after,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a .nasa-text-menu:after,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-item > a .nasa-text-menu:after,
                body .header-type-2 .nasa-bg-dark .nav-wrapper .header-nav li.root-item:hover > a .nasa-text-menu:after,
                body .header-type-2 .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a .nasa-text-menu:after,
                body .header-type-2 .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-item > a .nasa-text-menu:after
                {
                    border-color: <?php echo esc_attr($text_color); ?>;
                }
                <?php
            endif;

            if ($text_color_hover != '') :
                ?>
                body .nav-wrapper .header-nav .root-item > a:hover,
                body .nav-wrapper .header-nav li.root-item:hover > a,
                body .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a,
                body .nav-wrapper .header-nav li.root-item.current-menu-item > a,
                body .nav-wrapper .header-nav li.root-item:hover > a:hover,
                body .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a:hover,
                body .nav-wrapper .header-nav li.root-item.current-menu-item > a:hover,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item > a,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item:hover > a,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-ancestor > a,
                body .nasa-bg-dark .nav-wrapper .header-nav li.root-item.current-menu-item > a,
                body .header-type-3 .nasa-menus-account-wrap .nasa-menus-account li > a,
                body .nasa-header-sticky.header-type-1 .sticky-wrapper.fixed-already .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .nasa-icon-search a:hover,
                body .nasa-header-sticky.header-type-2 .sticky-wrapper.fixed-already .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .nasa-icon-search a:hover,
                body .nasa-header-sticky.header-type-3 .sticky-wrapper.fixed-already .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .nasa-icon-search a:hover
                {
                    color: <?php echo esc_attr($text_color); ?>;
                }
            <?php
        endif;
        ?>
            /* End =========================================== */
        </style>
        <?php
        if ($return) {
            $css = ob_get_clean();
            return zella_convert_css($css);
        }
    }

endif;

/**
 * CSS override color for header
 */
if (!function_exists('zella_header_color')) :

    function zella_header_color($bg_color = '', $text_color = '', $text_color_hover = '', $return = true) {
        if ($bg_color == '' && $text_color == '' && $text_color_hover == '') {
            return '';
        }

        if ($return) {
            ob_start();
        }
        ?><style>
            /* Start override header color =========================================== */
            <?php if ($bg_color != '') : ?>
                body #masthead,
                body .nasa-header-sticky.nasa-header-mobile-layout.nasa-header-transparent .sticky-wrapper.fixed-already #masthead
                {
                    background-color: <?php echo esc_attr($bg_color); ?>;
                }
            <?php
        endif;

        if ($text_color != '') :
            ?>
                body #masthead .nasa-follow .icon,
                body #masthead .header-icons > li a,
                body #masthead .header-icons > li .mini-cart.mini-cart-type-full .cart-link .cart-count,
                body .header-type-1 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .products-number .nasa-sl,
                body .header-type-2 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .products-number .nasa-sl,
                body .header-type-3 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .products-number .nasa-sl,
                body .mobile-menu .mini-icon-mobile a
                {
                    color: <?php echo esc_attr($text_color); ?>;
                }
                body #masthead .header-icons > li .mini-cart.mini-cart-type-full .cart-link .cart-count .amount,
                body .header-type-1 #masthead .nasa-header-icons-type-1 .header-icons > li .mini-cart.mini-cart-type-full .cart-link .products-number span
                {
                    color: <?php echo esc_attr($text_color); ?> !important;
                }
                
                body .header-type-1 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .cart-link,
                body .header-type-2 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .cart-link,
                body .header-type-3 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart .cart-link
                {
                    border-color: <?php echo esc_attr($text_color); ?>;
                }
                body .header-type-1 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart:hover .cart-link,
                body .header-type-2 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart:hover .cart-link,
                body .header-type-3 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart:hover .cart-link
                {
                    border-color: <?php echo esc_attr($text_color); ?>;
                }
                <?php
            endif;

            if ($text_color_hover != '') :
                ?>
                body #masthead .header-icons > li a:hover i,
                body #masthead .mini-cart.mini-cart-type-full .cart-link .cart-icon:hover:before
                {
                    color: <?php echo esc_attr($text_color_hover); ?>;
                }
                html body .header-type-1 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart:hover .cart-link,
                html body .header-type-2 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart:hover .cart-link,
                html body .header-type-3 .site-header .nasa-site-header-desktop .nasa-header-icons-wrap .header-icons > li.nasa-icon-mini-cart:hover .cart-link
                {
                    border-color: <?php echo esc_attr($text_color_hover); ?>;
                }
            <?php
        endif;
        ?>
            /* End =========================================== */
        </style>
        <?php
        if ($return) {
            $css = ob_get_clean();
            return zella_convert_css($css);
        }
    }

endif;

/**
 * CSS override color for TOP BAR
 */
if (!function_exists('zella_topbar_color')) :

    function zella_topbar_color($bg_color = '', $text_color = '', $text_color_hover = '', $return = true) {
        if ($bg_color == '' && $text_color == '' && $text_color_hover == '') {
            return '';
        }

        if ($return) {
            ob_start();
        }
        ?><style>
            /* Start override =========================================== */
        <?php if ($bg_color != '') : ?>
                body #top-bar,
                body .nasa-topbar-wrap.nasa-topbar-toggle .nasa-icon-toggle
                {
                    background-color: <?php echo esc_attr($bg_color); ?>;
                }
                body #top-bar,
                body .nasa-topbar-wrap.nasa-topbar-toggle .nasa-icon-toggle
                {
                    border-color: <?php echo esc_attr($bg_color); ?>;
                }
            <?php
        endif;

        if ($text_color != '') :
            ?>
                body #top-bar,
                body #top-bar .topbar-menu-container > ul > li:after,
                body #top-bar .topbar-menu-container > ul > li > a,
                body #top-bar .topbar-menu-container > ul > li .nasa-show-compare,
                body #top-bar .topbar-menu-container > ul > li .wcml-cs-item-toggle,
                body #top-bar .topbar-menu-container > ul > li > a > .pe7-icon,
                body #top-bar .nasa-menus-account > li > a,
                body #top-bar .nasa-menus-account > li > a > .nasa-icon,
                body #top-bar .left-text,
                body .nasa-topbar-wrap.nasa-topbar-toggle .nasa-icon-toggle
                {
                    color: <?php echo esc_attr($text_color); ?>;
                }
                body .header-type-1 #top-bar .topbar-menu-container > ul > li:after,
                body .header-type-2 #top-bar .topbar-menu-container > ul > li:after,
                body .header-type-3 #top-bar .topbar-menu-container > ul > li:after
                {
                    border-color: <?php echo esc_attr($text_color); ?>;
                }
                <?php
            endif;

            if ($text_color_hover != '') :
                ?>
                body #top-bar .topbar-menu-container > ul > li > a:hover,
                body #top-bar .topbar-menu-container > ul > li > a:hover > .pe7-icon,
                body #top-bar .topbar-menu-container > ul > li > a:hover > i,
                body #top-bar .nasa-menus-account > li > a:hover,
                body #top-bar .nasa-menus-account > li > a:hover > .nasa-icon,
                body .nasa-topbar-wrap.nasa-topbar-toggle .nasa-icon-toggle:hover
                {
                    color: <?php echo esc_attr($text_color_hover); ?>;
                }
            <?php
        endif;
        ?>
            /* End =========================================== */
        </style>
        <?php
        if ($return) {
            $css = ob_get_clean();
            return zella_convert_css($css);
        }
    }

endif;

/**
 * CSS override full width Header
 */
if (!function_exists('zella_header_fullwidth')) :

    function zella_header_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start =========================================== */
            html body #header-content .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            html body .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub
            {
                max-width: <?php echo zella_str($maxWidth-120); ?>px;
                position: relative;
                left: 10px;
            }
            html body .header-type-1 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub,
            html body .header-type-4 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub
            {
                left: -50px;
            }
            html body .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
            {
                left: -<?php echo ((5422 - $maxWidth) / 2); ?>px;
            }
            @media all and (min-width: 1200px) and (max-width: <?php echo $maxWidth; ?>px) {
                html body .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    max-width: <?php echo $maxWidth; ?>px;
                    width: 100%;
                    left: 0;
                }
                html body .header-type-1 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown,
                html body .header-type-4 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    left: -60px !important;
                }
                html body .header-type-3 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    left: -50px !important;
                }
            }
            @media screen and (min-width: 1200px) {
                html body #header-content #top-bar > .row > .large-12.columns,
                html body #header-content #masthead > .row > .large-12.columns,
                html body #header-content .fixed-header > .row > .large-12.columns,
                html body #nasa-breadcrumb-site > .row > .large-12.columns
                {
                    padding-left: <?php echo NASA_PADDING_COLUMN; ?>;
                    padding-right: <?php echo NASA_PADDING_COLUMN; ?>;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

/**
 * CSS override full-width site
 */
if (!function_exists('zella_site_fullwidth')) :

    function zella_site_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start =========================================== */
            html body #main-content .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            @media screen and (min-width: 1200px) {
                html body #main-content > .section-element > .row,
                html body #main-content > div > .section-element > .row,
                html body #main-content > .container-wrap > .row,
                html body #main-content > .container-wrap > .order-steps > .row
                {
                    padding-left: <?php echo NASA_PADDING_ROW; ?>;
                    padding-right: <?php echo NASA_PADDING_ROW; ?>;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

/**
 * CSS override width Header store (Archive product page)
 */
if (!function_exists('zella_header_store_fullwidth')) :

    function zella_header_store_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start =========================================== */
            html body.nasa-page-products #header-content .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            html body.nasa-page-products .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub
            {
                max-width: <?php echo zella_str($maxWidth-120); ?>px;
                position: relative;
                left: 10px;
            }
            html body.nasa-page-products .header-type-1 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub,
            html body.nasa-page-products .header-type-4 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub
            {
                left: -50px;
            }
            html body.nasa-page-products .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
            {
                left: -<?php echo ((5422 - $maxWidth) / 2); ?>px;
            }
            @media all and (min-width: 1200px) and (max-width: <?php echo $maxWidth; ?>px) {
                html body.nasa-page-products .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    max-width: <?php echo $maxWidth; ?>px;
                    width: 100%;
                    left: 0;
                }
                html body.nasa-page-products .header-type-1 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown,
                html body.nasa-page-products .header-type-4 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    left: -60px !important;
                }
                html body.nasa-page-products .header-type-3 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    left: -50px !important;
                }
            }
            @media screen and (min-width: 1200px) {
                html body.nasa-page-products #header-content #top-bar > .row > .large-12.columns,
                html body.nasa-page-products #header-content #masthead > .row > .large-12.columns,
                html body.nasa-page-products #header-content .fixed-header > .row > .large-12.columns,
                body.nasa-page-products #nasa-breadcrumb-site > .row > .large-12.columns
                {
                    padding-left: <?php echo NASA_PADDING_COLUMN; ?>;
                    padding-right: <?php echo NASA_PADDING_COLUMN; ?>;
                }
                
                body.nasa-page-products .nasa-topbar-wrap-content-default
                {
                    padding-left: <?php echo NASA_PADDING_COLUMN; ?>;
                    padding-right: <?php echo NASA_PADDING_COLUMN; ?>;
                }
            }
            
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

/**
 * CSS override Add more width store (Shop products page)
 */
if (!function_exists('zella_store_fullwidth')) :

    function zella_store_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start =========================================== */
            html body.nasa-page-products #main-content .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            @media screen and (min-width: 1200px) {
                html body.nasa-page-products .nasa-padding-content-wrap,
                html body.nasa-page-products .nasa-with-topbar-type-2
                {
                    padding-left: <?php echo NASA_PADDING_COLUMN; ?>;
                    padding-right: <?php echo NASA_PADDING_COLUMN; ?>;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

/**
 * CSS override full width Footer Store
 */
if (!function_exists('zella_footer_store_fullwidth')) :

    function zella_footer_store_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start =========================================== */
            html body.nasa-page-products #nasa-footer .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            @media screen and (min-width: 1200px) {
                html body.nasa-page-products #nasa-footer > .section-element > .row
                {
                    padding-left: <?php echo NASA_PADDING_ROW; ?>;
                    padding-right: <?php echo NASA_PADDING_ROW; ?>;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

/**
 * CSS override Add more width single product (Single product page)
 */
if (!function_exists('zella_header_single_product_fullwidth')) :

    function zella_header_single_product_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start override topbar color =========================================== */
            html body.nasa-page-single-product #header-content .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            html body.nasa-page-single-product .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub
            {
                max-width: <?php echo zella_str($maxWidth-120); ?>px;
                position: relative;
                left: 10px;
            }
            html body.nasa-page-single-product .header-type-1 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub,
            html body.nasa-page-single-product .header-type-4 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown > .div-sub
            {
                left: -50px;
            }
            html body.nasa-page-single-product .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
            {
                left: -<?php echo ((5422 - $maxWidth) / 2); ?>px;
            }
            @media all and (min-width: 1200px) and (max-width: <?php echo $maxWidth; ?>px) {
                html body.nasa-page-single-product .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    max-width: <?php echo $maxWidth; ?>px;
                    width: 100%;
                    left: 0;
                }
                html body.nasa-page-single-product .header-type-1 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown,
                html body.nasa-page-single-product .header-type-4 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    left: -60px !important;
                }
                html body.nasa-page-single-product .header-type-3 .nav-wrapper .header-nav .menu-item.nasa-megamenu.fullwidth > .nav-dropdown
                {
                    left: -50px !important;
                }
            }
            @media screen and (min-width: 1200px) {
                html body.nasa-page-single-product #header-content #top-bar > .row > .large-12.columns,
                html body.nasa-page-single-product #header-content #masthead > .row > .large-12.columns,
                html body.nasa-page-single-product #header-content .fixed-header > .row > .large-12.columns,
                html body.nasa-page-single-product #nasa-breadcrumb-site > .row > .large-12.columns
                {
                    padding-left: <?php echo NASA_PADDING_COLUMN; ?>;
                    padding-right: <?php echo NASA_PADDING_COLUMN; ?>;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();

        return zella_convert_css($css);
    }

endif;

/**
 * CSS override Add more width single product (Single product page)
 */
if (!function_exists('zella_single_product_fullwidth')) :

    function zella_single_product_fullwidth($site_fullwidth) {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start override topbar color =========================================== */
            html body.nasa-page-single-product #main-content .row,
            html body.nasa-single-product-full-width #main-content .row .row.nasa-product-details-page > .columns > .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            @media screen and (min-width: 1200px) {
                html body.nasa-page-single-product .woocommerce-message,
                html body.nasa-page-single-product #main-content .section-element.nasa-fullwidth > .row,
                html body.nasa-single-product-full-width #main-content .row .row.nasa-product-details-page > .columns > .row
                {
                    padding-left: <?php echo NASA_PADDING_ROW; ?>;
                    padding-right: <?php echo NASA_PADDING_ROW; ?>;
                }
                html body.nasa-single-product-full-width #main-content .row .row.nasa-product-details-page > .columns > .row.row-fullwidth
                {
                    padding-left: 0;
                    padding-right: 0;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

/**
 * CSS override full width Footer Store
 */
if (!function_exists('zella_footer_single_product_fullwidth')) :

    function zella_footer_single_product_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start =========================================== */
            html body.nasa-page-single-product #nasa-footer .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            @media screen and (min-width: 1200px) {
                html body.nasa-page-single-product #nasa-footer > .section-element > .row
                {
                    padding-left: <?php echo NASA_PADDING_ROW; ?>;
                    padding-right: <?php echo NASA_PADDING_ROW; ?>;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

/**
 * CSS override full width Footer
 */
if (!function_exists('zella_footer_fullwidth')) :

    function zella_footer_fullwidth($site_fullwidth = '') {
        if ($site_fullwidth == 1) {
            $maxWidth = NASA_MAXWIDTH;
        }
        else if ($site_fullwidth == -1) {
            global $content_width;
            if (!isset($content_width)) {
                $content_width = 1200;
            }
            
            $maxWidth = $content_width;
        }
        else {
            return;
        }
        
        ob_start();
        ?><style>
            /* Start =========================================== */
            html body #nasa-footer .row
            {
                max-width: <?php echo zella_str($maxWidth); ?>px;
            }
            @media screen and (min-width: 1200px) {
                html body #nasa-footer > .section-element > .row
                {
                    padding-left: <?php echo NASA_PADDING_ROW; ?>;
                    padding-right: <?php echo NASA_PADDING_ROW; ?>;
                }
            }
            /* End =========================================== */
        </style>
        <?php
        $css = ob_get_clean();
        
        return zella_convert_css($css);
    }

endif;

// **********************************************************************// 
// ! Dynamic - css
// **********************************************************************//
add_action('wp_enqueue_scripts', 'zella_add_dynamic_css', 999);
if (!function_exists('zella_add_dynamic_css')) :

    function zella_add_dynamic_css() {
        global $nasa_upload_dir;
        
        $upload_dir = !isset($nasa_upload_dir) ? wp_upload_dir() : $nasa_upload_dir;
        $dynamic_path = $upload_dir['basedir'] . '/nasa-dynamic';
        
        if (is_file($dynamic_path . '/dynamic.css')) {
            global $nasa_opt;
            $version = isset($nasa_opt['nasa_dynamic_t']) ? $nasa_opt['nasa_dynamic_t'] : null;
            
            // Dynamic Css
            wp_enqueue_style('zella-style-dynamic', $upload_dir['baseurl'] . '/nasa-dynamic/dynamic.css', array('zella-style'), $version, 'all');
        }
    }

endif;

// **********************************************************************// 
// ! Dynamic - Page override primary color - css
// **********************************************************************//
add_action('wp_enqueue_scripts', 'zella_page_override_style', 1000);
if (!function_exists('zella_page_override_style')) :

    function zella_page_override_style() {
        if (!wp_style_is('zella-style-dynamic')) {
            return;
        }

        global $wp_query, $nasa_opt;
        if ('page' === get_post_type() && $objectId = $wp_query->get_queried_object_id()) {
            
            /**
             * color_primary
             */
            $flag_override_color = get_post_meta($objectId, '_nasa_pri_color_flag', true);
            $color_primary_css = $page_css = '';
            if ($flag_override_color) :
                $color_primary = get_post_meta($objectId, '_nasa_pri_color', true);
                $color_primary_css = $color_primary ? zella_primary_color($color_primary) : '';
            endif;

            /**
             * color for header
             */
            $bg_color = get_post_meta($objectId, '_nasa_bg_color_header', true);
            $text_color = get_post_meta($objectId, '_nasa_text_color_header', true);
            $text_color_hover = get_post_meta($objectId, '_nasa_text_color_hover_header', true);
            $page_css .= zella_header_color($bg_color, $text_color, $text_color_hover);

            /**
             * color for top bar
             */
            if (!isset($nasa_opt['topbar_show']) || $nasa_opt['topbar_show']) {
                $bg_color = get_post_meta($objectId, '_nasa_bg_color_topbar', true);
                $text_color = get_post_meta($objectId, '_nasa_text_color_topbar', true);
                $text_color_hover = get_post_meta($objectId, '_nasa_text_color_hover_topbar', true);
                $page_css .= zella_topbar_color($bg_color, $text_color, $text_color_hover);
            }

            /**
             * color for main menu
             */
            $bg_color = get_post_meta($objectId, '_nasa_bg_color_main_menu', true);
            $text_color = get_post_meta($objectId, '_nasa_text_color_main_menu', true);
            $text_color_hover = get_post_meta($objectId, '_nasa_text_color_hover_main_menu', true);
            $page_css .= zella_main_menu_color($bg_color, $text_color, $text_color_hover);
            
            /**
             * Full-width site
             */
            $fullWidth = get_post_meta($objectId, '_nasa_site_fullwidth', true);
            if($fullWidth !== '') {
                $page_css .= zella_site_fullwidth($fullWidth);
            }

            /**
             * setting width Header
             */
            $headerFullWidth = get_post_meta($objectId, '_nasa_header_fullwidth', true);
            if($headerFullWidth !== '') {
                $page_css .= zella_header_fullwidth($headerFullWidth);
            }
            
            /**
             * setting full-width Footer
             */
            $footerFullWidth = get_post_meta($objectId, '_nasa_footer_fullwidth', true);
            if($footerFullWidth !== '') {
                $page_css .= zella_footer_fullwidth($footerFullWidth);
            }

            $dinamic_css = $color_primary_css . $page_css;
            if ($dinamic_css != '') {
                wp_add_inline_style('zella-style-dynamic', $dinamic_css);
            }
        }
    }

endif;
