<?php
/**
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package nasatheme
 */

$nasa_sidebar = isset($nasa_opt['blog_layout']) ? $nasa_opt['blog_layout'] : '';

// Check $_GET['sidebar']
if (isset($_GET['sidebar'])):
    switch ($_GET['sidebar']) :
        case 'right' :
            $nasa_sidebar = 'right';
            break;
        
        case 'no' :
            $nasa_sidebar = 'no';
            break;
        
        case 'left' :
        default:
            $nasa_sidebar = 'left';
            break;
    endswitch;
endif;

$hasSidebar = true;
$left = true;
switch ($nasa_sidebar):
    case 'right':
        $left = false;
        $attr = 'large-9 desktop-padding-right-30 left columns';
        break;
    
    case 'no':
        $hasSidebar = false;
        $left = false;
        $attr = 'large-12 columns';
        break;
    
    case 'left':
    default:
        $attr = 'large-9 desktop-padding-left-30 right columns';
        break;
endswitch;

get_header();
?>

<div class="container-wrap page-<?php echo !empty($nasa_sidebar) ? esc_attr($nasa_sidebar) : 'left'; ?>-sidebar">

    <?php if ($hasSidebar): ?>
        <div class="div-toggle-sidebar center"><a class="toggle-sidebar" href="javascript:void(0);"><i class="fa fa-bars"></i> <?php esc_html_e('Sidebar', 'zella-theme'); ?></a></div>
    <?php endif; ?>

    <div class="row">
        <div id="content" class="<?php echo esc_attr($attr); ?>" role="main">
            <?php if (have_posts()) : ?>
                <header class="page-header">
                    <h1 class="page-title">
                        <?php
                        if (is_category()) :
                            printf(esc_html__('Category Archives: %s', 'zella-theme'), '<span>' . single_cat_title('', false) . '</span>');

                        elseif (is_tag()) :
                            printf(esc_html__('Tag Archives: %s', 'zella-theme'), '<span>' . single_tag_title('', false) . '</span>');

                        elseif (is_author()) : the_post();
                            printf(esc_html__('Author Archives: %s', 'zella-theme'), '<span class="vcard"><a class="url fn n" href="' . esc_url(get_author_posts_url(get_the_author_meta('ID'))) . '" title="' . esc_attr(get_the_author()) . '" rel="me">' . get_the_author() . '</a></span>');
                            rewind_posts();

                        elseif (is_day()) :
                            printf(esc_html__('Daily Archives: %s', 'zella-theme'), '<span>' . get_the_date() . '</span>');

                        elseif (is_month()) :
                            printf(esc_html__('Monthly Archives: %s', 'zella-theme'), '<span>' . get_the_date('F Y') . '</span>');

                        elseif (is_year()) :
                            printf(esc_html__('Yearly Archives: %s', 'zella-theme'), '<span>' . get_the_date('Y') . '</span>');

                        elseif (is_tax('post_format', 'post-format-aside')) :
                            esc_html_e('Asides', 'zella-theme');

                        elseif (is_tax('post_format', 'post-format-image')) :
                            esc_html_e('Images', 'zella-theme');

                        elseif (is_tax('post_format', 'post-format-video')) :
                            esc_html_e('Videos', 'zella-theme');

                        elseif (is_tax('post_format', 'post-format-quote')) :
                            esc_html_e('Quotes', 'zella-theme');

                        elseif (is_tax('post_format', 'post-format-link')) :
                            esc_html_e('Links', 'zella-theme');

                        else :
                            esc_html_e('', 'zella-theme');

                        endif;
                        ?>
                    </h1>
                    <?php
                    if (is_category()) :
                        $category_description = category_description();
                        if (!empty($category_description)) :
                            echo apply_filters('category_archive_meta', '<div class="taxonomy-description">' . $category_description . '</div>');
                        endif;

                    elseif (is_tag()) :
                        $tag_description = tag_description();
                        if (!empty($tag_description)) :
                            echo apply_filters('tag_archive_meta', '<div class="taxonomy-description">' . $tag_description . '</div>');
                        endif;

                    endif;
                    ?>
                </header>

                <div class="page-inner">
                    <?php get_template_part('content', get_post_format()); ?>
                </div>
            <?php else : ?>
                <?php get_template_part('no-results', 'archive'); ?>
            <?php endif; ?>
        </div>

        <?php if ($nasa_sidebar != 'no') : ?>
            <div class="large-3 columns <?php echo !$left ? 'right' : 'left'; ?> col-sidebar">
                <?php get_sidebar(); ?>
            </div>
        <?php endif; ?>

    </div>
</div>

<?php
get_footer();
