<?php
if (!function_exists('zella_portfolio_heading')) {
    add_action('init', 'zella_portfolio_heading');
    function zella_portfolio_heading() {
        
        if(!defined('NASA_CORE_ACTIVED') || !NASA_CORE_ACTIVED) {
            return;
        }
        
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Portfolio", 'zella-theme'),
            "target" => 'portfolio',
            "type" => "heading"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Portfolio", 'zella-theme'),
            "id" => "enable_portfolio",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Page view Portfolio", 'zella-theme'),
            "id" => "nasa-page-view-portfolio",
            "type" => "select",
            "options" => get_pages_temp_portfolio()
        );
        
        $of_options[] = array(
            "name" => esc_html__("Recent", 'zella-theme'),
            "id" => "recent_projects",
            "std" => 1,
            "type" => "switch"
        );
        $of_options[] = array(
            "name" => esc_html__("Comments", 'zella-theme'),
            "id" => "portfolio_comments",
            "std" => 1,
            "type" => "switch"
        );
        $of_options[] = array(
            "name" => esc_html__("Limit per page", 'zella-theme'),
            "id" => "portfolio_count",
            "std" => 10,
            "type" => "text"
        );
        $of_options[] = array(
            "name" => esc_html__("Category info", 'zella-theme'),
            "id" => "project_byline",
            "std" => 1,
            "type" => "switch"
        );
        $of_options[] = array(
            "name" => esc_html__("Title info", 'zella-theme'),
            "id" => "project_name",
            "std" => 1,
            "type" => "switch"
        );

        $of_options[] = array(
            "name" => esc_html__("Columns", 'zella-theme'),
            "id" => "portfolio_columns",
            "std" => "5-cols",
            "type" => "select",
            "options" => array(
                "5-cols" => esc_html__("5 columns", 'zella-theme'),
                "4-cols" => esc_html__("4 columns", 'zella-theme'),
                "3-cols" => esc_html__("3 columns", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme')
            )
        );

        $of_options[] = array(
            "name" => esc_html__("Lightbox", 'zella-theme'),
            "id" => "portfolio_lightbox",
            "std" => 1,
            "type" => "switch"
        );
    }
}
