<?php
if (!function_exists('zella_product_compare_heading')) {
    add_action('init', 'zella_product_compare_heading');
    function zella_product_compare_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Compare and Wishlist", 'zella-theme'),
            "target" => 'product-compare-wishlist',
            "type" => "heading",
        );
        
        $of_options[] = array(
            "name" => esc_html__("Compare Options", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Compare Options", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        global $yith_woocompare;
        if($yith_woocompare) {
            $of_options[] = array(
                "name" => esc_html__("Nasa compare products Extends Yith Plugin Compare", 'zella-theme'),
                "id" => "nasa-product-compare",
                "std" => 1,
                "type" => "switch"
            );
            
            $of_options[] = array(
                "name" => esc_html__("Page view compare products", 'zella-theme'),
                "id" => "nasa-page-view-compage",
                "type" => "select",
                "options" => get_pages_temp_compare()
            );

            $of_options[] = array(
                "name" => esc_html__("Max products compare", 'zella-theme'),
                "id" => "max_compare",
                "std" => "4",
                "type" => "select",
                "options" => array("2" => "2", "3" => "3", "4" => "4")
            );
        } else {
            $of_options[] = array(
                "name" => esc_html__("Install Yith Plugin Compare, Please", 'zella-theme'),
                "std" => '<h4 style="color: red">' . esc_html__("Please, Install Yith Plugin Compare!", 'zella-theme') . "</h4>",
                "type" => "info"
            );
        }
        
        /**
         * Wishlist
         */
        if (NASA_WISHLIST_ENABLE) {
            $of_options[] = array(
                "name" => esc_html__("Wishlist Options", 'zella-theme'),
                "std" => "<h4>" . esc_html__("Wishlist Options", 'zella-theme') . "</h4>",
                "type" => "info"
            );
            
            $of_options[] = array(
                "name" => esc_html__("Optimize Wishlist HTML", 'zella-theme'),
                "id" => "optimize_wishlist_html",
                "std" => 1,
                "type" => "switch"
            );
        }
    }
}
