<?php
if (!function_exists('zella_product_detail_heading')) {
    add_action('init', 'zella_product_detail_heading');
    function zella_product_detail_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Single Product Page", 'zella-theme'),
            "target" => 'product-detail',
            "type" => "heading",
        );
        
        $of_options[] = array(
            "name" => esc_html__("Header Single Product Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "header_single_product_fullwidth",
            "std" => 0,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Single product Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "single_product_fullwidth",
            "std" => 0,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Footer Single Product Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "footer_single_product_fullwidth",
            "std" => 0,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Single Product Layout", 'zella-theme'),
            "id" => "product_detail_layout",
            "std" => "full",
            "type" => "select",
            "options" => array(
                'full' => esc_html__("Slider - No thumbs (sidebar - holder)", 'zella-theme'),
                "new" => esc_html__("New layout (sidebar - holder)", 'zella-theme'),
                "classic" => esc_html__("Classic layout (Sidebar - columns)", 'zella-theme')
            ),
            
            'class' => 'nasa-theme-option-parent'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Product Sidebar", 'zella-theme'),
            "id" => "product_sidebar",
            "std" => "left",
            "type" => "select",
            "options" => array(
                "left" => esc_html__("Left Sidebar", 'zella-theme'),
                "right" => esc_html__("Right Sidebar", 'zella-theme'),
                "no" => esc_html__("No sidebar", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Infomation Alignment", 'zella-theme'),
            "id" => "product_info_align",
            "std" => "center",
            "type" => "select",
            "options" => array(
                "center" => esc_html__("Center", 'zella-theme'),
                "left" => esc_html__("Left", 'zella-theme'),
                "right" => esc_html__("Right", 'zella-theme')
            ),
            
            'class' => 'nasa-theme-option-child nasa-product_detail_layout nasa-product_detail_layout-full'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Images number show", 'zella-theme'),
            "id" => "product_image_layout",
            "std" => "single",
            "type" => "select",
            "options" => array(
                "double" => esc_html__("Double images", 'zella-theme'),
                "single" => esc_html__("Single image", 'zella-theme')
            ),
            
            'class' => 'nasa-theme-option-child nasa-product_detail_layout nasa-product_detail_layout-classic nasa-product_detail_layout-new'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Images style show", 'zella-theme'),
            "id" => "product_image_style",
            "std" => "slide",
            "type" => "select",
            "options" => array(
                "slide" => esc_html__("Slide images", 'zella-theme'),
                "scroll" => esc_html__("Scroll images", 'zella-theme')
            ),
            
            'class' => 'nasa-theme-option-child nasa-product_detail_layout nasa-product_detail_layout-new'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Hover product Zoom", 'zella-theme'),
            "id" => "product-zoom",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Lightbox product image", 'zella-theme'),
            "id" => "product-image-lightbox",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Focus main image when active variable product", 'zella-theme'),
            "id" => "enable_focus_main_image",
            "desc" => esc_html__("", 'zella-theme'),
            "std" => "1",
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Deal Time", 'zella-theme'),
            "id" => "single-product-deal",
            "std" => 0,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Buy Now", 'zella-theme'),
            "id" => "enable_buy_now",
            "std" => "1",
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Buy Now Background Color", 'zella-theme'),
            "id" => "buy_now_bg_color",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Buy Now Background Color Hover", 'zella-theme'),
            "id" => "buy_now_bg_color_hover",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Buy Now Shadow Color", 'zella-theme'),
            "id" => "buy_now_color_shadow",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Sticky Add To Cart", 'zella-theme'),
            "id" => "enable_fixed_add_to_cart",
            "std" => "1",
            "type" => "switch"
        );
        
        $options = array(
            "no" => esc_html__("Not Show", 'zella-theme'),
            "ext" => esc_html__("Extends Desktop", 'zella-theme')
        );
        
        if (class_exists('Nasa_Mobile_Detect')) {
            $options['btn'] = esc_html__("Only Show Buttons", 'zella-theme');
        }
        
        $of_options[] = array(
            "name" => esc_html__("Sticky Add To Cart In Mobile", 'zella-theme'),
            "id" => "mobile_fixed_add_to_cart",
            "std" => "no",
            "type" => "select",
            "options" => $options
        );
        
        $of_options[] = array(
            "name" => esc_html__("Stock Process Bar", 'zella-theme'),
            "id" => "enable_progess_stock",
            "std" => "1",
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Technical Specifications", 'zella-theme'),
            "id" => "enable_specifications",
            "std" => "1",
            "type" => "switch"
        );

        $of_options[] = array(
            "name" => esc_html__("Show the Specifications in the Desciption tab", 'zella-theme'),
            "id" => "merge_specifi_to_desc",
            "std" => "1",
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Tabs style", 'zella-theme'),
            "id" => "tab_style_info",
            "std" => "2d-no-border",
            "type" => "select",
            "options" => array(
                "2d-no-border" => esc_html__("Classic 2D - No border", 'zella-theme'),
                "2d" => esc_html__("Classic 2D", 'zella-theme'),
                "3d" => esc_html__("Classic 3D", 'zella-theme'),
                "slide" => esc_html__("Slide", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Tabs Title Align", 'zella-theme'),
            "id" => "tab_align_info",
            "std" => "center",
            "type" => "select",
            "options" => array(
                "center" => esc_html__("Center", 'zella-theme'),
                "left" => esc_html__("Left", 'zella-theme'),
                "right" => esc_html__("Right", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Number for relate products", 'zella-theme'),
            "id" => "release_product_number",
            "std" => "12",
            "type" => "text"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns Relate | Upsell Products", 'zella-theme'),
            "id" => "relate_columns_desk",
            "std" => "5-cols",
            "type" => "select",
            "options" => array(
                "3-cols" => esc_html__("3 columns", 'zella-theme'),
                "4-cols" => esc_html__("4 columns", 'zella-theme'),
                "5-cols" => esc_html__("5 columns", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns Relate | Upsell Products for Mobile", 'zella-theme'),
            "id" => "relate_columns_small",
            "std" => "1-col",
            "type" => "select",
            "options" => array(
                "1-cols" => esc_html__("1 column", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Columns Relate | Upsell Products for Tablet", 'zella-theme'),
            "id" => "relate_columns_tablet",
            "std" => "3-cols",
            "type" => "select",
            "options" => array(
                "1-col" => esc_html__("1 column", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme'),
                "3-cols" => esc_html__("3 columns", 'zella-theme')
            )
        );
        
        // Enable AJAX add to cart buttons on Detail OR Quickview
        $of_options[] = array(
            "name" => esc_html__("AJAX add to cart button on Detail And Quickview", 'zella-theme'),
            "id" => "enable_ajax_addtocart",
            "std" => "1",
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__('Mobile Layout', 'zella-theme'),
            "desc" => esc_html__('Note: Mobile layout for single product pages will hide all widgets and sidebar to increase performance.', 'zella-theme'),
            "id" => "single_product_mobile",
            "std" => 0,
            "type" => "switch"
        );
    }
}
