<?php
if (!function_exists('zella_product_page_heading')) {
    add_action('init', 'zella_product_page_heading');
    function zella_product_page_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Archive Products Page", 'zella-theme'),
            "target" => 'product-page',
            "type" => "heading",
        );

        $of_options[] = array(
            "name" => esc_html__("Category page", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Category page (Shop page)", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Header Store Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "header_store_fullwidth",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Store Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "store_fullwidth",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Footer Store Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "footer_store_fullwidth",
            "std" => 1,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Category sidebar", 'zella-theme'),
            "id" => "category_sidebar",
            "std" => "top-1",
            "type" => "select",
            "options" => array(
                "no" => esc_html__("No Sidebar", 'zella-theme'),
                "top-1" => esc_html__("Top Bar Type 1", 'zella-theme'),
                "top-2" => esc_html__("Top Bar Type 2", 'zella-theme'),
                "left" => esc_html__("Left Sidebar Off-canvas", 'zella-theme'),
                "left-classic" => esc_html__("Left sidebar Classic", 'zella-theme'),
                "right" => esc_html__("Right Sidebar Off-canvas", 'zella-theme'),
                "right-classic" => esc_html__("Right Sidebar Classic", 'zella-theme')
            ),
            
            'class' => 'nasa-theme-option-parent'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Top Bar Label", 'zella-theme'),
            "id" => "top_bar_archive_label",
            "desc" => esc_html__("Top Bar Label value. (If using WPML, please input 'Filter by:' and translate by WPML)", 'zella-theme'),
            "std" => "Filter by:",
            "type" => "text",
            'class' => 'nasa-category_sidebar nasa-category_sidebar-top-2 nasa-theme-option-child'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Top Bar Limit widgets to Show More", 'zella-theme'),
            "id" => "limit_widgets_show_more",
            "desc" => esc_html__('Limit widgets to show more. (Input "All" will be show all widgets)', 'zella-theme'),
            "std" => "4",
            "type" => "text",
            'class' => 'nasa-category_sidebar nasa-category_sidebar-top-2 nasa-theme-option-child'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Position filter categories", 'zella-theme'),
            "id" => "top_bar_cat_pos",
            "desc" => esc_html__("Position filter categories - Top Bar Type 2.", 'zella-theme'),
            "std" => "left-bar",
            "type" => "select",
            "options" => array(
                "top" => esc_html__("Top", 'zella-theme'),
                "left-bar" => esc_html__("Left bar", 'zella-theme')
            ),
            'class' => 'nasa-category_sidebar nasa-category_sidebar-top-2 nasa-theme-option-child'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Position filter categories", 'zella-theme'),
            "id" => "top_bar_cat_pos_1",
            "desc" => esc_html__("Position filter categories - Top Bar Type 1.", 'zella-theme'),
            "std" => "top",
            "type" => "select",
            "options" => array(
                "top" => esc_html__("Top", 'zella-theme'),
                "toggle" => esc_html__("Toggle", 'zella-theme')
            ),
            'class' => 'nasa-category_sidebar nasa-category_sidebar-top-1 nasa-theme-option-child'
        );

        $of_options[] = array(
            "name" => esc_html__("Products per row", 'zella-theme'),
            "id" => "products_per_row",
            "std" => "5-cols",
            "type" => "select",
            "options" => array(
                "3-cols" => esc_html__("3 columns", 'zella-theme'),
                "4-cols" => esc_html__("4 columns", 'zella-theme'),
                "5-cols" => esc_html__("5 columns", 'zella-theme'),
                "6-cols" => esc_html__("6 columns", 'zella-theme'),
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Products per row for mobile", 'zella-theme'),
            "id" => "products_per_row_small",
            "std" => "1-col",
            "type" => "select",
            "options" => array(
                "1-cols" => esc_html__("1 column", 'zella-theme'),
                "2-cols" => esc_html__("2 columns", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Products per row for Taplet", 'zella-theme'),
            "id" => "products_per_row_tablet",
            "std" => "2-cols",
            "type" => "select",
            "options" => array(
                "2-cols" => esc_html__("2 columns", 'zella-theme'),
                "3-cols" => esc_html__("3 columns", 'zella-theme'),
                "4-cols" => esc_html__("4 columns", 'zella-theme')
            )
        );

        $of_options[] = array(
            "name" => esc_html__("Products per page", 'zella-theme'),
            "id" => "products_pr_page",
            "std" => "20",
            "type" => "text"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Select type view", 'zella-theme'),
            "id" => "products_type_view",
            "std" => "grid",
            "type" => "select",
            "options" => array(
                "grid" => esc_html__("Grid view default", 'zella-theme'),
                "list" => esc_html__("List view default", 'zella-theme')
            )
        );
        
        $of_options[] = array(
            "name" => esc_html__("Archive top Info (don't using for Sidebar Off-canvas)", 'zella-theme'),
            "id" => "showing_info_top",
            "std" => "1",
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Change view as", 'zella-theme'),
            "id" => "enable_change_view",
            "std" => "1",
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Layout style", 'zella-theme'),
            "id" => "products_layout_style",
            "std" => "grid_row",
            "type" => "select",
            "options" => array(
                "grid-row" => esc_html__("Grid row", 'zella-theme'),
                "masonry-isotope" => esc_html__("Masonry isotope", 'zella-theme')
            )
        );

        $of_options[] = array(
            "name" => esc_html__("Pagination page style", 'zella-theme'),
            "id" => "pagination_style",
            "std" => 'infinite',
            "type" => "select",
            "options" => array(
                "style-2" => esc_html__("Simple", 'zella-theme'),
                "style-1" => esc_html__("Full", 'zella-theme'),
                "infinite" => esc_html__("Infinite - Only using for Ajax", 'zella-theme'),
                "load-more" => esc_html__("Load More - Only using for Ajax", 'zella-theme')
            )
        );

        $of_options[] = array(
            "name" => esc_html__("Show title in one line", 'zella-theme'),
            "id" => "cutting_product_name",
            "std" => "1",
            "type" => "switch"
        );

        $of_options[] = array(
            "name" => esc_html__("Top content Products page", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Top content Products page", 'zella-theme') . "</h4>",
            "type" => "info"
        );

        $of_options[] = array(
            "name" => esc_html__("Enable Category top content", 'zella-theme'),
            "id" => "enable_cat_header",
            "desc" => esc_html__("Enable Category top content", 'zella-theme'),
            "std" => "1",
            "type" => "checkbox"
        );

        $of_options[] = array(
            "name" => esc_html__("Category top content", 'zella-theme'),
            "id" => "cat_header",
            "desc" => esc_html__("Input anything shortcode or text here. Recommend to use the Static Blocks to create banner or anything that you want to show the top content in the Shop page", 'zella-theme'),
            "std" => "",
            "type" => "textarea"
        );
        
    }
}
