<?php
if (!function_exists('zella_header_footer_heading')) {
    add_action('init', 'zella_header_footer_heading');
    function zella_header_footer_heading() {
        /* ----------------------------------------------------------------------------------- */
        /* The Options Array */
        /* ----------------------------------------------------------------------------------- */
        // Set the Options Array
        global $of_options;
        if(empty($of_options)) {
            $of_options = array();
        }
        
        $of_options[] = array(
            "name" => esc_html__("Header and Footer", 'zella-theme'),
            "target" => 'header-footer',
            "type" => "heading"
        );

        $of_options[] = array(
            "name" => esc_html__("Header Option", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Header Option", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Header Type", 'zella-theme'),
            "id" => "header-type",
            "std" => "1",
            "type" => "images",
            "options" => array(
                '1' => ZELLA_ADMIN_DIR_URI . 'assets/images/header-1.jpg',
                '2' => ZELLA_ADMIN_DIR_URI . 'assets/images/header-2.jpg',
                '3' => ZELLA_ADMIN_DIR_URI . 'assets/images/header-3.jpg',
                '4' => ZELLA_ADMIN_DIR_URI . 'assets/images/header-4.jpg',
                '5' => ZELLA_ADMIN_DIR_URI . 'assets/images/header-5.jpg',
                '6' => ZELLA_ADMIN_DIR_URI . 'assets/images/header-6.jpg',
                'nasa-custom' => ZELLA_ADMIN_DIR_URI . 'assets/images/header-builder.gif'
            ),
            
            'class' => 'nasa-header-type-select nasa-theme-option-parent'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Header Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "header_fullwidth",
            "std" => 0,
            "type" => "switch",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-1 nasa-header-type-select-2 nasa-header-type-select-3 nasa-header-type-select-4 nasa-header-type-select-5 nasa-header-type-select-6'
        );
        
        $headers_type = get_posts(array(
            'posts_per_page'    => -1,
            'post_status'       => 'publish',
            'post_type'         => 'header'
        ));
        $headers_option = array();
        $headers_option['default'] = esc_html__('Select the Header custom', 'zella-theme');
        $header_selected = false;
        if (!empty($headers_type)) {
            foreach ($headers_type as $key => $value) {
                $header_selected = !$header_selected ? $value->post_name : $header_selected;
                $headers_option[$value->post_name] = $value->post_title;
            }
        }
        $of_options[] = array(
            "name" => esc_html__("Header Builder", 'zella-theme'),
            "id" => "header-custom",
            "type" => "select",
            'override_numberic' => true,
            "options" => $headers_option,
            'std' => $header_selected ? $header_selected : '',
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-nasa-custom nasa-header-custom'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Fullwidth main menu", 'zella-theme'),
            "id" => "fullwidth_main_menu",
            "std" => 1,
            "type" => "switch",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-2 nasa-header-type-select-5 nasa-header-type-select-6 nasa-fullwidth_main_menu'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Transparent", 'zella-theme'),
            "id" => "header_transparent",
            "std" => 0,
            "type" => "switch"
        );
        
        $block_type = get_posts(array(
            'posts_per_page'    => -1,
            'post_status'       => 'publish',
            'post_type'         => 'nasa_block'
        ));
        $header_blocks = array('default' => esc_html__('Select the Static Block', 'zella-theme'));
        if (!empty($block_type)) {
            foreach ($block_type as $key => $value) {
                $header_blocks[$value->post_name] = $value->post_title;
            }
        }
        $of_options[] = array(
            "name" => esc_html__("Block Header transparent", 'zella-theme'),
            "id" => "header-block",
            "type" => "select",
            "options" => $header_blocks
        );

        $of_options[] = array(
            "name" => esc_html__("Sticky", 'zella-theme'),
            "id" => "fixed_nav",
            "std" => 1,
            "type" => "switch"
        );

        $of_options[] = array(
            "name" => esc_html__("Toggle Top Bar", 'zella-theme'),
            "id" => "topbar_toggle",
            "std" => 0,
            "type" => "switch",
            'class' => 'nasa-topbar_toggle'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Default Top Bar Show", 'zella-theme'),
            "id" => "topbar_default_show",
            "std" => 1,
            "type" => "switch",
            'class' => 'hidden-tag nasa-topbar_df-show'
        );

        $of_options[] = array(
            "name" => esc_html__("Switch Languages", 'zella-theme'),
            "id" => "switch_lang",
            "std" => 0,
            "type" => "switch"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Currencies Switcher - Requires Package of WPML", 'zella-theme'),
            "id" => "switch_currency",
            "std" => 0,
            "type" => "switch"
        );
        
        //(%symbol%) %code%
        $of_options[] = array(
            "name" => esc_html__("Format Currency", 'zella-theme'),
            "desc" => esc_html__("Default (%symbol%) %code%. You can custom for this. Ex (%name% (%symbol%) - %code%)", 'zella-theme'),
            "id" => "switch_currency_format",
            "std" => "",
            "type" => "text"
        );

        $of_options[] = array(
            "name" => esc_html__("Top bar Content - Using for Header Type 4, 5, 6", 'zella-theme'),
            "desc" => '<a href="javascript:void(0);" class="reset_topbar_left"><b>Default value</b></a> for left top bar.<br /><a href="javascript:void(0);" class="restore_topbar_left"><b>Restore text</b></a> for top bar left.<br />',
            "id" => "topbar_content",
            "std" => '',
            "type" => "textarea"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Toggle Header Icons Responsive", 'zella-theme'),
            "id" => "topbar_mobile_icons_toggle",
            "std" => 0,
            "type" => "switch",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-1 nasa-header-type-select-2 nasa-header-type-select-3 nasa-topbar_mobile_icons_toggle'
        );

        $of_options[] = array(
            "name" => esc_html__("Header Elements", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Header Elements", 'zella-theme') . "</h4>",
            "type" => "info"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Topbar Background", 'zella-theme'),
            "id" => "bg_color_topbar",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Topbar Text color", 'zella-theme'),
            "id" => "text_color_topbar",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Topbar Text color hover", 'zella-theme'),
            "id" => "text_color_hover_topbar",
            "std" => "",
            "type" => "color"
        );
        
        $of_options[] = array(
            "name" => esc_html__("Background color Header", 'zella-theme'),
            "id" => "bg_color_header",
            "std" => "",
            "type" => "color",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-1 nasa-header-type-select-2 nasa-header-type-select-3 nasa-header-type-select-4 nasa-header-type-select-5 nasa-header-type-select-6 nasa-bg_color_header'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Header Icons", 'zella-theme'),
            "id" => "text_color_header",
            "std" => "",
            "type" => "color",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-1 nasa-header-type-select-2 nasa-header-type-select-3 nasa-header-type-select-4 nasa-header-type-select-5 nasa-header-type-select-6 nasa-text_color_header'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Header Icons Hover", 'zella-theme'),
            "id" => "text_color_hover_header",
            "std" => "",
            "type" => "color",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-1 nasa-header-type-select-2 nasa-header-type-select-3 nasa-header-type-select-4 nasa-header-type-select-5 nasa-header-type-select-6 nasa-text_color_hover_header'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Main Menu Background Color", 'zella-theme'),
            "id" => "bg_color_main_menu",
            "std" => "",
            "type" => "color",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-2 nasa-header-type-select-5 nasa-header-type-select-6 nasa-bg_color_main_menu'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Main Menu Text Color", 'zella-theme'),
            "id" => "text_color_main_menu",
            "std" => "",
            "type" => "color",
            'class' => 'hidden-tag nasa-header-type-child nasa-header-type-select-1 nasa-header-type-select-2 nasa-header-type-select-3 nasa-header-type-select-4 nasa-header-type-select-5 nasa-header-type-select-6 nasa-text_color_main_menu'
        );
        
        $of_options[] = array(
            "name" => esc_html__("Footer Option", 'zella-theme'),
            "std" => "<h4>" . esc_html__("Footer Option", 'zella-theme') . "</h4>",
            "type" => "info"
        );

        $footers_type = get_posts(array(
            'posts_per_page'    => -1,
            'post_status'       => 'publish',
            'post_type'         => 'footer'
        ));
        $footers_option = $footers_mobile = array();
        $footers_option['default'] = esc_html__('Select the Footer type', 'zella-theme');
        $footers_mobile['default'] = esc_html__('Extends from Desktop', 'zella-theme');
        $footer_selected = false;
        if (!empty($footers_type)) {
            foreach ($footers_type as $key => $value) {
                $footer_selected = !$footer_selected ? $value->post_name : $footer_selected;
                $footers_option[$value->post_name] = $value->post_title;
                $footers_mobile[$value->post_name] = $value->post_title;
            }
        }
        $of_options[] = array(
            "name" => esc_html__("Footer Type", 'zella-theme'),
            "id" => "footer-type",
            "type" => "select",
            'override_numberic' => true,
            "options" => $footers_option,
            'std' => $footer_selected ? $footer_selected : ''
        );
        
        /**
         * Footer Mobile
         */
        $of_options[] = array(
            "name" => esc_html__("Footer Mobile Layout", 'zella-theme'),
            "id" => "footer-mobile",
            "type" => "select",
            'override_numberic' => true,
            "options" => $footers_mobile,
            'std' => ''
        );
        
        $of_options[] = array(
            "name" => esc_html__("Footer Fullwidth (max-width: 1870px)", 'zella-theme'),
            "id" => "footer_fullwidth",
            "std" => 0,
            "type" => "switch"
        );
    }
}
