<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'YWCES_Multilingual_Email' ) ) {

	/**
	 * Implements WPML for YWCES Emails
	 *
	 * @class   YWCES_Request_Mail
	 * @package Yithemes
	 * @since   1.0.0
	 * @author  Your Inspiration Themes
	 * @extends WCML_Emails
	 *
	 */
	class YWCES_Multilingual_Email extends WCML_Emails {

		private $order_id = false;


		/**
		 * Constructor
		 *
		 * Initialize multilanguage for YWCES emails
		 *
		 * @since   1.0.0
		 * @author  Alberto Ruggiero
		 */
		function __construct() {

			// Call parent constructor
			global $woocommerce_wpml, $sitepress, $woocommerce, $wpdb;

			if ( version_compare( WCML_VERSION, '4.2.10', '<' ) ) {
				parent::__construct( $woocommerce_wpml, $sitepress, $woocommerce );
			} else {
				parent::__construct( $woocommerce_wpml, $sitepress, $woocommerce, $wpdb );
			}
			//add_filter( 'send_ywces_mail_notification', array( $this, 'refresh_email_lang' ), 10, 1 );

		}

		/**
		 * Refresh email language
		 *
		 * @since   1.0.0
		 *
		 * @param   $args
		 *
		 * @return  array
		 * @author  Alberto Ruggiero
		 */
		function refresh_email_lang( $args ) {


			$order_id = 0;

			$query_args = array(
				'post_type'      => wc_get_order_types(),
				'post_status'    => 'any',
				'posts_per_page' => 1,
				'orderby'        => 'ID',
				'order'          => 'DESC',
				'meta_query'     => array(
					array(
						'key'     => '_customer_user',
						'value'   => $args['user_id'],
						'compare' => '='
					)
				)
			);

			$query = new WP_Query( $query_args );

			if ( $query->have_posts() ) {

				while ( $query->have_posts() ) {

					$query->the_post();
					$order_id = $query->post->ID;

				}

			}

			wp_reset_query();
			wp_reset_postdata();

			$order = wc_get_order( $order_id );
			$lang  = yit_get_prop( $order, 'wpml_language' );

			if ( $lang == '' ) {
				$lang = get_user_locale( $args['user_id'] );
				$lang = substr( $lang, 0, 2 );
			}

			if ( ! empty( $lang ) ) {

				global $sitepress;

				$sitepress->switch_lang( $lang, true );

			}


			return $args;

		}

	}

	// returns instance of the mail on file include
	return new YWCES_Multilingual_Email();
}

