<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! function_exists( 'ywsfd_get_minified' ) ) {

	/**
	 * Get minified file suffix
	 *
	 * @since   1.0.0
	 * @return  string
	 * @author  Alberto Ruggiero
	 */
	function ywsfd_get_minified() {

		return defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

	}

}

if ( ! function_exists( 'ywsfd_check_coupon_ajax' ) ) {

	/**
	 * Check if the coupon for current product needs to be added after adding product to cart (AJAX)
	 *
	 * @since   1.0.0
	 *
	 * @param   $product_id
	 *
	 * @return  void
	 * @author  Alberto Ruggiero
	 */
	function ywsfd_check_coupon_ajax( $product_id ) {

		if ( get_option( 'ywsfd_enable_plugin' ) == 'yes' ) {

			YITH_WSFD()->check_coupon( '', $product_id );

		}

	}

	add_action( 'woocommerce_ajax_added_to_cart', 'ywsfd_check_coupon_ajax' );

}

if ( ! function_exists( 'ywsfd_coupon_message' ) ) {

	/**
	 * Manage coupon errors
	 *
	 * @since   1.0.4
	 *
	 * @param   $err
	 * @param   $err_code
	 *
	 * @return  string
	 * @author  Alberto Ruggiero
	 */
	function ywsfd_coupon_message( $err, $err_code, $coupon ) {

		$is_sfd = yit_get_prop( $coupon, 'generated_by' ) == 'ywsfd';

		if ( $err_code == 109 && $is_sfd ) {
			$err = __( 'To use the coupon, you need to add the product to the cart', 'yith-woocommerce-share-for-discounts' );
		}

		return $err;

	}

	add_filter( 'woocommerce_coupon_error', 'ywsfd_coupon_message', 10, 3 );

}