<?php
/**
 * This file belongs to the YIT Plugin Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'YWSFD_Shortcode' ) ) {

	/**
	 * Implements shortcode for Share for Discounts plugin
	 *
	 * @class   YWSFD_Shortcode
	 * @since   1.0.0
	 * @author  Alberto Ruggiero
	 *
	 */
	class YWSFD_Shortcode {

		/**
		 * Constructor
		 *
		 * @since   1.0.0
		 * @return  void
		 * @author  Alberto Ruggiero
		 */
		public function __construct() {

			add_action( 'init', array( $this, 'add_shortcodes_button' ), 20 );
			add_action( 'init', array( $this, 'gutenberg_block' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'admin_shortcode_scripts' ) );

			add_shortcode( 'ywsfd_shortcode', array( $this, 'print_shortcode' ) );

		}

		/**
		 * Add scripts and styles
		 *
		 * @since   1.0.0
		 * @return  void
		 * @author  Alberto Ruggiero
		 */
		public function admin_shortcode_scripts() {

			global $pagenow;

			if ( ( 'post.php' == $pagenow || 'post-new.php' == $pagenow ) && $this->can_show_shortcode_buttons() ) {

				wp_enqueue_script( 'ywsfd-shortcode', YWSFD_ASSETS_URL . '/js/ywsfd-shortcode' . ywsfd_get_minified() . '.js', array( 'jquery' ), YWSFD_VERSION );

				wp_localize_script( 'ywsfd-shortcode', 'ywsfd_shortcode', array(
					'title' => __( 'Add Share for Discounts shortcode', 'yith-woocommerce-share-for-discounts' ),
				) );

			}

		}

		/**
		 * Add shortcode button to TinyMCE editor, adding filter on mce_external_plugins
		 *
		 * @since   1.0.0
		 * @return  void
		 * @author  Alberto Ruggiero
		 */
		public function add_shortcodes_button() {

			add_filter( 'mce_external_plugins', array( &$this, 'add_shortcodes_tinymce_plugin' ) );
			add_filter( 'mce_buttons', array( &$this, 'register_shortcodes_button' ) );
			add_action( 'media_buttons_context', array( &$this, 'media_buttons_context' ) );

		}

		/**
		 * Add a script to TinyMCE script list
		 *
		 * @since   1.0.0
		 *
		 * @param   $plugin_array
		 *
		 * @return  array
		 * @author  Alberto Ruggiero
		 */
		public function add_shortcodes_tinymce_plugin( $plugin_array ) {

			if ( $this->can_show_shortcode_buttons() ) {

				$plugin_array['ywsfd_shortcode'] = YWSFD_ASSETS_URL . '/js/ywsfd-tinymce' . ywsfd_get_minified() . '.js';

			}

			return $plugin_array;

		}

		/**
		 * Make TinyMCE know a new button was included in its toolbar
		 *
		 * @since   1.0.0
		 *
		 * @param   $buttons
		 *
		 * @return  array()
		 * @author  Alberto Ruggiero
		 */
		public function register_shortcodes_button( $buttons ) {

			if ( $this->can_show_shortcode_buttons() ) {

				array_push( $buttons, "|", "ywsfd_shortcode" );
			}

			return $buttons;

		}

		/**
		 * The markup of shortcode
		 *
		 * @since   1.0.0
		 *
		 * @param   $context
		 *
		 * @return  mixed
		 * @author  Alberto Ruggiero
		 */
		public function media_buttons_context( $context ) {

			if ( $this->can_show_shortcode_buttons() ) {
				$context .= '<a id="ywsfd_shortcode" href="#" class="hide-if-no-js" title=""></a>';
			}

			return $context;

		}

		/**
		 * Check if shortcode buttons can be shown on the edit page
		 *
		 * @since   1.0.0
		 * @return  boolean
		 * @author  Alberto Ruggiero
		 */
		public function can_show_shortcode_buttons() {

			return ( current_user_can( 'edit_posts' ) && current_user_can( 'edit_pages' ) );

		}

		/**
		 * Set shortcode
		 *
		 * @since   1.0.0
		 * @return  string
		 * @author  Alberto Ruggiero
		 */
		public function print_shortcode() {

			add_filter( 'widget_text', 'shortcode_unautop' );
			add_filter( 'widget_text', 'do_shortcode' );

			global $post;

			ob_start();

			if ( apply_filters( 'ywsfd_can_get_coupon', true, ( isset( $post->ID ) ? $post->ID : '' ) ) ) {

				YITH_WSFD()->add_ywsfd_template();

			}

			return ob_get_clean();

		}

		/**
		 * Set shortcode
		 *
		 * @since   1.0.0
		 * @return  void
		 * @author  Alberto Ruggiero
		 */
		public function gutenberg_block() {

			$blocks = array(
				'ywsfd-shortcode' => array(
					'style'          => 'ywsfd-frontend',
					'title'          => _x( 'Share For Discounts', '[gutenberg]: block name', 'yith-woocommerce-share-for-discounts' ),
					'description'    => _x( 'Add the Share for Discounts shortcode', '[gutenberg]: block description', 'yith-woocommerce-share-for-discounts' ),
					'shortcode_name' => 'ywsfd_shortcode',
					'do_shortcode'   => true,
					'keywords'       => array(
						_x( 'Share for Discounts', '[gutenberg]: keywords', 'yith-woocommerce-share-for-discounts' ),
						_x( 'Share buttons', '[gutenberg]: keywords', 'yith-woocommerce-share-for-discounts' ),
					),
				),
			);

			yith_plugin_fw_gutenberg_add_blocks( $blocks );

		}


	}

}

new YWSFD_Shortcode();
