<?php
use angelleye\PayPal\PayPal;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

if( ! class_exists( 'YITH_Vendors_Gateway_Stripe_Connect' ) ) {
    /**
     * YITH Gateway Paypal
     *
     * Define methods and properties for class that manages payments via paypal
     *
     * @package   YITH_Marketplace
     * @author    Your Inspiration <info@yourinspiration.it>
     * @license   GPL-2.0+
     * @link      http://yourinspirationstore.it
     * @copyright 2014 Your Inspiration
     */
    class YITH_Vendors_Gateway_Stripe_Connect extends YITH_Vendors_Gateway {

    	/**
	     * @var string gateway slug
	     */
	    protected $_id = 'stripe-connect';

	    /**
	     * @var string gateway name
	     */
	    protected $_method_title = 'Stripe Connect';

	    public function __construct( $gateway ) {
		    $this->set_is_coming_soon( true ); //@TODO: To remove in final version
		    $this->set_is_external( true );

	    	$is_external_args = array(
			    'check_method'   => 'function_exists',
			    'check_for'      => 'YITH_Stripe_Connect',
			    'plugin_url'     => '//yithemes.com/themes/plugins/yith-woocommerce-stripe-connect/',
			    'plugin_name'    => 'YITH Stripe Connect for WooCommerce',
		    );

	    	$this->set_external_args( $is_external_args );

		    parent::__construct( $gateway );

		    /* === Admin Panel === */
		    add_filter( 'yith_wcmv_panel_gateways_options', 'YITH_Vendors_Gateway_Stripe_Connect::add_section_options' );
		    add_filter( 'yith_wcmv_panel_sections', 'YITH_Vendors_Gateway_Stripe_Connect::add_section' );

	    }

	    /**
	     * Retreive the paypal options array from this plugin.
	     *
	     * @author Andrea Grillo <andrea.grillo@yithemes.com>
	     *
	     * @return array opaypla option array
	     */
	    public static function get_options_array() {
		    return apply_filters( 'yith_wcmv_stripe-connect_gateways_options', array(
				    'stripe-connect' => array(

					    'stripe_connect_options_start'          => array(
						    'type'  => 'sectionstart',
					    ),

					    'stripe_connect_title'          => array(
						    'title' => __( 'Stripe Connect', 'yith-woocommerce-product-vendors' ),
						    'type'  => 'title',
						    'desc'  => __( 'Configure here your gateways in order to process the payment of commissions.', 'yith-woocommerce-product-vendors' ),
					    ),

					    'stripe_connect_coming_soon' => array(
					    	'type' => 'yith-field',
						    'yith-type' => 'html',
						    'html' => sprintf( '<a href="%s" target="_blank" id="stripe_connect_coming_soon"><img src="%s"></a><div style="max-width: 600px;">%s</div>',
							    '//yithemes.com/themes/plugins/yith-woocommerce-stripe-connect/',
							    YITH_WPV_ASSETS_URL . 'images/stripe_connect.jpg',
						    '<strong>YITH Stripe Connect</strong> is the most efficient tool to split payments made on your store by credit cards among your business partners in an automatic and immediate way.
							<br/><br/>
							In the online business era, where always more stores and companies offer their products and services in a network, the way to launch a commercial activity also evolved. Sometimes, to start an online business, all you need is the right idea and one or more partners with whom you are sharing the same point of view.
							<br/><br/>
							So, when your e-commerce is ready to be launched and you took everything into account, here\'s the problem arising: alright, you have planned to share by 50%, but how will you put it into practice? Who will receive the payment when the first customer purchases one of your products with a credit card? How will it be split based on the commissions you have agreed upon?
							<br/><br/>
							If you are already tearing your hair out thinking about checking every single order, a calculator in your hand, and managing all percentages and commissions manually, take a deep breath and read what our YITH Stripe Connect can do for you.
							<br/><br/>
							For more details please visit the plugin landing page: <a target="_blank" href="//yithemes.com/themes/plugins/yith-woocommerce-stripe-connect/">YITH Stripe Connect for WooCommerce</a>'
						    )
					    ),

					    'stripe_connect_options_end'          => array(
						    'type'  => 'sectionend',
					    ),
				    )
			    )
		    );
	    }

	    /**
	     * Add PayPal Section
	     *
	     * @author Andrea Grillo <andrea.grillo@yithemes.com>
	     *
	     * @return array paypal option array
	     */
	    public static function add_section( $sections ){
		    $sections['gateways']['stripe-connect'] = __( 'Stripe Connect', 'yith-woocommerce-product-vendors' );
		    return $sections;
	    }

	    /**
	     * Add  paypal options array from this plugin.
	     *
	     * @author Andrea Grillo <andrea.grillo@yithemes.com>
	     *
	     * @return array paypal option array
	     */
	    public static function add_section_options( $options ){
		    return array_merge( $options, self::get_options_array() );
	    }


        /* === PAYMENT METHODS === */

        /**
         * Pay method, used to process payment requests
         *
         * @param $payment_detail  array  Array of parameters for the single requests
         * Excepts at least the following parameters for each payment to process
         * [
         *     paypal_email => string (Paypal email of the receiver)
         *     amount => float (Amount to pay to user)
         *     request_id => int (Unique id of the request paid)
         * ]
         *
         * @return array An array holding the status of the operation; it should have at least a boolean status, a verbose status and an array of messages
         * [
         *     status => bool (status of the operation)
         *     verbose_status => string (one between PAYMENT_STATUS_OK and PAYMENT_STATUS_FAIL)
         *     messages => string|array (one or more message describing operation status)
         * ]
         * @since 1.0
         * @author Antonio La Rocca <antonio.larocca@yithemes.it>
         */
        public function pay( $payment_detail ){
        }

        /**
         * Method used to handle notification from paypal server
         *
         * @return void
         * @since 1.0
         * @author Antonio La Rocca <antonio.larocca@yithemes.it>
         */
        public function handle_notification(){
        }

	    /**
	     * Get the gateway options
	     *
	     * @return array
	     */
	    public function get_gateway_options() {
	    }
    }
}