<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly

if( ! class_exists( 'YITH_Vendors_Gateway' ) ){
    /**
     * YITH Gateway
     *
     * Define methods and properties for class that manages admin payments
     *
     * @class      YITH_Vendors_Gateway
     * @package    Yithemes
     * @since      Version 2.0.0
     * @author     Your Inspiration Themes
     */
    class YITH_Vendors_Gateway{

	    /**
	     * @var bool check if this gateway is available now
	     */
	    protected $_is_coming_soon = false;

	    /**
	     * @var bool check if this gateway required an external plugin to works
	     */
	    protected $_is_external = false;

	    /**
	     * @var array args for external gateays
	     */
	    protected $_external_args = array();

	    /**
	     * @var string gateway slug
	     */
	    protected $_id = 'gateway-id';

	    /**
	     * @var string gateway name
	     */
	    protected $_method_title = 'Gateway';

        /**
         * List of available gateways
         *
         * @var array Array of available gateways
         *
         * @since 1.0
         */
        public static $available_gateways = array(
            'paypal-masspay',
            'stripe-connect'
        );

        /**
         * Array of instances of the class, one for each available gateway
         *
         * @var mixed Array of instances of the class
         *
         * @since 1.0
         */
        static public $instances = array();

        /**
         * Name of the class of the actual used gateway
         *
         * @var string Gateway class name
         *
         * @since 1.0
         */
        public $gateway;

        /**
         * Constructor Method
         *
         * @return \YITH_Vendors_Gateway
         * @since 1.0
         * @author Antonio La Rocca <antonio.larocca@yithemes.it>
         */
        public function __construct( $gateway ){
			$this->gateway = $gateway;
			if( $this->get_is_external() ){
				add_filter( "yith_wcmv_displayed_{$this->get_id()}_id", array( $this, 'check_for_external_plugin' ) );
			}
        }

        /* === STATIC INITIALIZATION === */

        /**
         * Returns instance of the class, created specifically for the slug passed as parameter
         * Each gateway slug will generate at most one YITH_Vendors_Gateway instance
         *
         * @param $gateway string Gateway slug
         *
         * @static
         * @return \YITH_Vendors_Gateway Unique instance of the class for the passed gateway slug
         * @since 1.0
         * @author Antonio La Rocca <antonio.larocca@yithemes.it>
         */
        static public function get_instance( $gateway ){
	        if ( isset( self::$instances[ $gateway ] ) ) {
                return self::$instances[ $gateway ];
            }
            else{
	            if ( ! in_array( $gateway, self::$available_gateways ) ) {
		            return false;
	            }

	            require_once( 'gateways/class-yith-gateway-' . $gateway . '.php' );

	            if ( $class = YITH_Vendors_Gateways::get_gateway_class_from_slug( $gateway ) ) {
		            self::$instances[ $gateway ] = new $class( $gateway );

		            return self::$instances[ $gateway ];
	            }

	            return false;
            }
        }

        /* === DYNAMIC INITIALIZATION === */

        /**
         * Sends payment requests to gateway specific method
         *
         * @param $payment_detail mixed  Array used to identify payment to execute; it will be passed to gateway method, so can be anything
         *
         * @return array An array holding the status of the operation; it should have at least a boolean status, a verbose status and an array of messages
         * [
         *     status => bool (status of the operation)
         *     verbose_status => string (E.G.: for PayPal one between PAYMENT_STATUS_OK and PAYMENT_STATUS_FAIL)
         *     messages => string|array (one or more message describing operation status)
         * ]
         * If payment can be executed, method will return pay method result value
         * @since 1.0
         * @author Antonio La Rocca <antonio.larocca@yithemes.it>
         */
        public function pay( $payment_detail ){
            return array();
        }

	    /**
	     * Get the gateway options
	     *
	     * @return array
	     */
	    public function get_gateway_options() {
			return array();
	    }

	    /**
	     * Get the data for pay() method
	     *
	     * @args Array argument to retreive payment data
	     * @return array
	     */
	    public function get_pay_data( $args = array() ) {
		    return array();
	    }

	    /**
	     * Check if the current gateway is enabled or not
	     *
	     * @return bool TRUE if enabled, FALSE otherwise
	     */
	    public function is_enabled(){
	    	$gateway_slug = $this->get_id();
		    $enabled = 'yes' == get_option( "yith_wcmv_enable_{$gateway_slug}_gateway", 'no' );
	        return $enabled;
        }

        /**
         * Get Class Slug
         *
         * @return string
         */
        public function get_id(){
        	return $this->_id;
        }

	    /**
	     * Get Class Name
	     *
	     * @return string
	     */
	    public function get_method_title(){
		    return $this->_method_title;
	    }

	    /**
	     * Get is_coming_soon attribute
	     *
	     * @return string
	     */
	    public function get_is_coming_soon(){
		    return $this->_is_coming_soon;
	    }

	    /**
	     * set is_coming_soon attribute
	     *
	     * @return void
	     */
	    public function set_is_coming_soon( $is_coming_soon ){
		    $this->_is_coming_soon = $is_coming_soon;
	    }

	    /**
	     * Get is_external attribute
	     *
	     * @return string
	     */
	    public function get_is_external(){
		    return $this->_is_external;
	    }

	    /**
	     * set is_external attribute
	     *
	     * @return void
	     */
	    public function set_is_external( $is_extenal ){
		    $this->_is_external = $is_extenal;
	    }

	    /**
	     * Set is_external attribute
	     *
	     * @return array
	     */
	    public function get_external_args(){
		    return $this->_external_args;
	    }

	    /**
	     * set is_extenal attribute
	     *
	     * @return void
	     */
	    public function set_external_args( $args ){
		    $this->_external_args = $args;
	    }

	    /**
	     * check for esternal plugin
	     * @author Andrea Grillo <andrea.grillo@yithemes.com>
	     *
	     * @return bool TRUE if the external plugin is required, false otherwise
	     */
	    public function check_for_external_plugin( $gateway_id ){
	        $external_args = $this->get_external_args();
	        extract( $external_args );
	        if( ! $check_method( $check_for ) ){
	        	$gateway_id = sprintf( '<a href="%s" class="yith-wcmv-gateway-required-external" target="_blank">%s %s</a>', $plugin_url, _x( 'Required', '[Admin]: Part of Required xxx plugin', 'yith-woocommerce-product-vendors' ), $plugin_name );
	        }

	        return $gateway_id;
        }
    }
}

/**
 * Get the single instance of YITH_Vendors_Gateway_Panel class
 *
 *
 * @return \YITH_Vendors_Gateway Single instance of the class
 * @since  1.0
 * @author Antonio La Rocca <antonio.larocca@yithemes.com>
 */
function YITH_Vendors_Gateway( $gateway ){
    return YITH_Vendors_Gateway::get_instance( $gateway );
}