<?php
/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */
if ( ! defined( 'YITH_WPV_VERSION' ) ) {
    exit( 'Direct access forbidden.' );
}

if ( ! class_exists( 'YITH_Vendors_Credit' ) ) {
    /**
     * Manage the commission payments to vendors
     *
     * @class      YITH_Vendors_Credit
     * @package    Yithemes
     * @since      Version 2.0.0
     * @author     Your Inspiration Themes
     */
    class YITH_Vendors_Credit {

	    /**
	     * Main Instance
	     *
	     * @var string
	     * @since 1.0
	     * @access protected
	     */
	    protected static $_instance = null;

	    /**
	     * Gateway instance to process payment
	     *
	     * @var YITH_Vendors_Gateway_Paypal_MassPay
	     * @since 1.0
	     * @access protected
	     */
	    public $gateway = null;

	    /**
	     * Main plugin Instance
	     *
	     * @static
	     * @return YITH_Vendors_Credit Main instance
	     *
	     * @since  1.0
	     */
	    public static function instance() {
		    if ( is_null( self::$_instance ) ) {
			    self::$_instance = new self();
		    }

		    return self::$_instance;
	    }

	    /**
	     * Constructor
	     *
	     * @return mixed|YITH_Vendors_Credit
	     * @since  1.0.0
	     * @access public
	     */
	    public function __construct() {
			add_action( 'woocommerce_order_status_changed', array( $this, 'process_credit' ), 20, 3 );
			add_action( 'yith_vendors_gateway_notification', array( $this, 'handle_payment_successful' ) );
			add_action( 'admin_action_pay_commission', array( $this, 'handle_single_commission_pay' ) );
			add_action( 'admin_action_pay_commissions', array( $this, 'handle_massive_commissions_pay' ) );

		    //include_once( 'class.yith-vendors-gateway.php' );
		    //$this->gateway = YITH_Vendors_Gateway( 'paypal-masspay' );
	    }

	    /**
	     * Pay the commission to vendor
	     *
	     * @param $order_id
	     * @param $old_status
	     * @param $new_status
	     */
	    public function process_credit( $order_id, $old_status, $new_status ) {
		    if ( 'completed' != $new_status ) {
			    return;
		    }

		    $args = array(
		    	'order_id' => $order_id
		    );

		    $data = !!$this->gateway ? $this->gateway->get_pay_data( $args ) : array();

		    // pay
		    $result = $this->pay( $data );

            $commissions = isset( $data[ 'commissions' ] ) ? $data[ 'commissions' ] : array();

		    foreach ( $commissions as $commission ) {
			    // set as processing, because paypal will set as paid as soon as the transaction is completed
			    if ( $result['status'] ) {
				    $commission->update_status( 'processing' );
			    }

			    // save the error in the note
			    else {
				    $commission->add_note( sprintf( __( 'Payment failed: %s', 'yith-woocommerce-product-vendors' ), $result['messages'] ) );
			    }
		    }
	    }

	    /**
	     * Pay single commission
	     *
	     * @param $commission_id
	     * @return array|void
	     */
	    public function pay_commission( $commission_id ) {
		    $commission = YITH_Commission( $commission_id );

		    if ( ! $commission->exists() ) {
			    return;
		    }

		    $data = !!$this->gateway ? $this->gateway->get_pay_data( array( 'commission' => $commission ) ) : array();

		    // process payment
		    $result = $this->pay( $data );

		    // set as processing, because paypal will set as paid as soon as the transaction is completed
		    if ( $result['status'] ) {
			    $commission->update_status( 'processing' );
		    }

		    // save the error in the note
		    else {
			    $commission->add_note( sprintf( __( 'Payment failed: %s', 'yith-woocommerce-product-vendors' ), $result['messages'] ) );
		    }

            return $result;
	    }

		/**
		 * Pay massive commission
		 *
		 * @param $commission_id
		 * @return array|void
		 */
		public function pay_massive_commissions( $vendor_id ) {
			$commission_ids = array();

			if( empty( $_GET['commission_ids'] ) && empty( $_GET['amount'] ) ){
				return;
			}

			else {
				$commission_ids = urldecode( $_GET['commission_ids'] );
				$commission_ids = explode( ',', $commission_ids );
			}

			$vendor = yith_get_vendor( $vendor_id, 'vendor' );

			if ( ! $vendor->is_valid() ) {
				return;
			}

			if ( empty( $vendor->paypal_email ) ) {
				return;
			}

			$args = array(
				'type'        => 'massive_payment',
				'vendor'      => $vendor,
				'commissions' => $commission_ids,
				'amount'      => $_GET['amount'],
			);

			$data = !!$this->gatewa ?$this->gateway->get_pay_data( $args ) : array();

			// process payment
			$result = $this->pay( $data );

            $commissions = isset( $data[ 'commissions' ] ) ? $data[ 'commissions' ] : array();
            // set as processing, because paypal will set as paid as soon as the transaction is completed
			foreach( $commissions as $commission ) {
				if ( $result['status'] ) {
					$commission->update_status( 'processing' );
				}

				// save the error in the note
				else {
					$commission->add_note( sprintf( __( 'Payment failed: %s', 'yith-woocommerce-product-vendors' ), $result['messages'] ) );
				}
			}

			return $result;
		}

	    /**
	     * Handle the single commission from commission list
	     */
	    public function handle_single_commission_pay() {
		    if ( current_user_can( 'manage_woocommerce' ) && wp_verify_nonce( $_GET['_wpnonce'], 'yith-vendors-pay-commission' ) && isset( $_GET['commission_id'] ) ) {
			    $commission_id = absint( $_GET['commission_id'] );
			    $result = $this->pay_commission( $commission_id );
                $message = $result['status'] ? 'pay-process' : 'pay-failed';
                $text    = $result['status'] ? '' : $result['messages'];
		    }

		    wp_safe_redirect( esc_url_raw( add_query_arg( array( 'message' => $message, 'text' => urlencode( $text ) ), wp_get_referer() ) ) );
		    exit();
	    }

		/**
		 * Handle the massive commission from commission list
		 */
		public function handle_massive_commissions_pay(){
			if ( current_user_can( 'manage_woocommerce' ) && wp_verify_nonce( $_GET['_wpnonce'], 'yith-vendors-pay-commissions' ) && isset( $_GET['commission_ids'] ) && isset( $_GET['vendor_id'] ) ) {
				$result = $this->pay_massive_commissions( $_GET['vendor_id'] );
				$message = $result['status'] ? 'pay-process' : 'pay-failed';
				$text    = $result['status'] ? '' : $result['messages'];
			}

			wp_safe_redirect( esc_url_raw( add_query_arg( array( 'message' => $message, 'text' => urlencode( $text ) ), wp_get_referer() ) ) );
			exit();
		}

	    /**
	     * Process the payment to paypal
	     *
	     * @param array $requests
	     *
	     * @return array
	     */
	    public function pay( $requests = array() ) {
			return !!$this->gateway ? $this->gateway->pay( $requests ) : array();
	    }

	    /**
	     * Process success payment
	     *
	     * @param $args
	     */
	    public function handle_payment_successful( $args ) {
		    if ( empty( $args['unique_id'] ) ) {
			    return;
		    }

		    $commission = YITH_Commission( absint( $args['unique_id'] ) );

		    // perform only if the commission is in progress
		    if ( ! $commission->has_status( 'processing' ) ) {
			    return;
		    }


		    // emails
		    WC()->mailer();

		    // if completed, set as paid
		    if ( $args['status'] == 'Completed' ) {
		        $gateway_name = !!$this->gateway ? $this->gateway->get_name() : '';
			    $commission->update_status( 'paid', sprintf( __( 'Commission paid via %s (txn ID: %s)', 'yith-woocommerce-product-vendors' ), $gateway_name, $args['txn_id'] ) );
			    do_action( 'yith_vendors_commissions_paid', $commission );
		    }

		    // set unpaid if failed
		    else {
			    $commission->update_status( 'unpaid', sprintf( __( 'Payment %s', 'yith-woocommerce-product-vendors' ), $args['status'] ) );
			    do_action( 'yith_vendors_commissions_unpaid', $commission );
		    }
	    }
    }
}

/**
 * Main instance of plugin
 *
 * @return YITH_Vendors_Credit
 * @since  1.0
 */
if ( ! function_exists( 'YITH_Vendors_Credit' ) ) {
    function YITH_Vendors_Credit() {
        return YITH_Vendors_Credit::instance();
    }
}

YITH_Vendors_Credit();
