<?php
/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct access forbidden.' );
}

/**
 *
 *
 * @class      YITH_Vendor_Deprecated_PayPal_Service
 * @package    Yithemes
 * @since      Version 2.5.0
 * @author     Your Inspiration Themes
 *
 */
if ( ! class_exists( 'YITH_Vendor_Deprecated_PayPal_Service' ) ) {

	/**
	 * YITH_Vendor_Deprecated_PayPal_Service Class
	 */
	class YITH_Vendor_Deprecated_PayPal_Service {

		/**
		 * Main instance
		 */
		private static $_instance = null;

		/**
		 * Construct
		 */
		public function __construct() {
			/* === Multi Vendor Plugin Panel  */

			// Add PayPal tab to vendor Panel
			add_filter( 'yith_vendors_admin_tabs', 'YITH_Vendor_Deprecated_PayPal_Service::admin_tabs', 5 );
			//Load paypal option file from extenal plugin
			add_filter( 'yith_plugin_panel_item_options_path', 'YITH_Vendor_Deprecated_PayPal_Service::plugin_panel_paypal_options_path', 10, 4 );

			/* === Commissions Table === */

			// Bulk Actions
			add_filter( 'yith_wcmv_commissions_bulk_actions', 'YITH_Vendor_Deprecated_PayPal_Service::commissions_bulk_actions' );
			//Add MassPay Button
			add_action( 'yith_wcmv_before_user_actions', 'YITH_Vendor_Deprecated_PayPal_Service::add_masspay_pay_button', 10, 1 );

			/* === Vendor's Panel === */
			//Payments tab
			add_action( 'yith_wcmv_vendor_panel_payments', 'YITH_Vendor_Deprecated_PayPal_Service::add_vendor_panel_payments_options', 10, 1 );

			/* === Add-ons === */
			add_filter( 'yith_wcmv_add_ons', 'YITH_Vendor_Deprecated_PayPal_Service::add_paypal_adaptive_payments_add_on' );
			add_filter( 'yith_wcmv_add_ons_options', 'YITH_Vendor_Deprecated_PayPal_Service::add_paypal_adaptive_payments_add_on_option' );

			add_action( 'init', 'YITH_Vendor_Deprecated_PayPal_Service::restore_paypal_options', 99 );
		}

		/**
		 * Main plugin Instance
		 *
		 * @static
		 * @return YITH_Vendor_Deprecated_PayPal_Service Main instance
		 *
		 * @since  2.5.0
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 */
		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}

			return self::$_instance;
		}

		/**
		 * Add options tab
		 *
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 *
		 * @param $tabs
		 *
		 * @return array tabs
		 */
		public static function admin_tabs( $tabs ) {
			$tabs['paypal'] = __( 'Paypal', 'yith-woocommerce-product-vendors' );

			return $tabs;
		}


		/**
		 * Change to path to load the paypal options array from this plugin.
		 *
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 *
		 * @param $path string path the options file
		 * @param $option_path string original option path from plugin
		 * @parem $item string tab name
		 * @param $panel YIT_Plugin_Panel panel object
		 *
		 * @return string tabs
		 */
		public static function plugin_panel_paypal_options_path( $path, $options_path, $item, $panel ) {
			global $pagenow;
			if ( 'paypal' == $item && 'admin.php' == $pagenow && ! empty( $_GET['page'] ) && 'yith_wpv_panel' == $_GET['page'] ) {
				$path = YITH_WPV_PATH . 'includes/modules/compatibility/paypal/plugin-options/paypal-options.php';
			}

			return $path;
		}

		/**
		 * Add Pay Bulk Actions
		 *
		 * @param $actions array Bulk actions for commissions table
		 *
		 * @return array allowed bulk actions
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 */
		public static function commissions_bulk_actions( $actions ) {
			if ( 'masspay' == get_option( 'payment_gateway', 'masspay' ) ) {
				$actions = array_merge( array( 'pay' => __( 'Pay with MassPay', 'yith-woocommerce-product-vendors' ) ), $actions );
			}

			return $actions;
		}

		/**
		 * Show Pay Button for MassPay service
		 *
		 * @param $commission YITH_Commission the commission to pay
		 *
		 * @return void
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 */
		public static function add_masspay_pay_button( $commission ) {
			if ( $commission->has_status( 'unpaid' ) && 'masspay' == get_option( 'payment_gateway', 'masspay' ) && $commission instanceof YITH_Commission ) {
				$masspay_uri = esc_url( wp_nonce_url( add_query_arg( array( 'action'        => 'pay_commission',
				                                                            'commission_id' => $commission->id
				), admin_url( 'admin.php' ) ), 'yith-vendors-pay-commission' ) );
				$masspay_uri = apply_filters( 'yith_wcmv_commissions_list_table_masspay_pay_button_url', $masspay_uri, $commission );
				printf( '<a class="button tips pay" href="%1$s" data-tip="%2$s">%2$s</a>', $masspay_uri, __( 'Pay', 'yith-woocommerce-product-vendors' ) );
			}
		}

		/**
		 * Add Payments option to Payment tab
		 *
		 * @param $args array template args
		 *
		 * @return void
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 */
		public static function add_vendor_panel_payments_options( $args = array() ) {
			$currency_symbol = get_woocommerce_currency_symbol();
			$payments_type   = array(
				'instant'   => __( 'Instant Payment', 'yith-woocommerce-product-vendors' ),
				'threshold' => __( 'Payment threshold', 'yith-woocommerce-product-vendors' )
			);
			$step            = 'any';
			$min             = get_option( 'payment_minimum_withdrawals', 1 );
			$vendor          = ! empty( $args['vendor'] ) && $args['vendor'] instanceof YITH_Vendor ? $args['vendor'] : yith_get_vendor( 'current', 'user' );

			if ( 'choose' == get_option( 'payment_method', false ) ) : ?>
				<?php ob_start(); ?>
				<div class="form-field">
					<label for="vendor_payment_type"><?php _e( 'Payment type:', 'yith-woocommerce-product-vendors' ) ?></label>
					<select name="yith_vendor_data[payment_type]" id="vendor_payment_type" class="vendor_payment_type">
						<?php foreach ( $payments_type as $value => $label ) : ?>
							<option <?php selected( $vendor->payment_type, $value ) ?>
								value="<?php echo $value ?>"><?php echo $label ?></option>
						<?php endforeach; ?>
					</select>
					<br/>
					<span
						class="description"><?php _e( 'Choose payment method for crediting commissions', 'yith-woocommerce-product-vendors' ); ?></span>
				</div>


				<div class="form-field">
					<label class="yith_vendor_payment_threshold"
					       for="yith_vendor_payment_threshold"><?php _e( 'Threshold', 'yith-woocommerce-product-vendors' ); ?></label>
					<input type="number" class="payment-threshold-field" name="yith_vendor_data[threshold]"
					       id="yith_vendor_payment_threshold" value="<?php echo $vendor->threshold ?>" min="<?php echo $min ?>"
					       step="<?php echo $step ?>"/>
					<?php echo $currency_symbol ?>
					<br/>
					<span class="description"><?php printf( '%s (%s: <strong>%s</strong>).',
							__( "Minimum vendor's earning before a vendor's commissions can be paid", 'yith-woocommerce-product-vendors' ),
							__( 'Minimum threshold allowed by site administrator is', 'yith-woocommerce-product-vendors' ),
							wc_price( get_option( 'payment_minimum_withdrawals' ) )
						); ?></span>
				</div>
				<?php echo ob_get_clean(); ?>
			<?php endif;
		}

		/**
		 * Add PayPal Adaptive Payments Add-on service
		 *
		 * @param $add_ons array all extra multi vendor add-ons
		 *
		 * @return array Add-ons
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 */
		public static function add_paypal_adaptive_payments_add_on( $add_ons ){
			$add_ons['paypal-adaptive'] = array(
				'name'              => 'YITH PayPal Adaptive Payments for WooCommerce',
				'landing_uri'       => '//yithemes.com/themes/plugins/yith-woocommerce-paypal-adaptive-payments/',
				'option_desc'       => __( 'The vendor commissions are paid automatically by Adaptive Payments system.', 'yith-woocommerce-product-vendors' ),
				'premium'           => 'YITH_PAYPAL_ADAPTIVE_PREMIUM',
				'installed_version' => 'YITH_PAYPAL_ADAPTIVE_VERSION',
				'min_version'       => '1.0.0',
				'compare'           => '>=',
				'is_deprecated'     => true,
			);
		    return $add_ons;
        }

		/**
		 * Add PayPal Adaptive Payments Add-on option
		 *
		 * @param $add_ons_options array all extra multi vendor add-ons option
		 *
		 * @return array Add-ons
		 * @author Andrea Grillo <andrea.grillo@yithemes.com>
		 */
		public static function add_paypal_adaptive_payments_add_on_option( $add_ons_options ){
		    $adaptive_payments_option = array(
			    'vendors_paypal_adaptive_options' => array(
				    'type' => 'sectionstart',
			    ),

			    'vendors_paypal_adaptive_options_title' => array(
				    'title' => __( 'PayPal Adaptive Payments for WooCommerce', 'yith-woocommerce-product-vendors' ),
				    'type'  => 'title',
				    'desc'  => YITH_Vendors()->addons->get_plugin_landing_uri( 'paypal-adaptive', 'display' ),
			    ),

			    'vendors_paypal_adaptive_options_mode' => array(
				    'title'             => __( 'PayPal Adaptive Payments for vendors', 'yith-woocommerce-product-vendors' ),
				    'id'                => 'yith_wpv_vendors_option_adaptive_payment',
				    'type'              => 'checkbox',
				    'desc'              => YITH_Vendors()->addons->get_option_description( 'paypal-adaptive' ),
				    'custom_attributes' => YITH_Vendors()->addons->has_plugin( 'paypal-adaptive' ) ? false : array(
					    'disabled' => 'disabled',
				    ),
			    ),

			    'vendors_paypal_adaptive_options_end' => array(
				    'type' => 'sectionend',
			    ),
            );

			return array_merge( $add_ons_options, $adaptive_payments_option );
		}

		/**
         * Restore PayPal Options
         *
         * @author Andrea Grillo <andrea.grillo@yithemes.com>
         * @return void
         * @ since 2.5.0
         */
		public static function restore_paypal_options(){
			$is_restored = get_option( 'yith_wcmv_deprecated_paypal_options_restored', false );
			if( ! $is_restored ){
				$to_restore = get_option( 'yith_wcmv_deprecated_paypal_options', array() );
			    foreach( $to_restore as $option => $value ){
			        update_option( $option, $value );
                }

                add_option( 'yith_wcmv_deprecated_paypal_options_restored', true );
            }
        }
	}
}

/**
 * Main instance of plugin
 *
 * @return /YITH_Vendor_Deprecated_PayPal_Service
 * @since  2.5.0
 * @author Andrea Grillo <andrea.grillo@yithemes.com>
 */
if ( ! function_exists( 'YITH_Vendor_Deprecated_PayPal_Service' ) ) {
	function YITH_Vendor_Deprecated_PayPal_Service() {
		return YITH_Vendor_Deprecated_PayPal_Service::instance();
	}
}

YITH_Vendor_Deprecated_PayPal_Service();
