<?php
/**
 * Admin View: Product Settings
 */

if( !defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

?>

<div id="yith_wfbt_data_option" class="panel woocommerce_options_panel">

    <?php foreach( $options as $group => $fields ): ?>
        <div class="options_group <?php echo ! empty( $fields['class'] ) ? esc_attr( $fields['class'] ) : ''; ?>">
            <?php foreach( $fields as $field_key => $field ):

                if( ! is_array( $field ) ) {
                    continue;
                }

                // build data if any
                $data = '';
                if( isset( $field['data'] ) ) {
                    foreach( $field['data'] as $key => $value ){
                        $data .= ' data-'.$key.'="'.$value.'"';
                    }
                }

                // build attr if any
                $attr = '';
                if( isset( $field['attr'] ) ) {
                    foreach( $field['attr'] as $key => $value ){
                        $data .= ' '.$key.'="'.$value.'"';
                    }
                }

                $desc   = ! empty( $field['desc'] ) ? esc_attr( $field['desc'] ) : '';
                $class  = ! empty( $field['class'] ) ? esc_attr( $field['class'] ) : '';
            ?>
            <p class="form-field" <?php echo $data ?>>
                <label for="<?php echo esc_attr( $field['name'] ) ?>"><?php echo esc_html( $field['label'] ); ?></label>
                <?php switch( $field['type'] ) :

                        case 'variation_select': ?>
                            <select id="<?php echo esc_attr( $field['name'] ) ?>" name="<?php echo esc_attr( $field['name'] ) ?>">
                                <?php
                                $variations = YITH_WFBT_Admin()->get_variations( $product_id );
                                foreach( $variations as $variation ) :
                                    // store var id
                                    $to_exclude[] = $variation[ 'id' ];
                                    ?>
                                    <option value="<?php echo $variation[ 'id' ] ?>" <?php selected( $variation[ 'id' ], $metas[ $field_key ] ) ?>><?php echo $variation[ 'name' ] ?></option>
                                <?php
                                endforeach;
                                ?>
                            </select>
                            <?php break;

                        case 'product_select':

                            $product_ids = array_filter( array_map( 'absint', (array) $metas['products'] ) );
                            $json_ids = array();

                            foreach( $product_ids as $product_id ) {
                                $product = wc_get_product( $product_id );
                                if( is_object( $product ) ) {
                                    $json_ids[ $product_id ] = wp_kses_post( html_entity_decode( $product->get_formatted_name() ) );
                                }
                            }

                            yit_add_select2_fields( array(
                                'class' => 'wc-product-search',
                                'style' => 'width: 50%;',
                                'id' => 'yith_wfbt_ids',
                                'name' => 'yith_wfbt_ids',
                                'data-placeholder' => __( 'Search for a product&hellip;', 'yith-woocommerce-frequently-bought-together' ),
                                'data-multiple' => true,
                                'data-action' => 'yith_ajax_search_product',
                                'data-selected' => $json_ids,
                                'value' => implode( ',', array_keys( $json_ids ) ),
                                'custom-attributes' => array(
                                    'data-exclude' => implode( ',', $to_exclude )
                                )
                            ) );

                            if( $desc ) : ?>
                                <img class="help_tip" data-tip="<?php echo $desc; ?>" src="<?php echo WC()->plugin_url(); ?>/assets/images/help.png" height="16" width="16"/>
                            <?php endif;
                            break;

                        case 'select': ?>
                            <select id="<?php echo esc_attr( $field['name'] ) ?>" name="<?php echo esc_attr( $field['name'] ) ?>">
                                <?php foreach( $field['option'] as $option_key => $option_name ) : ?>
                                    <option value="<?php echo $option_key ?>" <?php selected( $option_key, $metas[ $field_key ] ); ?>><?php echo $option_name; ?></option>
                                <?php endforeach; ?>
                            </select>
                            <?php break;

                    case 'textarea' : ?>
                        <textarea id="<?php echo esc_attr( $field['name'] ) ?>" name="<?php echo esc_attr( $field['name'] ) ?>"><?php echo esc_html( $metas[ $field_key ] ); ?></textarea>
                        <?php break;

                        case 'checkbox': ?>
                            <input type="checkbox" id="<?php echo esc_attr( $field['name'] ) ?>" name="<?php echo esc_attr( $field['name'] ) ?>" value="yes" <?php checked( 'yes', $metas[$field_key] ) ?> />
                            <span><?php echo $desc ?></span>
                            <?php break;

                        default: ?>
                            <input type="<?php echo esc_attr( $field['type'] ) ?>" class="<?php echo $class ?>" id="<?php echo esc_attr( $field['name'] ) ?>" name="<?php echo esc_attr( $field['name'] ) ?>"
                                   value="<?php echo $metas[ $field_key ] ?>" <?php echo $attr ?>/>
                            <?php if( $desc ) : ?>
                                <img class="help_tip" data-tip="<?php echo $desc; ?>" src="<?php echo WC()->plugin_url(); ?>/assets/images/help.png" height="16" width="16"/>
                            <?php endif; ?>
                            <?php break;
                    endswitch; ?>
            </p>
            <?php endforeach; ?>
        </div>
    <?php endforeach; ?>
</div>